/*
 * Decompiled with CFR 0.152.
 */
package ice.browser;

import ice.browser.Bookmarks;
import ice.browser.HintDisplayer;
import ice.browser.ListDialog;
import ice.browser.Main;
import ice.browser.MessagePane;
import ice.browser.SearchDialog;
import ice.browser.SourceFrame;
import ice.browser.Tooltip;
import ice.debug.Debug;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.ProgressDetail;
import ice.pilots.html4.ThePilot;
import ice.ri.common.print.PrintHelper;
import ice.ri.common.print.PrintUtilities;
import ice.ri.common.print.awt.PageSetupDialog;
import ice.ri.common.print.awt.PrintPreviewDialog;
import ice.storm.ContentLoader;
import ice.storm.Hint;
import ice.storm.HistoryManager;
import ice.storm.Pilot;
import ice.storm.StormBase;
import ice.storm.StormPrinter;
import ice.storm.Viewport;
import ice.storm.ViewportGuiParams;
import ice.storm.print.StormPageFormat;
import ice.util.Defs;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import org.w3c.dom.events.EventListener;

class BrowserFrame
extends Frame
implements ActionListener,
WindowListener,
PropertyChangeListener {
    private Tooltip tooltip = null;
    private Bookmarks bookmarksDialog;
    static Frame theFrame = null;
    private StormBase base;
    private String viewportId;
    private Panel panel;
    private TextField loc;
    private Label status;
    private Label stats;
    private Button back;
    private Button forward;
    private Button info;
    private Button gc;
    private Button printButton;
    private Button stopButton;
    private Button home;
    private Button reload;
    private Button bookmarks;
    private Button addBookmark;
    private Button viewSource;
    private Button zoomIn;
    private Button zoomOut;
    private Button zoomNormal;
    private String prevLoc = "";
    private MenuItem mnew;
    private MenuItem mprint;
    private MenuItem mprintSetup;
    private MenuItem mprintPreview;
    private MenuItem mclose;
    private MenuItem mexit;
    private MenuItem mfind;
    private MenuItem maddbookmark;
    private MenuItem mbookmarks;
    private MenuItem mzoomin;
    private MenuItem mzoomout;
    private MenuItem mzoom100;
    private MenuItem msource;
    private MenuItem mabout;
    private MenuItem mlist;
    private MenuItem mgc;
    private StormPageFormat stormPageFormat;
    static boolean verbose = false;
    private char[] sourceBuffer;
    private String sourceEnc;
    private int lastProgress = 0;

    public BrowserFrame(StormBase b, Viewport viewport) {
        super("ICEbrowser - " + viewport.getName());
        this.base = b;
        this.viewportId = viewport.getId();
        this.setLayout(new BorderLayout());
        this.addWindowListener(this);
        this.stormPageFormat = new StormPageFormat();
        this.base.addPropertyChangeListener((PropertyChangeListener)this, this.viewportId);
        Font bf = new Font("SansSerif", 0, 11);
        this.back = this.createButton("<<", bf);
        this.back.setEnabled(false);
        this.forward = this.createButton(">>", bf);
        this.forward.setEnabled(false);
        this.reload = this.createButton("reload", bf);
        this.stopButton = this.createButton("stop", bf);
        this.home = this.createButton("home", bf);
        this.addBookmark = this.createButton("add", bf);
        this.bookmarks = this.createButton("bookmarks", bf);
        this.viewSource = this.createButton("source", bf);
        this.info = this.createButton("info", bf);
        this.printButton = this.createButton("print", bf);
        this.gc = this.createButton("gc", bf);
        this.zoomIn = this.createButton("zoom in", bf);
        this.zoomOut = this.createButton("zoom out", bf);
        this.zoomNormal = this.createButton("100%", bf);
        this.loc = new TextField("", 30);
        this.loc.setFont(bf);
        this.loc.setBackground(Color.white);
        this.loc.setForeground(Color.blue);
        this.loc.addActionListener(this);
        this.status = new Label("", 0);
        this.status.setFont(bf);
        this.status.setForeground(Color.white);
        this.status.setBackground(Color.black);
        this.stats = new Label("", 2);
        this.stats.setFont(bf);
        this.stats.setForeground(Color.white);
        this.stats.setBackground(Color.black);
        boolean pjavaMode = Defs.sysPropertyBoolean((String)"ice.browser.pjava");
        int w = Main.reqWidth;
        int h = Main.reqHeight;
        int left = -1;
        int top = -1;
        boolean canResize = true;
        boolean showLocation = true;
        boolean showMenu = true;
        boolean showStatus = true;
        boolean showToolbar = true;
        ViewportGuiParams params = viewport.getGuiParams();
        if (params != null) {
            if (params.width >= 0) {
                w = params.width + 4;
            }
            if (params.height >= 0) {
                h = params.height + 28;
            }
            left = params.left;
            top = params.top;
            canResize = params.resizable;
            showLocation = params.location;
            showMenu = params.menubar;
            showStatus = params.status;
            showToolbar = params.toolbar;
        }
        Panel p = new Panel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        p.setLayout(gridbag);
        if (showToolbar) {
            c.fill = 0;
            gridbag.setConstraints(this.back, c);
            p.add(this.back);
            gridbag.setConstraints(this.forward, c);
            p.add(this.forward);
            gridbag.setConstraints(this.stopButton, c);
            p.add(this.stopButton);
            gridbag.setConstraints(this.reload, c);
            p.add(this.reload);
            if (pjavaMode) {
                gridbag.setConstraints(this.gc, c);
                p.add(this.gc);
            }
        }
        if (showLocation) {
            c.fill = 2;
            c.gridwidth = 0;
            c.weightx = 1.0;
            gridbag.setConstraints(this.loc, c);
            p.add(this.loc);
        }
        Panel p2 = new Panel();
        gridbag = new GridBagLayout();
        c = new GridBagConstraints();
        p2.setLayout(gridbag);
        if (showStatus) {
            c.fill = 2;
            c.weightx = 1.0;
            gridbag.setConstraints(this.status, c);
            p2.add(this.status);
            c.fill = 0;
            c.weightx = 0.0;
            c.gridwidth = 0;
            gridbag.setConstraints(this.stats, c);
            p2.add(this.stats);
        }
        Panel p3 = new Panel();
        p3.setLayout(new BorderLayout());
        if (showLocation || showToolbar) {
            p3.add((Component)p, "South");
        }
        if (showStatus) {
            p3.add((Component)p2, "North");
        }
        if (showLocation || showToolbar || showStatus) {
            this.add((Component)p3, "South");
        }
        this.panel = new Panel();
        this.panel.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.panel, "Center");
        this.runUpdateStatsLoop();
        if (theFrame == null) {
            theFrame = this;
        }
        if (!pjavaMode) {
            this.tooltip = new Tooltip(this, this.base);
            this.bookmarksDialog = new Bookmarks((Frame)this, this.base, this.viewportId);
            if (showMenu) {
                this.buildMenu();
            }
        }
        this.setSize(w, h);
        if (left >= 0 && top >= 0) {
            this.setLocation(left, top);
        }
        if (Defs.sysPropertyBoolean((String)"ice.browser.winontop")) {
            this.toFront();
        } else {
            this.toBack();
        }
        if (!canResize) {
            this.setResizable(false);
        }
    }

    private void buildMenu() {
        MenuBar mb = new MenuBar();
        this.setMenuBar(mb);
        Menu mfile = new Menu("File");
        Menu medit = new Menu("Edit");
        Menu mview = new Menu("View");
        Menu mdebug = new Menu("Debug");
        mb.add(mfile);
        mb.add(medit);
        mb.add(mview);
        mb.add(mdebug);
        this.mnew = this.createMenuItem("New Window");
        this.mprintSetup = this.createMenuItem("Page Setup");
        this.mprintPreview = this.createMenuItem("Print Preview");
        this.mprint = this.createMenuItem("Print...");
        this.mclose = this.createMenuItem("Close");
        this.mexit = this.createMenuItem("Exit");
        mfile.add(this.mnew);
        mfile.add(new MenuItem("-"));
        mfile.add(this.mprintSetup);
        mfile.add(this.mprintPreview);
        mfile.add(this.mprint);
        mfile.add(new MenuItem("-"));
        mfile.add(this.mclose);
        mfile.add(this.mexit);
        this.mfind = this.createMenuItem("Find...");
        medit.add(this.mfind);
        this.maddbookmark = this.createMenuItem("Add Bookmark");
        this.mbookmarks = this.createMenuItem("Bookmarks...");
        this.mzoomin = this.createMenuItem("Zoom In");
        this.mzoomout = this.createMenuItem("Zoom Out");
        this.mzoom100 = this.createMenuItem("Zoom 100%");
        this.msource = this.createMenuItem("Page Source");
        mview.add(this.maddbookmark);
        mview.add(this.mbookmarks);
        mview.add(new MenuItem("-"));
        mview.add(this.mzoomin);
        mview.add(this.mzoomout);
        mview.add(this.mzoom100);
        mview.add(new MenuItem("-"));
        mview.add(this.msource);
        this.mabout = this.createMenuItem("About");
        this.mlist = this.createMenuItem("Pilot List");
        this.mgc = this.createMenuItem("Force GC");
        mdebug.add(this.mabout);
        mdebug.add(this.mlist);
        mdebug.add(this.mgc);
    }

    private Button createButton(String label, Font f) {
        Button b = new Button(label);
        b.setFont(f);
        b.setBackground(Color.lightGray);
        b.addActionListener(this);
        return b;
    }

    private MenuItem createMenuItem(String label) {
        MenuItem m = new MenuItem(label);
        m.addActionListener(this);
        return m;
    }

    Panel getPanel() {
        return this.panel;
    }

    final void runUpdateStatsLoop() {
        this.updateStats();
        this.base.runOnEventThreadLater(new Runnable(){

            public void run() {
                BrowserFrame.this.runUpdateStatsLoop();
            }
        }, 2000L);
    }

    private void updateStats() {
        int t1 = (int)(Runtime.getRuntime().freeMemory() >> 10);
        int t2 = (int)(Runtime.getRuntime().totalMemory() >> 10);
        int t3 = Thread.activeCount();
        String s = " mem: " + (t2 - t1) + "k/" + t2 + "k, threads: " + t3 + "  ";
        this.stats.setText(s);
    }

    private void updateProgress(String name, int value, int total) {
        if (total > 0) {
            this.status.setText("loading " + name + " (" + value * 100 / total + "%)");
        } else {
            this.status.setText("loading " + name + " (" + value + " bytes)");
        }
    }

    public void actionPerformed(ActionEvent e) {
        Viewport v;
        Pilot p;
        Object src = e.getSource();
        if (src == this.loc) {
            int colon;
            String vname = this.viewportId;
            String str = this.loc.getText();
            int i = str.indexOf(124);
            if (i == 0 && (i = str.indexOf(124, 1)) >= 1) {
                vname = str.substring(1, i);
                str = str.substring(i + 1);
            }
            if ((colon = str.indexOf(58)) < 0) {
                int slash = str.indexOf(47);
                str = slash == 0 ? "file://localhost" + str : "http://" + str;
            }
            this.base.renderContent(str, null, vname);
            if (!vname.equals(this.viewportId)) {
                this.loc.setText(this.prevLoc);
            }
        } else if (src == this.reload) {
            this.base.getHistoryManager().reload(this.viewportId);
        } else if (src == this.gc || src == this.mgc) {
            System.gc();
            this.updateStats();
        } else if (src == this.back) {
            this.base.getHistoryManager().goBack(this.viewportId);
        } else if (src == this.forward) {
            this.base.getHistoryManager().goForward(this.viewportId);
        } else if (src == this.info || src == this.mlist) {
            ListDialog d = new ListDialog((Frame)this, this.base);
            d.setVisible(true);
        } else if (src == this.printButton || src == this.mprint) {
            Viewport view = this.base.findViewportByName(this.viewportId);
            if (view != null) {
                StormPrinter mainViewPrinter = view.getPilot().createPrinter();
                if (mainViewPrinter != null) {
                    mainViewPrinter.dispose();
                    PrintHelper printHelper = PrintUtilities.getPrintHelper(view, this.stormPageFormat);
                    printHelper.print(theFrame);
                    view.getContainer().validate();
                } else {
                    MessagePane warningDialog = new MessagePane((Frame)this, "Printing is not supported for this content type");
                    warningDialog.show();
                }
            }
        } else if (src == this.mprintPreview) {
            Viewport view = this.base.findViewportByName(this.viewportId);
            if (view != null) {
                StormPrinter mainViewPrinter = view.getPilot().createPrinter();
                if (mainViewPrinter != null) {
                    mainViewPrinter.dispose();
                    PrintPreviewDialog previewDialog = new PrintPreviewDialog((Frame)this, view, this.stormPageFormat);
                    this.base.addPropertyChangeListener((PropertyChangeListener)previewDialog, this.viewportId);
                    this.stormPageFormat = previewDialog.showDialog();
                    this.base.removePropertyChangeListener((PropertyChangeListener)previewDialog, this.viewportId);
                    previewDialog.dispose();
                } else {
                    MessagePane warningDialog = new MessagePane((Frame)this, "Printing is not supported for this content type");
                    warningDialog.show();
                }
            }
        } else if (src == this.mprintSetup) {
            Viewport view = this.base.findViewportByName(this.viewportId);
            PageSetupDialog pageSetup = new PageSetupDialog(this, view, this.stormPageFormat);
            this.stormPageFormat = pageSetup.showDialog();
        } else if (src == this.stopButton) {
            this.base.stopLoading(this.viewportId);
        } else if (src == this.home) {
            this.base.renderContent("http://www.icesoft.com/", null, this.viewportId);
        } else if (src == this.zoomNormal || src == this.mzoom100) {
            Viewport v2 = this.base.findViewportByName(this.viewportId);
            v2.setZoom(256);
        } else if (src == this.zoomIn || src == this.mzoomin) {
            Viewport v3 = this.base.findViewportByName(this.viewportId);
            v3.setZoom(v3.getZoom() + 16);
        } else if (src == this.zoomOut || src == this.mzoomout) {
            Viewport v4 = this.base.findViewportByName(this.viewportId);
            v4.setZoom(v4.getZoom() - 16);
        } else if ((src == this.addBookmark || src == this.maddbookmark) && this.bookmarksDialog != null) {
            Viewport v5 = this.base.findViewportByName(this.viewportId);
            Pilot p2 = v5.getPilot();
            if (p2 != null) {
                String loc = this.prevLoc;
                String title = this.prevLoc;
                if (p2 instanceof ThePilot) {
                    ThePilot p22 = (ThePilot)p2;
                    title = ((DDocument)p22.getDocument()).getTitle();
                }
                if (title == null || title.length() == 0) {
                    title = loc;
                }
                this.bookmarksDialog.addBookmark(title, loc);
            }
        } else if ((src == this.bookmarks || src == this.mbookmarks) && this.bookmarksDialog != null) {
            this.bookmarksDialog.setVisible(!this.bookmarksDialog.isVisible());
        } else if (src == this.viewSource || src == this.msource) {
            new SourceFrame(this.sourceBuffer, this.sourceEnc);
        } else if (src == this.mnew) {
            this.base.clearContent("text/html", "_blank");
        } else if (src == this.mabout) {
            this.base.renderContent("about:", null, "_about");
        } else if (src == this.mclose) {
            this.base.closeViewport(this.viewportId);
        } else if (src == this.mexit) {
            Main.exit(this.base);
        } else if (src == this.mfind && (p = (v = this.base.findViewportByName(this.viewportId)).getPilot()) instanceof ThePilot) {
            new SearchDialog((Frame)this, v);
        }
    }

    private void resetSource() {
        this.sourceBuffer = null;
        this.sourceEnc = null;
        this.lastProgress = 0;
    }

    public void propertyChange(PropertyChangeEvent e) {
        Viewport v = (Viewport)e.getSource();
        boolean isMyView = v.getId().equals(this.viewportId);
        String name = e.getPropertyName();
        if (name == "hint") {
            Hint hint = (Hint)e.getNewValue();
            HintDisplayer.display(hint, this.base, v);
        } else if (name == "history") {
            String val = (String)e.getNewValue();
            if (val == "modified") {
                HistoryManager m = this.base.getHistoryManager();
                this.back.setEnabled(m.canGoBack(this.viewportId));
                this.forward.setEnabled(m.canGoForward(this.viewportId));
            }
        } else if (name == "title") {
            if (isMyView) {
                String val = (String)e.getNewValue();
                this.setTitle("ICEbrowser - " + val);
            }
        } else if (name == "location") {
            if (isMyView) {
                String val = (String)e.getNewValue();
                this.loc.setText(val);
                this.prevLoc = this.loc.getText();
            }
        } else if (name == "statusLine") {
            String val = (String)e.getNewValue();
            this.status.setText(val);
        } else if (name == "contentLoadingProgress") {
            String val = (String)e.getNewValue();
            int l = 0;
            try {
                int idx1 = val.indexOf(32);
                int idx2 = val.indexOf(32, idx1 + 1);
                l = Integer.parseInt(val.substring(idx1 + 1, idx2));
                int t = Integer.parseInt(val.substring(idx2 + 1));
                this.updateProgress(val.substring(0, idx1), l, t);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (isMyView && l != this.lastProgress) {
                this.lastProgress = l;
                ProgressDetail det = (ProgressDetail)e.getOldValue();
                if (det == null) {
                    return;
                }
                char[] buf = new char[det.getNumCharacters()];
                det.copyCharacters(buf);
                this.sourceEnc = det.getEncoding();
                if (this.sourceBuffer == null) {
                    this.sourceBuffer = buf;
                } else {
                    int psz = this.sourceBuffer.length;
                    int nsz = buf.length;
                    char[] tmp = new char[psz + nsz];
                    System.arraycopy(this.sourceBuffer, 0, tmp, 0, psz);
                    System.arraycopy(buf, 0, tmp, psz, nsz);
                    this.sourceBuffer = tmp;
                }
            }
        } else if (name == "outstandingImages") {
            String val = (String)e.getNewValue();
            if (val.equals("0")) {
                this.status.setText("loading images: done");
            } else {
                this.status.setText("loading images: " + val + " left");
            }
        } else if (name == "contentLoading") {
            String val = (String)e.getNewValue();
            if (val == "error") {
                IOException ex;
                String message = "loading error";
                ContentLoader cl = (ContentLoader)e.getOldValue();
                if (cl != null && verbose && (ex = cl.getException()) != null) {
                    Debug.ex((Throwable)ex);
                    message = ex.toString();
                }
                this.status.setText(v.getName() + ": " + message);
            } else {
                if (val == "begin" && isMyView) {
                    this.resetSource();
                }
                this.status.setText(name + ": " + val);
            }
        } else if (name == "pilotLoading") {
            Pilot p;
            String val = (String)e.getNewValue();
            if (val == "end" && this.tooltip != null && (p = v.getPilot()) instanceof ThePilot) {
                ThePilot pp = (ThePilot)p;
                pp.addPersistentDOMEventListener("mouseover", (EventListener)this.tooltip, true);
                pp.addPersistentDOMEventListener("mouseout", (EventListener)this.tooltip, true);
            }
            this.status.setText(name + ": " + val);
        } else if (name != "contentRendering") {
            String val = (String)e.getNewValue();
            this.status.setText(v.getName() + ": " + name + " " + val);
        }
    }

    public void windowClosing(WindowEvent e) {
        this.base.closeViewport(this.viewportId);
    }

    public void windowClosed(WindowEvent ev) {
    }

    public void windowOpened(WindowEvent ev) {
    }

    public void windowIconified(WindowEvent ev) {
    }

    public void windowDeiconified(WindowEvent ev) {
    }

    public void windowActivated(WindowEvent ev) {
    }

    public void windowDeactivated(WindowEvent ev) {
    }

    static {
        String tmp = Defs.sysProperty((String)"ice.debug.printstacktrace");
        if (tmp != null && tmp.equals("true")) {
            verbose = true;
        }
    }
}

