/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.excel.datavalidation;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.validator.EnumValidator;
import coldfusion.cloud.validator.IntegerRangeValidator;
import coldfusion.excel.datavalidation.StreamingReadConfig;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class StreamingSpreadsheetReadMetadata {
    static StreamingSpreadsheetReadMetadata instance = null;
    FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    ConsumerMap<StreamingReadConfig> consumerMap = new ConsumerMap();
    String[] allowedFormatNames = new String[]{"html", "csv", "query"};
    Set<String> allowedReadFormats = new HashSet<String>(Arrays.asList(this.allowedFormatNames));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StreamingSpreadsheetReadMetadata getInstance() {
        if (instance != null) return instance;
        Class<StreamingSpreadsheetReadMetadata> clazz = StreamingSpreadsheetReadMetadata.class;
        synchronized (StreamingSpreadsheetReadMetadata.class) {
            instance = new StreamingSpreadsheetReadMetadata();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private StreamingSpreadsheetReadMetadata() {
        this.consumerMap.put((Object)"sheetName", new ConsumerValidator((readConfig, value) -> readConfig.setSheetName(this.cast.getStringProperty(value)), null));
        this.consumerMap.put((Object)"rows", new ConsumerValidator((readConfig, value) -> readConfig.setRows(this.cast.getStringProperty(value)), null));
        this.consumerMap.put((Object)"columns", new ConsumerValidator((readConfig, value) -> readConfig.setColumns(this.cast.getStringProperty(value)), null));
        this.consumerMap.put((Object)"columnNames", new ConsumerValidator((readConfig, value) -> readConfig.setColumnNames(this.cast.getStringProperty(value)), null));
        this.consumerMap.put((Object)"destinationFilePath", new ConsumerValidator((readConfig, value) -> readConfig.setDestinationFilePath(this.cast.getStringProperty(value)), null));
        this.consumerMap.put((Object)"headerRow", new ConsumerValidator((readConfig, value) -> readConfig.setHeaderRow(this.cast.getIntegerProperty(value)), null));
        this.consumerMap.put((Object)"excludeHeaderRow", new ConsumerValidator((readConfig, value) -> readConfig.setExcludeHeaderRow(this.cast.getBooleanProperty(value)), null));
        this.consumerMap.put((Object)"format", new ConsumerValidator((readConfig, value) -> readConfig.setFormat(this.cast.getStringProperty(value).toLowerCase()), Collections.singletonList(new EnumValidator(this.allowedReadFormats, "format"))));
        this.consumerMap.put((Object)"randomAccessWindowSize", new ConsumerValidator((readConfig, value) -> readConfig.setRandomAccessWindowSize(this.cast.getIntegerProperty(value)), Collections.singletonList(new IntegerRangeValidator("randomAccessWindowSize", Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)))));
    }

    public ConsumerMap<StreamingReadConfig> getConsumerMap() {
        return this.consumerMap;
    }
}

