/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.websocket.server.core;

import coldfusion.runtime.OleDateTime;
import coldfusion.tagext.net.websocket.server.core.AbstractClientConnection;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.net.InetSocketAddress;

public class ClientConnection
extends AbstractClientConnection {
    private final ChannelHandlerContext channelHandlerContext;

    public ClientConnection(ChannelHandlerContext ctx, HttpHeaders headers) {
        this.channelHandlerContext = ctx;
        this.requestHeaders = headers;
        this.connectionTime = new OleDateTime(System.currentTimeMillis());
        this.setConnectionId(ctx);
        this.populateConnectionInfo();
    }

    @Override
    public void writeData(Object aDataPacket) {
        if (this.channelHandlerContext.channel().isActive()) {
            this.channelHandlerContext.channel().writeAndFlush((Object)new TextWebSocketFrame(aDataPacket.toString()));
        }
    }

    @Override
    public Object writeDataAsync(Object aDataPacket) {
        if (this.channelHandlerContext.channel().isActive()) {
            return null;
        }
        return null;
    }

    @Override
    public void setConnectionId(Object context) {
        ChannelHandlerContext handleContext = (ChannelHandlerContext)context;
        InetSocketAddress address = (InetSocketAddress)handleContext.channel().remoteAddress();
        this.connectionId = address.getHostName() + address.getPort();
        this.connectionId = "" + this.connectionId.hashCode();
        if (this.connectionId.charAt(0) == '-') {
            this.connectionId = this.connectionId.substring(1);
        }
    }
}

