/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.util.vmpackcreation;

import com.zerog.util.vmpackcreation.JVMPack;
import com.zerog.util.vmpackcreation.JVMPackCreatorImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class WindowsJVMPackCreatorImpl
extends JVMPackCreatorImpl {
    private JVMPack jvmPack;
    private long totalSizeOfFilesToZip = 0L;
    private long totalSizeProcessed = 0L;

    public WindowsJVMPackCreatorImpl(JVMPack jVMPack) {
        this.jvmPack = jVMPack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createJVMPack() {
        block13: {
            if (this.jvmPack != null) {
                try {
                    File file;
                    Properties properties = this.createVMProperties(this.jvmPack);
                    boolean bl = this.writeJVMPropertiesToFile(properties, this.getNameOfVMProperties(), this.jvmPack.getLocationToSaveVMPack());
                    if (!bl) break block13;
                    this.adjustSourcePathForVMPackIfJDKWasSupplied(this.jvmPack);
                    this.notifyObservers(new Integer("0"));
                    File file2 = this.createVMDotZip(this.jvmPack, this.jvmPack.getSourceLocationOfVMPack());
                    File file3 = new File(this.jvmPack.getLocationToSaveVMPack(), this.getNameOfVMProperties());
                    this.notifyObservers(new Integer("60"));
                    String string = this.jvmPack.getLocationToSaveVMPack() + File.separator + this.jvmPack.getNameOfVMPack();
                    if (!string.endsWith(".vm")) {
                        string = string + ".vm";
                    }
                    if (!(file = new File(string)).exists()) {
                        file.createNewFile();
                    }
                    ZipOutputStream zipOutputStream = null;
                    FileOutputStream fileOutputStream = null;
                    try {
                        fileOutputStream = new FileOutputStream(file);
                        zipOutputStream = new ZipOutputStream(fileOutputStream);
                        this.addFilesInDirToZipStream(zipOutputStream, file2, false, "");
                        this.notifyObservers(new Integer("95"));
                        this.addFilesInDirToZipStream(zipOutputStream, file3, false, "");
                        zipOutputStream.flush();
                    }
                    finally {
                        if (zipOutputStream != null) {
                            zipOutputStream.close();
                            fileOutputStream = null;
                            zipOutputStream = null;
                            try {
                                Thread.currentThread();
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {}
                            file2.delete();
                            file3.delete();
                        }
                    }
                    this.notifyObservers(new Integer("100"));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createVMDotZip(JVMPack jVMPack, String string) throws IOException, FileNotFoundException {
        if (new File(string).exists() && new File(string + File.separator + "bin" + File.separator + "java.exe").exists()) {
            String string2;
            File file;
            if (!new File(string).getName().equals("jre")) {
                new File(string).renameTo(new File("jre"));
            }
            if (!(file = new File(string2 = jVMPack.getLocationToSaveVMPack() + File.separator + "vm.zip")).exists()) {
                file.createNewFile();
            }
            this.totalSizeOfFilesToZip = this.determineTotalNumberOfFilesToZip(new File(jVMPack.getSourceLocationOfVMPack()));
            ZipOutputStream zipOutputStream = null;
            try {
                zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
                this.addFilesInDirToZipStream(zipOutputStream, new File(jVMPack.getSourceLocationOfVMPack()), true, jVMPack.getSourceLocationOfVMPack());
                zipOutputStream.flush();
            }
            finally {
                if (zipOutputStream != null) {
                    zipOutputStream.close();
                    zipOutputStream = null;
                }
            }
            return file;
        }
        return null;
    }

    private long determineTotalNumberOfFilesToZip(File file) {
        long l = 0L;
        if (file.isFile()) {
            l += file.length();
        } else {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                l += this.determineTotalNumberOfFilesToZip(fileArray[i]);
            }
        }
        return l;
    }

    private void addFilesInDirToZipStream(ZipOutputStream zipOutputStream, File file, boolean bl, String string) throws IOException {
        if (file.isFile()) {
            Object object;
            String string2 = file.getName();
            if (bl && (object = this.relativizePath(string, file.getAbsolutePath())) != null) {
                string2 = object;
            }
            zipOutputStream.putNextEntry(new ZipEntry(string2));
            object = new FileInputStream(file);
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = ((FileInputStream)object).read(byArray)) > 0) {
                zipOutputStream.write(byArray, 0, n);
            }
            ((FileInputStream)object).close();
            zipOutputStream.closeEntry();
            if (bl) {
                this.totalSizeProcessed += file.length();
                int n2 = (int)(this.totalSizeProcessed * 60L / this.totalSizeOfFilesToZip);
                this.notifyObservers(new Integer(n2));
            }
        } else {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                this.addFilesInDirToZipStream(zipOutputStream, fileArray[i], bl, string);
            }
        }
    }

    private String relativizePath(String string, String string2) {
        if (string2.length() < string.length()) {
            return null;
        }
        if (!string2.startsWith(string)) {
            return null;
        }
        String string3 = string2.substring(string.length());
        if (string3.startsWith(File.separator)) {
            string3 = string3.substring(1);
        }
        return string3;
    }

    @Override
    public String getVMExePath() {
        return "bin\\java.exe";
    }

    @Override
    public String getVMPlatformFlavor(JVMPack jVMPack) {
        if (jVMPack.getOperatingSystem() == 7) {
            return "win64";
        }
        return "win32";
    }

    @Override
    public String getVMPlatformName() {
        return "windows";
    }
}

