/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.installer;

import com.zerog.ia.installer.InstallPiece;
import com.zerog.ia.installer.Installer;
import com.zerog.ia.installer.UpgradeConfiguration;
import com.zerog.ia.installer.actions.Exec;
import com.zerog.ia.installer.actions.Subuninstaller;
import com.zerog.ia.installer.rules.CompareVariable;
import com.zerog.ia.installer.util.VariableManager;
import com.zerog.registry.FeatureDescriptor;
import com.zerog.registry.UUID;
import com.zerog.util.IAResourceBundle;
import com.zerog.util.ZGUtil;
import java.io.File;
import java.io.Serializable;
import java.util.Enumeration;

public class UpgradableProduct {
    private UpgradeConfiguration aa = null;
    private Flexeraapu ab = null;

    public UpgradableProduct(Flexeraapu flexeraapu, UpgradeConfiguration upgradeConfiguration) {
        this.ab = flexeraapu;
        this.aa = upgradeConfiguration;
    }

    public void addUninstallProductActionToEndOfPreInstallPhase(Installer installer) {
        Serializable serializable;
        String string = this.getUninstallerLocationFromUninstallComponent();
        File file = new File(string);
        boolean bl = false;
        if (ZGUtil.getRunningPure()) {
            serializable = new File(file.getParent(), "uninstaller.jar");
            bl = ((File)serializable).exists();
        } else {
            bl = file.exists();
        }
        if (bl) {
            serializable = new Subuninstaller();
            if (!ZGUtil.MACOSX) {
                ((Exec)serializable).setCommandLineArgs(file.getParent() + " -Duninstall.part.of.upgrade=true");
            } else {
                ((Exec)serializable).setCommandLineArgs(file.getParent());
            }
            ((Subuninstaller)serializable).setUIMode(2);
            ((Exec)serializable).setShowIndeterminateDialog(true);
            ((Exec)serializable).setDialogLabel("Uninstalling older installation : " + this.ab.getName() + "-" + this.ab.getVersion());
            ((Exec)serializable).setStderrVar("$EXECUTE_STDOUT$");
            ((Exec)serializable).setStdoutVar("$EXECUTE_STDERR$");
            ((InstallPiece)serializable).setInstaller(installer);
            ((Exec)serializable).setShowPleaseWaitPanel(true);
            ((Subuninstaller)serializable).setWaitForProcess(true);
            ((Exec)serializable).setSuppressConsoleWindow(true);
            ((Subuninstaller)serializable).setPartOfUpgrade(true);
            ((Subuninstaller)serializable).setProductBeingUninstalledAsPartOfUpgrade(string);
            ((Exec)serializable).setExitCodeVar("$IA_INTERNAL_UPGRADE_UNINSTALL_EXITCODE$");
            int[] nArray = Flexeraaji.aa();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < nArray.length; ++i) {
                CompareVariable compareVariable = new CompareVariable();
                compareVariable.setOperands("$IA_INTERNAL_UPGRADE_UNINSTALL_EXITCODE$", "" + nArray[i]);
                compareVariable.setOperation("does not equal");
                ((InstallPiece)serializable).addRule(compareVariable);
                if (i < nArray.length - 1) {
                    stringBuffer.append(compareVariable.getRuleId() + " && ");
                    continue;
                }
                stringBuffer.append(compareVariable.getRuleId());
            }
            ((InstallPiece)serializable).setRuleExpression(stringBuffer.toString());
            installer.getPreInstallActions().add(serializable);
            ((InstallPiece)serializable).setDescription("Uninstalling the product : " + this.ab.getName() + " " + this.ab.getVersion());
        } else {
            VariableManager.getInstance().setVariable("$IA_INTERNAL_UPGRADE_UNINSTALL_EXITCODE$", "8002");
        }
    }

    public String getUninstallerPath() {
        return this.ab.getInstallationPath();
    }

    public UUID getProductCode() {
        return this.ab.ab();
    }

    public UUID getUpgradeCode() {
        return this.aa.getUpgradeCode();
    }

    public String getVersion() {
        return this.ab.getVersion();
    }

    public UpgradeConfiguration getUpgradeConfigurationToWhichTheInstanceBelongsTo() {
        return this.aa;
    }

    public String getNameOfProductInstance() {
        return this.ab.getName();
    }

    public Flexeraapu getProductDescriptor() {
        return this.ab;
    }

    public String getUninstallerLocationFromUninstallComponent() {
        String string = null;
        if (this.ab != null) {
            Flexeraapx flexeraapx = Flexeraap_.ak().al();
            Enumeration enumeration = flexeraapx.al(this.ab);
            while (enumeration != null && enumeration.hasMoreElements()) {
                FeatureDescriptor featureDescriptor = (FeatureDescriptor)enumeration.nextElement();
                Enumeration enumeration2 = flexeraapx.an(featureDescriptor);
                while (enumeration2 != null && enumeration2.hasMoreElements()) {
                    Flexeraapq flexeraapq = (Flexeraapq)enumeration2.nextElement();
                    if (!flexeraapq.getName().equals("InstallAnywhere Uninstall Component")) {
                        if (!flexeraapq.getName().equals(IAResourceBundle.getValue("Designer.Util.DesignerUtil.installAnywhereUninstallComponent"))) continue;
                    }
                    string = flexeraapq.getInstallationPath();
                }
            }
        }
        return string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        UpgradableProduct upgradableProduct = (UpgradableProduct)object;
        return upgradableProduct.getUninstallerPath().equals(this.getUninstallerPath()) && upgradableProduct.getNameOfProductInstance().equals(this.getNameOfProductInstance()) && upgradableProduct.getVersion().equals(this.getVersion());
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.getUninstallerPath() == null ? 0 : this.getUninstallerPath().hashCode());
        n2 = 31 * n2 + (this.getNameOfProductInstance() == null ? 0 : this.getNameOfProductInstance().hashCode());
        n2 = 31 * n2 + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        return n2;
    }
}

