/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.common.java.lang;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.Collator;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class StringUtil {
    public static final String ESCAPED_COPYRIGHT_SYMBOL = "&copy";
    public static final String UNICODE_COPYRIGHT_SYMBOL = "\u00a9";
    public static final String ASCII_COPYRIGHT_SYMBOL = "(c)";
    private static char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static char[] hexvalues = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static boolean contains(String string, char c) {
        return string.indexOf(c) != -1;
    }

    public static String[] orderStrings(Enumeration enumeration) {
        return StringUtil.orderStrings(enumeration, false);
    }

    public static String[] orderStrings(String[] stringArray) {
        return StringUtil.orderStrings(stringArray, false);
    }

    public static String[] orderStrings(Enumeration enumeration, boolean bl) {
        Vector<String> vector = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            vector.addElement((String)enumeration.nextElement());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return StringUtil.orderStrings((String[])objectArray, bl);
    }

    public static String[] orderStrings(String[] stringArray, boolean bl) {
        Vector<String> vector = new Vector<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String string = stringArray[i];
            for (n = vector.size(); n > 0; --n) {
                String string2;
                String string3;
                String string4 = (String)vector.elementAt(n - 1);
                if (bl) {
                    string3 = string;
                    string2 = string4;
                } else {
                    string3 = string.toLowerCase();
                    string2 = string4.toLowerCase();
                }
                int n2 = bl ? string3.compareTo(string2) : Collator.getInstance().compare(string3, string2);
                if (n2 < 0) continue;
                vector.insertElementAt(string, n);
                n = -1;
            }
            if (n != 0) continue;
            vector.insertElementAt(string, 0);
        }
        Object[] objectArray = new String[stringArray.length];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static String getEscUnicodeRepresentation(char c) {
        StringBuffer stringBuffer = new StringBuffer();
        StringUtil.appendEscUnicodeRepresentation(c, stringBuffer);
        return stringBuffer.toString();
    }

    private static void appendEscUnicodeRepresentation(char c, StringBuffer stringBuffer) {
        if (c == '\\') {
            stringBuffer.append("\\\\");
        } else {
            stringBuffer.append("\\u");
            stringBuffer.append(hexDigit[c >> 12 & 0xF]);
            stringBuffer.append(hexDigit[c >> 8 & 0xF]);
            stringBuffer.append(hexDigit[c >> 4 & 0xF]);
            stringBuffer.append(hexDigit[c >> 0 & 0xF]);
        }
    }

    public static boolean containsUnicode(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c <= '~' && c >= ' ' && c != '\\') continue;
            return true;
        }
        return false;
    }

    public static String convertToEscapedUnicode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c > '~' || c < ' ' || c == '\\') {
                StringUtil.appendEscUnicodeRepresentation(c, stringBuffer);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String convertFromEscapedUnicode(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = -1;
        int n3 = 0;
        char c = '\u0000';
        int n4 = 0;
        while (n4 < n) {
            c = string.charAt(n4);
            if (c == '\\') {
                if (++n4 >= n) continue;
                c = string.charAt(n4);
                if (c == 'u') {
                    ++n4;
                    n2 = 0;
                    for (int i = 0; i < 4 && n4 < n; ++n4, ++i) {
                        c = string.charAt(n4);
                        n3 = StringUtil.getOffset(c);
                        if (n3 == -1) {
                            stringBuffer.append("\\u");
                            while (i > 0) {
                                stringBuffer.append(string.charAt(n4 - i));
                                --i;
                            }
                            n2 = -1;
                            break;
                        }
                        n2 = (n2 << 4) + c - n3;
                    }
                    if (n2 == -1) continue;
                    stringBuffer.append((char)n2);
                    continue;
                }
                stringBuffer.append(c);
                ++n4;
                continue;
            }
            stringBuffer.append(c);
            ++n4;
        }
        return stringBuffer.toString();
    }

    private static int getOffset(int n) {
        if (n >= 48 && n <= 57) {
            return 48;
        }
        if (n >= 65 && n <= 70) {
            return 55;
        }
        if (n >= 97 && n <= 102) {
            return 87;
        }
        return -1;
    }

    public static String cutOutExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n > -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String xor(String string, String string2) {
        block6: {
            block5: {
                if (string == null || string.trim().length() == 0) {
                    throw new IllegalArgumentException("The 'key' argument of the StringUtil.xorString method cannot be null, blank or empty.");
                }
                if (string2 == null) break block5;
                if (!string2.equals("")) break block6;
            }
            throw new IllegalArgumentException("The 'value' argument of the StringUtil.xorString method cannot be null or empty.");
        }
        StringBuffer stringBuffer = new StringBuffer(string2.length());
        for (int i = 0; i < string2.length(); ++i) {
            char c = string.charAt(i % string.length());
            char c2 = string2.charAt(i);
            char c3 = (char)(c ^ c2);
            stringBuffer.append(c3);
        }
        return stringBuffer.toString();
    }

    public static String byteArrayToHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(StringUtil.byteToHex(byArray[i]));
        }
        return stringBuffer.toString();
    }

    public static char[] byteToHex(byte by) {
        char[] cArray = new char[]{hexvalues[(by & 0xF0) >> 4], hexvalues[by & 0xF]};
        return cArray;
    }

    public static String replaceNonDisplayableChars(String string) {
        if (string == null) {
            return null;
        }
        try {
            string = new RE(UNICODE_COPYRIGHT_SYMBOL).subst(string, ASCII_COPYRIGHT_SYMBOL);
            return new RE(ESCAPED_COPYRIGHT_SYMBOL).subst(string, ASCII_COPYRIGHT_SYMBOL);
        }
        catch (RESyntaxException rESyntaxException) {
            Flexeraavf.av("StringUtil.replaceNonDisplayableChars: Parse error with regex: " + rESyntaxException.getMessage(), rESyntaxException);
            return string;
        }
    }

    public static int getLineCount(JTextArea jTextArea, int n) {
        int n2 = 4;
        try {
            if (jTextArea != null && jTextArea.getText().trim().length() > 0) {
                jTextArea.setBorder(BorderFactory.createCompoundBorder(jTextArea.getBorder(), BorderFactory.createEmptyBorder(0, 0, 0, 7)));
                String string = jTextArea.getText().trim();
                jTextArea.setText(string);
                Font font = jTextArea.getFont();
                jTextArea.setCaretPosition(0);
                int n3 = n - 230;
                jTextArea.setSize(n3, 300);
                FontRenderContext fontRenderContext = jTextArea.getFontMetrics(jTextArea.getFont()).getFontRenderContext();
                String[] stringArray = string.split("\n");
                n2 = 0;
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    AttributedString attributedString = new AttributedString(string2);
                    attributedString.addAttribute(TextAttribute.FONT, font);
                    AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
                    LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, fontRenderContext);
                    float f = (float)jTextArea.getSize().getWidth();
                    lineBreakMeasurer.setPosition(attributedCharacterIterator.getBeginIndex());
                    int n4 = 0;
                    while (lineBreakMeasurer.getPosition() < attributedCharacterIterator.getEndIndex()) {
                        lineBreakMeasurer.nextLayout(f);
                        ++n4;
                    }
                    n2 += n4;
                }
                jTextArea.setCaretPosition(0);
            }
        }
        catch (Throwable throwable) {
            return 4;
        }
        return n2;
    }
}

