/*
 * Decompiled with CFR 0.152.
 */
package com.flexera.ia.digestutils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.util.encoders.Base64;

public class DigestUtils {
    private static final String MD5 = "MD5";
    private static final String SHA1 = "SHA-1";
    private static final String UTF_8_ENCODING = "UTF-8";

    public static String calculateSHA1DigestBase64Encoded(File file) throws NoSuchAlgorithmException, FileNotFoundException, IOException {
        MessageDigest messageDigest = MessageDigest.getInstance(SHA1);
        byte[] byArray = DigestUtils.calculateMessageDigestOnly(file, messageDigest, false);
        String string = new String(Base64.encode((byte[])byArray), UTF_8_ENCODING);
        return string;
    }

    public static String calculateSHA1DigestBase64EncodedBasedOnLowerBufferSize(File file) throws NoSuchAlgorithmException, FileNotFoundException, IOException {
        MessageDigest messageDigest = MessageDigest.getInstance(SHA1);
        byte[] byArray = DigestUtils.calculateMessageDigestOnly(file, messageDigest, true);
        String string = new String(Base64.encode((byte[])byArray), UTF_8_ENCODING);
        return string;
    }

    public static String calculateSHA1DigestUtf8HexEncoded(File file) throws NoSuchAlgorithmException, IOException {
        MessageDigest messageDigest = MessageDigest.getInstance(SHA1);
        return DigestUtils.calculateDigestUtf8HexEncoded(file, messageDigest);
    }

    public static String calculateSHA1DigestHexEncoded(File file) throws NoSuchAlgorithmException, IOException {
        MessageDigest messageDigest = MessageDigest.getInstance(SHA1);
        return DigestUtils.calculateDigestHexEncoded(file, messageDigest);
    }

    public static String calculateMD5DigestHexEncoded(File file) throws NoSuchAlgorithmException, IOException {
        MessageDigest messageDigest = MessageDigest.getInstance(MD5);
        return DigestUtils.calculateDigestHexEncoded(file, messageDigest);
    }

    private static String calculateDigestHexEncoded(File file, MessageDigest messageDigest) throws IOException {
        byte[] byArray = DigestUtils.calculateMessageDigestOnly(file, messageDigest, false);
        StringBuffer stringBuffer = DigestUtils.convertToHexFormat(byArray);
        return stringBuffer.toString();
    }

    private static byte[] calculateMessageDigestOnly(File file, MessageDigest messageDigest, boolean bl) throws FileNotFoundException, IOException {
        System.gc();
        messageDigest.reset();
        DigestInputStream digestInputStream = new DigestInputStream(new FileInputStream(file), messageDigest);
        long l = file.length();
        int n = 1;
        if (l > 0x3200000L) {
            n = 51200;
        } else if (l > 0x100000L) {
            n = 1024;
        }
        if (bl) {
            n = Math.min(100, n);
        }
        byte[] byArray = new byte[1024 * n];
        int n2 = 0;
        int n3 = 0;
        while ((n2 = digestInputStream.read(byArray)) != -1) {
            if (!bl || ++n3 <= 1000) continue;
            System.out.print(".");
            n3 = 0;
        }
        digestInputStream.close();
        if (bl) {
            System.out.println();
        }
        byte[] byArray2 = messageDigest.digest();
        System.gc();
        return byArray2;
    }

    private static StringBuffer convertToHexFormat(byte[] byArray) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(cArray[byArray[i] >> 4 & 0xF]);
            stringBuffer.append(cArray[byArray[i] & 0xF]);
        }
        return stringBuffer;
    }

    private static String calculateDigestUtf8HexEncoded(File file, MessageDigest messageDigest) throws IOException {
        byte[] byArray = DigestUtils.calculateMessageDigestUtf8Only(file, messageDigest);
        StringBuffer stringBuffer = DigestUtils.convertToHexFormat(byArray);
        return stringBuffer.toString();
    }

    private static byte[] calculateMessageDigestUtf8Only(File file, MessageDigest messageDigest) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        String string;
        System.gc();
        messageDigest.reset();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), UTF_8_ENCODING));
        while ((string = bufferedReader.readLine()) != null) {
            messageDigest.update(string.getBytes(UTF_8_ENCODING), 0, string.length());
        }
        bufferedReader.close();
        byte[] byArray = messageDigest.digest();
        System.gc();
        return byArray;
    }
}

