/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.macos.toolbox;

import com.apple.mrj.jdirect.HandleStruct;
import com.apple.mrj.macos.generated.MemoryFunctions;
import com.apple.mrj.macos.generated.TextUtilFunctions;
import com.apple.mrj.macos.toolbox.DataPointer;
import com.apple.mrj.macos.toolbox.VMFunctions;

public class Handle
extends HandleStruct {
    protected Handle owner;

    public Handle(int n, boolean bl) {
        super(0);
        this.handle = this.allocateHandle(n, bl);
    }

    public Handle(int n) {
        super(n);
    }

    public Handle() {
        super(0);
    }

    protected Handle(int n, Handle handle) {
        super(n);
        this.owner = handle;
    }

    public void dispose() {
        if (this.owner == null && this.handle != 0) {
            Handle.disposeHandle(this.handle);
            this.handle = 0;
        }
    }

    protected void finalize() {
        this.dispose();
    }

    protected int allocateHandle(int n, boolean bl) throws NullPointerException {
        int n2;
        int n3 = n2 = bl ? Handle.newHandleClear(n) : Handle.newHandle(n);
        if (n2 == 0) {
            throw new NullPointerException();
        }
        return n2;
    }

    public int getSize() {
        return this.getHandleSize();
    }

    public int getHandleSize() {
        return MemoryFunctions.GetHandleSize(this.handle);
    }

    public void setHandleSize(int n) {
        MemoryFunctions.SetHandleSize(this.handle, n);
    }

    public void hLock() {
        MemoryFunctions.HLock(this.handle);
    }

    public void hUnlock() {
        MemoryFunctions.HUnlock(this.handle);
    }

    public void hPurge() {
        MemoryFunctions.HPurge(this.handle);
    }

    public void hNoPurge() {
        MemoryFunctions.HNoPurge(this.handle);
    }

    public DataPointer getPtr(int n) {
        return new DataPointer(VMFunctions.dereference(this.handle), n);
    }

    protected void freeHandle(int n) {
        Handle.disposeHandle(n);
    }

    public int munger(int n, byte[] byArray, int n2, byte[] byArray2, int n3) {
        return TextUtilFunctions.Munger(this.handle, n, byArray, n2, byArray2, n3);
    }

    private static int newHandle(int n) {
        return MemoryFunctions.NewHandle(n);
    }

    private static int newHandleClear(int n) {
        return MemoryFunctions.NewHandleClear(n);
    }

    private static void disposeHandle(int n) {
        MemoryFunctions.DisposeHandle(n);
    }

    public final boolean readBooleanAt(int n) {
        return this.getBooleanAt(n);
    }

    public final byte readByteAt(int n) {
        return this.getByteAt(n);
    }

    public final char readCharAt(int n) {
        return this.getCharAt(n);
    }

    public final short readShortAt(int n) {
        return this.getShortAt(n);
    }

    public final int readIntAt(int n) {
        return this.getIntAt(n);
    }

    public final long readLongAt(int n) {
        return this.getLongAt(n);
    }

    public final float readFloatAt(int n) {
        return this.getFloatAt(n);
    }

    public final double readDoubleAt(int n) {
        return this.getDoubleAt(n);
    }

    public final void writeBooleanAt(int n, boolean bl) {
        this.setBooleanAt(n, bl);
    }

    public final void writeByteAt(int n, byte by) {
        this.setByteAt(n, by);
    }

    public final void writeCharAt(int n, char c) {
        this.setCharAt(n, c);
    }

    public final void writeShortAt(int n, short s) {
        this.setShortAt(n, s);
    }

    public final void writeIntAt(int n, int n2) {
        this.setIntAt(n, n2);
    }

    public final void writeLongAt(int n, long l) {
        this.setLongAt(n, l);
    }

    public final void writeFloatAt(int n, float f) {
        this.setFloatAt(n, f);
    }

    public final void writeDoubleAt(int n, double d) {
        this.setDoubleAt(n, d);
    }
}

