/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.macos.toolbox;

import com.apple.mrj.macos.generated.ScrapFunctions;
import com.apple.mrj.macos.toolbox.ClipboardEnumerator;
import com.apple.mrj.macos.toolbox.Handle;
import com.apple.mrj.macos.toolbox.HandleInputStream;
import com.apple.mrj.macos.toolbox.MacOSError;
import com.apple.mrj.macos.toolbox.OSUtils;
import com.apple.mrj.macos.toolbox.ScrapHandle;
import com.apple.mrj.macos.toolbox.ScrapStuff;
import java.io.InputStream;

public class Clipboard {
    private ScrapStuff info = new ScrapStuff();

    public final short getScrapCount() {
        return this.info.getScrapCount();
    }

    public final short getScrapState() {
        return this.info.getScrapState();
    }

    public final int getScrapName() {
        return this.info.getScrapName();
    }

    public ClipboardEnumerator getTypes() {
        return new ClipboardEnumerator(this.info);
    }

    public InputStream getScrap(int n) {
        try {
            return new HandleInputStream(new ScrapHandle(n));
        }
        catch (MacOSError macOSError) {
            return null;
        }
    }

    public InputStream getScrap(String string) {
        return this.getScrap(OSUtils.makeOSType(string));
    }

    public Handle getScrapHandle(int n) {
        try {
            return new ScrapHandle(n);
        }
        catch (MacOSError macOSError) {
            return null;
        }
    }

    public Handle getScrapHandle(String string) {
        return this.getScrapHandle(OSUtils.makeOSType(string));
    }

    public byte[] getScrapData(int n) {
        Handle handle = this.getScrapHandle(n);
        if (handle != null) {
            return handle.getBytes();
        }
        return null;
    }

    public byte[] getScrapData(String string) {
        return this.getScrapData(OSUtils.makeOSType(string));
    }

    public void putScrap(int n, byte[] byArray) {
        ScrapFunctions.PutScrap(byArray.length, n, byArray);
        this.info = new ScrapStuff();
    }

    public void putScrap(String string, byte[] byArray) {
        this.putScrap(OSUtils.makeOSType(string), byArray);
    }

    public void putScrap(int n, Handle handle) {
        this.putScrap(n, handle.getBytes());
    }

    public void putScrap(String string, Handle handle) {
        this.putScrap(string, handle.getBytes());
    }

    public void clearScrap() {
        ScrapFunctions.ZeroScrap();
        this.info = new ScrapStuff();
    }
}

