/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.console;

import com.apple.mrj.console.Console;
import com.apple.mrj.console.ConsoleLocalization;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class Console
implements Runnable {
    protected ConsoleArea textArea = null;
    protected Object textAreaParam;
    protected InputPipe inputConsolePipe;
    protected OutputPipe outputConsolePipe;
    protected boolean useForInput;
    protected boolean useForOutput;
    protected Frame consoleFrame;
    protected boolean consoleShowing;

    Console(Object object, boolean bl, boolean bl2) throws IOException {
        this.textAreaParam = object;
        this.useForInput = bl;
        this.useForOutput = bl2;
        if (this.useForInput) {
            this.inputConsolePipe = new InputPipe();
        }
        if (this.useForOutput) {
            this.outputConsolePipe = new OutputPipe();
            new Thread((Runnable)this, "ConsoleThread").start();
        }
    }

    Console(Object object) throws IOException {
        this(object, true, true);
    }

    public InputStream getInputStream() {
        return this.inputConsolePipe;
    }

    public OutputStream getOutputStream() {
        return this.outputConsolePipe;
    }

    protected void commitInput(String string) {
        this.inputConsolePipe.pushText(string);
    }

    public void run() {
        while (true) {
            String string = this.outputConsolePipe.read();
            if (!this.consoleShowing) {
                this.showHideConsole(true);
            }
            this.textArea.addText(string);
        }
    }

    protected synchronized void createConsoleWindow() {
        ConsoleArea consoleArea = new ConsoleArea();
        if (this.textAreaParam instanceof Container) {
            ((Container)this.textAreaParam).add(consoleArea);
        } else {
            Rectangle rectangle;
            this.consoleFrame = new Frame(ConsoleLocalization.WINDOW_TITLE);
            this.consoleFrame.addWindowListener(new 1());
            this.consoleFrame.setMenuBar(consoleArea.constructMenuBar());
            this.consoleFrame.add(consoleArea);
            this.consoleFrame.setResizable(true);
            this.consoleFrame.pack();
            if (this.textAreaParam != null) {
                rectangle = (Rectangle)this.textAreaParam;
            } else {
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                int n = dimension.width;
                int n2 = dimension.height / 3;
                rectangle = new Rectangle(10, n2 * 2, n - 100, n2 - 30);
            }
            ((Component)this.consoleFrame).setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.consoleFrame.show();
            this.consoleFrame.toBack();
        }
        consoleArea.requestFocus();
        this.textArea = consoleArea;
    }

    protected synchronized void showHideConsole(boolean bl) {
        if (this.consoleShowing == bl) {
            return;
        }
        if (bl && this.textArea == null) {
            this.createConsoleWindow();
        } else if (this.consoleFrame != null) {
            ((Component)this.consoleFrame).setVisible(bl);
        }
        this.consoleShowing = bl;
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            Console.this.showHideConsole(false);
        }

        /* synthetic */ 1() {
        }
    }

    class ConsoleArea
    extends TextArea {
        protected int textLength = 0;
        protected int collectingOffset = 0;
        protected StringBuffer collecting = new StringBuffer();

        public ConsoleArea() {
            this.setFont(ConsoleLocalization.CONSOLE_FONT);
            this.setEditable(false);
            if (Console.this.useForInput) {
                this.addKeyListener(new 2(this));
            }
        }

        public synchronized void handleKeyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 127: {
                    keyEvent.consume();
                    break;
                }
            }
        }

        public synchronized void handleKeyTyped(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
            switch (c) {
                case '\b': {
                    if (this.textLength <= this.collectingOffset) break;
                    this.deleteLastCharacter();
                    this.collecting.setLength(this.collecting.length() - 1);
                    break;
                }
                case '\u0003': 
                case '\n': 
                case '\r': {
                    if (!keyEvent.isControlDown()) {
                        Console.this.commitInput(this.collecting.toString());
                        this.appendString(String.valueOf('\n'));
                        this.collecting.setLength(0);
                        this.collectingOffset = this.textLength;
                        break;
                    }
                }
                default: {
                    if (c == '\u0000') break;
                    this.appendString(String.valueOf(c));
                    this.collecting.append(c);
                }
            }
        }

        public synchronized void addText(String string) {
            this.appendString(string);
            this.collectingOffset = this.textLength;
        }

        protected void appendString(String string) {
            this.insert(string, this.textLength);
            this.textLength += string.length();
        }

        protected void deleteLastCharacter() {
            this.replaceRange("", this.textLength - 1, this.textLength);
            --this.textLength;
        }

        protected synchronized void handleCopy() {
            String string = this.getSelectedText();
            if (string != null) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(this.getSelectedText()), null);
            }
        }

        protected synchronized void handlePaste() {
            block2: {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable transferable = clipboard.getContents(null);
                if (transferable == null) break block2;
                try {
                    String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    this.appendString(string);
                    this.collecting.append(string);
                }
                catch (Exception exception) {}
            }
        }

        protected synchronized void handleClear() {
            this.setText(this.collecting.toString());
            this.textLength = this.collecting.length();
            this.collectingOffset = 0;
        }

        protected synchronized void handleSelectAll() {
            this.select(0, Integer.MAX_VALUE);
        }

        protected MenuBar constructMenuBar() {
            Menu menu = new Menu(ConsoleLocalization.EDIT_MENU_TITLE, true);
            MenuShortcut menuShortcut = new MenuShortcut(ConsoleLocalization.UNDO_SHORTCUT);
            MenuItem menuItem = new MenuItem(ConsoleLocalization.UNDO_ITEM_NAME, menuShortcut);
            menuItem.setEnabled(false);
            menu.add(menuItem);
            menuItem = new MenuItem("-");
            menuItem.setEnabled(false);
            menu.add(menuItem);
            menuShortcut = new MenuShortcut(ConsoleLocalization.CUT_SHORTCUT);
            menuItem = new MenuItem(ConsoleLocalization.CUT_ITEM_NAME, menuShortcut);
            menuItem.setEnabled(false);
            menu.add(menuItem);
            menuShortcut = new MenuShortcut(ConsoleLocalization.COPY_SHORTCUT);
            menuItem = new MenuItem(ConsoleLocalization.COPY_ITEM_NAME, menuShortcut);
            menuItem.setEnabled(true);
            menuItem.addActionListener(new 3(this));
            menu.add(menuItem);
            menuShortcut = new MenuShortcut(ConsoleLocalization.PASTE_SHORTCUT);
            menuItem = new MenuItem(ConsoleLocalization.PASTE_ITEM_NAME, menuShortcut);
            menuItem.setEnabled(true);
            menuItem.addActionListener(new 4(this));
            menu.add(menuItem);
            menuItem = new MenuItem(ConsoleLocalization.CLEAR_ITEM_NAME);
            menuItem.setEnabled(true);
            menuItem.addActionListener(new 5(this));
            menu.add(menuItem);
            menuItem = new MenuItem("-");
            menuItem.setEnabled(false);
            menu.add(menuItem);
            menuShortcut = new MenuShortcut(ConsoleLocalization.SELECT_ALL_SHORTCUT);
            menuItem = new MenuItem(ConsoleLocalization.SELECT_ALL_ITEM_NAME, menuShortcut);
            menuItem.setEnabled(true);
            menuItem.addActionListener(new 6(this));
            menu.add(menuItem);
            MenuBar menuBar = new MenuBar();
            menuBar.add(menu);
            return menuBar;
        }
    }

    class InputPipe
    extends InputStream {
        private static final int INITIAL_SIZE = 1024;
        private static final int HIGH_WATER_MARK = 16384;
        private byte[] buffer = new byte[1024];
        private int mark = 0;
        private int count = 0;
        private final byte[] NEWLINE_SEQUENCE = new byte[]{10};
        private byte[] singleByteBuffer = new byte[1];

        private void ensureCapacity(int n) {
            if (this.buffer.length - this.count < n) {
                int n2 = this.buffer.length;
                while ((n2 <<= 1) - this.count < n) {
                }
                byte[] byArray = new byte[n2];
                if (this.mark + this.count <= this.buffer.length) {
                    System.arraycopy(this.buffer, this.mark, byArray, 0, this.count);
                } else {
                    int n3 = this.buffer.length - this.mark;
                    System.arraycopy(this.buffer, this.mark, byArray, 0, n3);
                    System.arraycopy(this.buffer, 0, byArray, n3, this.count - n3);
                }
                this.buffer = byArray;
                this.mark = 0;
            }
        }

        private void produced(int n) {
            this.count += n;
            this.notify();
        }

        synchronized void pushBytes(byte[] byArray) {
            int n = byArray.length;
            this.ensureCapacity(n);
            int n2 = this.mark + this.count;
            if (n2 + n <= this.buffer.length) {
                System.arraycopy(byArray, 0, this.buffer, n2, n);
            } else if (n2 > this.buffer.length) {
                int n3 = n2 - this.buffer.length;
                System.arraycopy(byArray, 0, this.buffer, n3, n);
            } else {
                int n4 = this.buffer.length - n2;
                System.arraycopy(byArray, 0, this.buffer, n2, n4);
                System.arraycopy(byArray, n4, this.buffer, 0, n - n4);
            }
            this.produced(n);
        }

        synchronized void pushText(String string) {
            this.pushBytes(string.getBytes());
            this.pushBytes(this.NEWLINE_SEQUENCE);
        }

        public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
            this.ensureConsoleShowing();
            while (this.count == 0) {
                if (this.buffer.length >= 16384) {
                    try {
                        this.buffer = new byte[1024];
                    }
                    catch (OutOfMemoryError outOfMemoryError) {}
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            int n3 = Math.min(this.count, n2);
            if (this.mark + n3 > this.buffer.length) {
                n3 = this.buffer.length - this.mark;
            }
            System.arraycopy(this.buffer, this.mark, byArray, n, n3);
            this.count -= n3;
            if (this.count == 0) {
                this.mark = 0;
            } else {
                this.mark += n3;
                if (this.mark >= this.buffer.length) {
                    this.mark -= this.buffer.length;
                }
            }
            return n3;
        }

        public synchronized int available() throws IOException {
            this.ensureConsoleShowing();
            return this.count;
        }

        InputPipe() {
        }

        private void ensureConsoleShowing() {
            if (!Console.this.consoleShowing) {
                Console.this.showHideConsole(true);
            }
        }

        public synchronized int read() throws IOException {
            int n;
            while ((n = this.read(this.singleByteBuffer)) == 0) {
            }
            if (n == 1) {
                n = this.singleByteBuffer[0] & 0xFF;
            }
            return n;
        }

        public void close() {
        }
    }

    static class OutputPipe
    extends PrintStream {
        private static final int INITIAL_SIZE = 1024;
        private static final int HIGH_WATER_MARK = 16384;
        private static final int MAX_STRING_SIZE = 512;
        private char[] buffer = new char[1024];
        private int mark = 0;
        private int count = 0;
        private String linesep = System.getProperty("line.separator");
        private byte[] singleByteBuffer = new byte[1];

        OutputPipe() {
            super((OutputStream)null);
        }

        private void ensureCapacity(int n) {
            if (this.buffer.length - this.count < n) {
                int n2 = this.buffer.length;
                while ((n2 <<= 1) - this.count < n) {
                }
                char[] cArray = new char[n2];
                if (this.mark + this.count <= this.buffer.length) {
                    System.arraycopy(this.buffer, this.mark, cArray, 0, this.count);
                } else {
                    int n3 = this.buffer.length - this.mark;
                    System.arraycopy(this.buffer, this.mark, cArray, 0, n3);
                    System.arraycopy(this.buffer, 0, cArray, n3, this.count - n3);
                }
                this.buffer = cArray;
                this.mark = 0;
            }
        }

        synchronized String read() {
            while (this.count == 0) {
                if (this.buffer.length >= 16384) {
                    try {
                        this.buffer = new char[1024];
                    }
                    catch (OutOfMemoryError outOfMemoryError) {}
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            int n = Math.min(this.count, 512);
            if (this.mark + n > this.buffer.length) {
                n = this.buffer.length - this.mark;
            }
            String string = new String(this.buffer, this.mark, n);
            this.count -= n;
            if (this.count == 0) {
                this.mark = 0;
            } else {
                this.mark += n;
                if (this.mark >= this.buffer.length) {
                    this.mark -= this.buffer.length;
                }
            }
            return string;
        }

        private void produced(int n) {
            this.count += n;
            this.notify();
        }

        protected synchronized void write(char[] cArray, int n, int n2) {
            if (n + n2 > cArray.length) {
                throw new ArrayIndexOutOfBoundsException(n + n2);
            }
            this.ensureCapacity(n2);
            int n3 = this.mark + this.count;
            if (n3 + n2 <= this.buffer.length) {
                System.arraycopy(cArray, n, this.buffer, n3, n2);
            } else if (n3 > this.buffer.length) {
                int n4 = n3 - this.buffer.length;
                System.arraycopy(cArray, n, this.buffer, n4, n2);
            } else {
                int n5 = this.buffer.length - n3;
                System.arraycopy(cArray, n, this.buffer, n3, n5);
                System.arraycopy(cArray, n + n5, this.buffer, 0, n2 - n5);
            }
            this.produced(n2);
        }

        protected synchronized void write(String string) {
            int n = string.length();
            this.ensureCapacity(n);
            int n2 = this.mark + this.count;
            if (n2 + n <= this.buffer.length) {
                string.getChars(0, n, this.buffer, n2);
            } else if (n2 > this.buffer.length) {
                int n3 = n2 - this.buffer.length;
                string.getChars(0, n, this.buffer, n3);
            } else {
                int n4 = this.buffer.length - n2;
                string.getChars(0, n4, this.buffer, n2);
                string.getChars(n4, n, this.buffer, 0);
            }
            this.produced(n);
        }

        protected void write(char[] cArray) {
            this.write(cArray, 0, cArray.length);
        }

        public void print(char[] cArray) {
            this.write(cArray);
        }

        public void print(String string) {
            if (string == null) {
                string = "null";
            }
            this.write(string);
        }

        public void print(boolean bl) {
            this.print(String.valueOf(bl));
        }

        public void print(char c) {
            this.print(String.valueOf(c));
        }

        public void print(int n) {
            this.print(String.valueOf(n));
        }

        public void print(long l) {
            this.print(String.valueOf(l));
        }

        public void print(float f) {
            this.print(String.valueOf(f));
        }

        public void print(double d) {
            this.print(String.valueOf(d));
        }

        public void print(Object object) {
            this.print(String.valueOf(object));
        }

        public void println() {
            this.print(this.linesep);
        }

        public synchronized void println(boolean bl) {
            this.print(bl);
            this.println();
        }

        public synchronized void println(char c) {
            this.print(c);
            this.println();
        }

        public synchronized void println(int n) {
            this.print(n);
            this.println();
        }

        public synchronized void println(long l) {
            this.print(l);
            this.println();
        }

        public synchronized void println(float f) {
            this.print(f);
            this.println();
        }

        public synchronized void println(double d) {
            this.print(d);
            this.println();
        }

        public synchronized void println(char[] cArray) {
            this.print(cArray);
            this.println();
        }

        public synchronized void println(String string) {
            this.print(string);
            this.println();
        }

        public synchronized void println(Object object) {
            this.print(object);
            this.println();
        }

        public void write(byte[] byArray, int n, int n2) {
            this.write(new String(byArray, n, n2));
        }

        public synchronized void write(int n) {
            this.singleByteBuffer[0] = (byte)n;
            this.write(this.singleByteBuffer, 0, 1);
        }

        public boolean checkError() {
            return false;
        }

        public void flush() {
        }

        public void close() {
        }
    }
}

