/*
 * Decompiled with CFR 0.152.
 */
package com.apple.MacOS;

import com.apple.MacOS.ControlHandle;
import com.apple.MacOS.Point;
import com.apple.MacOS.Rect;
import com.apple.MacOS.Region;
import com.apple.MacOS.ScrollPane;
import com.apple.MacOS.ScrollPaneComponent;
import com.apple.MacOS.ScrollPaneContents;
import com.apple.MacOS.ToolboxObject;
import com.apple.MacOS.WindowRef;

public class ScrollableView
implements ScrollPaneComponent,
ToolboxObject {
    ScrollPane myPane;
    Rect viewRect;
    Rect destRect;
    WindowRef window;
    ScrollPaneContents contents;

    public ScrollableView(ScrollPaneContents scrollPaneContents, Rect rect, boolean bl, boolean bl2, WindowRef windowRef) {
        this.viewRect = this.destRect = rect;
        this.window = windowRef;
        this.contents = scrollPaneContents;
        this.myPane = new ScrollPane(this, rect, bl, bl2, true);
    }

    public Rect getDestRect() {
        return this.destRect;
    }

    public Rect getViewRect() {
        return this.viewRect;
    }

    public int getScrollMax(Rect rect, Rect rect2, boolean bl) {
        return this.contents.getScrollMax(rect, rect2, bl);
    }

    public void adjustContentsForScrollBars(ControlHandle controlHandle, ControlHandle controlHandle2) {
        this.contents.adjustContentsForScrollBars(controlHandle, controlHandle2);
    }

    public WindowRef getWindowRef() {
        return this.window;
    }

    public int getIdentifier() {
        return 0;
    }

    public boolean HitTest(Point point) {
        return this.myPane.HitTest(point) || this.viewRect.Contains(point);
    }

    public void Click(Point point) {
    }

    public void setScrollValues(short s, short s2) {
        this.myPane.hScrollValue(s);
        this.myPane.vScrollValue(s2);
    }

    public void Size(short s, short s2) {
        Rect rect = this.getViewRect();
        Rect rect2 = this.getDestRect();
        this.getWindowRef().Inval(rect);
        if (s != 0) {
            rect.setRight(rect.getRight() + s);
            rect2.setRight(rect2.getRight() + s);
        }
        if (s2 != 0) {
            rect.setBottom(rect.getRight() + s2);
            rect2.setBottom(rect2.getRight() + s2);
        }
        this.getWindowRef().Valid(rect);
        this.Draw();
    }

    public void IsVisible(boolean bl) {
        this.myPane.IsVisible(bl);
        this.contents.IsVisible(bl);
    }

    public void IsHilited(boolean bl) {
        this.myPane.IsHilited(bl);
        this.contents.IsHilited(bl);
    }

    public Rect GetBounds() {
        return this.viewRect;
    }

    public void SetBounds(Rect rect) {
        Rect rect2 = this.myPane.SetBounds(rect);
        this.contents.SetBounds(rect2);
        this.viewRect.Set(rect2);
    }

    public void Dispose() {
        this.myPane.Dispose();
        this.contents.Dispose();
    }

    public void Update(Region region) {
        this.Draw();
    }

    public void Draw() {
        this.myPane.Draw();
        this.contents.Draw();
    }

    public Point GetOrigin() {
        return this.viewRect.topLeft();
    }
}

