/*
 * Decompiled with CFR 0.152.
 */
package com.apple.MacOS;

import com.apple.MacOS.Handle;
import com.apple.MacOS.MacOSLibraries;
import com.apple.MacOS.Point;

public abstract class MenuManager
extends Handle {
    public static final char noMark = '\u0000';
    public static final char checkMark = '\u0012';
    public static final char bulletMark = '\u00a5';
    public static final char hMenuCmd = '\u001b';
    public static final char hierMenu = '\uffff';
    private static String[] kNativeLibraryNames = MacOSLibraries.kInterfaceLibNames;

    protected MenuManager(int n) {
        super(n);
    }

    protected MenuManager(int n, Handle handle) {
        super(n, handle);
    }

    public static void drawMenuBar() {
        MenuManager.DrawMenuBar();
    }

    public static int getMBarHeight() {
        return MenuManager.GetMBarHeight();
    }

    public static void invalMenuBar() {
        MenuManager.InvalMenuBar();
    }

    public static void clearMenuBar() {
        MenuManager.ClearMenuBar();
    }

    public static void flashMenuBar(int n) {
        MenuManager.FlashMenuBar((short)n);
    }

    public static void setMenuFlash(int n) {
        MenuManager.SetMenuFlash((short)n);
    }

    public static int menuKey(int n) {
        return MenuManager.MenuKey((short)(n & 0xFF));
    }

    public static int menuSelect(Point point) {
        return MenuManager.MenuSelect(point.toInt());
    }

    public static int menuSelect(int n, int n2) {
        return MenuManager.MenuSelect(n2 << 16 | n);
    }

    public static void hiliteMenu(int n) {
        MenuManager.HiliteMenu((short)n);
    }

    public static boolean systemEdit(short s) {
        return MenuManager.SystemEdit(s);
    }

    public static void systemMenu(int n) {
        MenuManager.SystemMenu(n);
    }

    private static native void DrawMenuBar();

    private static native short GetMBarHeight();

    private static native void InvalMenuBar();

    private static native void ClearMenuBar();

    private static native void FlashMenuBar(short var0);

    private static native void SetMenuFlash(short var0);

    private static native int MenuKey(short var0);

    private static native int MenuSelect(int var0);

    private static native void HiliteMenu(short var0);

    private static native boolean SystemEdit(short var0);

    private static native void SystemMenu(int var0);
}

