/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.utils;

import com.adobe.utils.WebEntityResolver;
import com.zerog.ia.api.pub.CustomError;
import com.zerog.ia.api.pub.IAProxy;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class CopyUtils {
    HashMap filelist = new HashMap();

    public static void moveFile(String source, String destination, IAProxy installerProxy) {
        CustomError customMsg = (CustomError)installerProxy.getService(CustomError.class);
        try {
            File srcFile = new File(source);
            File destFile = new File(destination);
            if (srcFile.exists() && !destFile.exists()) {
                FileUtils.moveFile(srcFile, new File(destination));
                customMsg.setLogDescription(installerProxy.getValue("MoveFile.Msg") + System.lineSeparator() + installerProxy.getValue("Source.Msg") + source + System.lineSeparator() + installerProxy.getValue("Destination.Msg") + destination);
            }
        }
        catch (IOException e) {
            customMsg.appendError(e.getMessage(), 97);
            e.printStackTrace();
        }
        customMsg.log();
    }

    public static void copyFile(String source, String destination, IAProxy installerProxy) {
        CustomError customMsg = (CustomError)installerProxy.getService(CustomError.class);
        int errorLevel = 98;
        errorLevel = source.contains("PDFgServlet") ? 98 : 96;
        try {
            File srcFile = new File(source);
            if (srcFile.exists()) {
                FileUtils.copyFile(srcFile, new File(destination));
                customMsg.setLogDescription(installerProxy.getValue("CopyFile.Msg") + System.lineSeparator() + installerProxy.getValue("Source.Msg") + source + System.lineSeparator() + installerProxy.getValue("Destination.Msg") + destination);
            }
        }
        catch (IOException e) {
            customMsg.setLogDescription(installerProxy.getValue("CopyFile.BackupFilesLabel"));
            customMsg.setRemedialText(installerProxy.getValue("CopyFile.BackupFilesRemedy"));
            customMsg.appendError(installerProxy.getValue("CopyFile.BackupFilesMessage"), errorLevel);
            customMsg.appendError(e.getMessage(), errorLevel);
        }
        customMsg.log();
    }

    public static void copyFolder(String source, String destination, IAProxy installerProxy) {
        File srcDir = null;
        File destDir = null;
        CustomError customMsg = (CustomError)installerProxy.getService(CustomError.class);
        try {
            srcDir = new File(source);
            destDir = new File(destination);
            if (!destDir.exists()) {
                FileUtils.touch(destDir);
            }
            if (srcDir.exists()) {
                boolean destWritable = destDir.canWrite();
                if (!destWritable) {
                    destDir.setWritable(true, true);
                }
                FileUtils.copyDirectory(srcDir, destDir);
                if (!destWritable && !destDir.toString().contains("hf-updates")) {
                    destDir.setReadOnly();
                }
            }
            customMsg.setLogDescription(installerProxy.getValue("CopyDir.Msg") + System.lineSeparator() + installerProxy.getValue("Source.Msg") + srcDir + System.lineSeparator() + installerProxy.getValue("Destination.Msg") + destination);
        }
        catch (IOException e) {
            customMsg.setLogDescription(installerProxy.getValue("CopyFile.ErrorLabel") + srcDir);
            customMsg.setRemedialText(installerProxy.getValue("CopyFile.ErrorRemedy"));
            customMsg.appendError(installerProxy.getValue("CopyFile.ErrorMessage") + destDir, 96);
            customMsg.appendError(e.getMessage(), 96);
        }
        customMsg.log();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyDirectory(File sourceLocation, File targetLocation, IAProxy installerProxy) {
        CustomError customMsg = (CustomError)installerProxy.getService(CustomError.class);
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists()) {
                targetLocation.mkdir();
            }
            boolean targetWritable = targetLocation.canWrite();
            this.filelist.put(targetLocation, targetWritable);
            if (!targetWritable) {
                boolean setTowrite = targetLocation.setWritable(true, true);
                if (setTowrite) {
                    customMsg.setLogDescription(installerProxy.getValue("FolderPermission.ToWrite") + targetLocation);
                } else {
                    customMsg.setLogDescription(installerProxy.getValue("FolderPermission.ToWriteFailed") + targetLocation);
                }
            }
            String[] children = sourceLocation.list();
            for (int i = 0; i < children.length; ++i) {
                this.copyDirectory(new File(sourceLocation, children[i]), new File(targetLocation, children[i]), installerProxy);
            }
        } else {
            InputStream in = null;
            OutputStream out = null;
            try {
                int len;
                if (targetLocation.exists()) {
                    boolean targetWritable = targetLocation.canWrite();
                    this.filelist.put(targetLocation, targetWritable);
                    if (!targetWritable) {
                        targetLocation.setWritable(true, true);
                    }
                }
                in = new FileInputStream(sourceLocation);
                out = new FileOutputStream(targetLocation);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
            }
            catch (IOException e) {
                customMsg.setLogDescription(installerProxy.getValue("CopyFile.ErrorLabel") + sourceLocation);
                customMsg.setRemedialText(installerProxy.getValue("CopyFile.ErrorRemedy"));
                customMsg.appendError(installerProxy.getValue("CopyFile.ErrorMessage") + targetLocation, 96);
                customMsg.appendError(e.getMessage(), 96);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        customMsg.log();
    }

    public void setFilePerm(IAProxy installerProxy) {
        CustomError customMsg = (CustomError)installerProxy.getService(CustomError.class);
        for (Object key : this.filelist.keySet()) {
            File filePathKey = (File)key;
            Boolean filePathWritable = (Boolean)this.filelist.get(key);
            if (filePathWritable.booleanValue()) continue;
            boolean setToRead = filePathKey.setReadOnly();
            if (!filePathKey.isDirectory()) continue;
            if (setToRead) {
                customMsg.appendMessage(installerProxy.getValue("FolderPermission.ToRead") + filePathKey + "\n");
                continue;
            }
            customMsg.appendMessage(installerProxy.getValue("FolderPermission.ToReadFailed") + filePathKey + "\n");
        }
        customMsg.log();
    }

    public static void moveFolderToFolder(String source, String destination, IAProxy installerProxy) {
        CustomError customMsg = (CustomError)installerProxy.getService(CustomError.class);
        try {
            File srcDir = new File(source);
            File destDir = new File(destination);
            if (srcDir.exists()) {
                srcDir.setWritable(true, true);
                FileUtils.moveDirectoryToDirectory(srcDir, destDir, true);
            }
            customMsg.setLogDescription(installerProxy.getValue("MoveDir.Msg") + System.lineSeparator() + installerProxy.getValue("Source.Msg") + srcDir + System.lineSeparator() + installerProxy.getValue("Destination.Msg") + destination);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        customMsg.log();
    }

    public static void moveFilesToFolder(String source, String destination, IAProxy installerProxy) {
        CustomError customMsg = (CustomError)installerProxy.getService(CustomError.class);
        try {
            File srcDir = new File(source);
            File destDir = new File(destination);
            if (srcDir.exists()) {
                srcDir.setWritable(true, true);
                FileUtils.copyDirectory(srcDir, destDir);
            }
            CopyUtils.deleteDir(source, installerProxy);
            customMsg.setLogDescription(installerProxy.getValue("MoveDir.Msg") + System.lineSeparator() + installerProxy.getValue("Source.Msg") + srcDir + System.lineSeparator() + installerProxy.getValue("Destination.Msg") + destination);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        customMsg.log();
    }

    public static void deleteDir(String delDir, IAProxy installerProxy) {
        CustomError customMsg = (CustomError)installerProxy.getService(CustomError.class);
        try {
            File delDirF = new File(delDir);
            if (delDirF.exists()) {
                delDirF.setWritable(true, true);
                FileUtils.deleteDirectory(delDirF);
            }
            customMsg.setLogDescription(installerProxy.getValue("Delete.Msg") + delDir);
        }
        catch (IOException e) {
            customMsg.setLogDescription(installerProxy.getValue("DeleteDir.ErrorLabel"));
            customMsg.setRemedialText(installerProxy.getValue("DeleteDir.ErrorRemedy"));
            customMsg.appendError(installerProxy.getValue("DeleteDir.ErrorMessage") + delDir, 97);
            customMsg.appendError(e.getMessage(), 97);
        }
        customMsg.log();
    }

    public static void deleteDir(String delDir) {
        try {
            File delDirF = new File(delDir);
            if (delDirF.exists()) {
                delDirF.setWritable(true, true);
                FileUtils.deleteDirectory(delDirF);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void deleteFile(String delFile, IAProxy installerProxy) {
        CustomError customMsg = (CustomError)installerProxy.getService(CustomError.class);
        try {
            File delFileF = new File(delFile);
            if (delFileF.exists()) {
                delFileF.setWritable(true, true);
                if (delFileF.isDirectory()) {
                    FileUtils.deleteDirectory(delFileF);
                } else {
                    FileUtils.forceDelete(delFileF);
                }
            }
            customMsg.setLogDescription(installerProxy.getValue("Delete.Msg") + delFile);
        }
        catch (IOException e) {
            customMsg.setLogDescription(installerProxy.getValue("DeleteDir.ErrorLabel"));
            customMsg.setRemedialText(installerProxy.getValue("DeleteDir.ErrorRemedy"));
            customMsg.appendError(installerProxy.getValue("DeleteDir.ErrorMessage") + delFile, 97);
            customMsg.appendError(e.getMessage(), 97);
        }
        catch (Exception exception) {
            // empty catch block
        }
        customMsg.log();
    }

    public static void cleanUpDir(String cleanUpDir, IAProxy installerProxy) {
        CustomError customMsg = (CustomError)installerProxy.getService(CustomError.class);
        try {
            File cleanUpDirF = new File(cleanUpDir);
            if (cleanUpDirF.exists()) {
                cleanUpDirF.setWritable(true, true);
                FileUtils.cleanDirectory(cleanUpDirF);
                customMsg.setLogDescription(installerProxy.getValue("CleanDir.Msg") + cleanUpDir);
            }
        }
        catch (IOException e) {
            customMsg.setLogDescription(installerProxy.getValue("CleanDir.ErrorLabel"));
            customMsg.setRemedialText(installerProxy.getValue("CleanDir.ErrorRemedy"));
            customMsg.appendError(installerProxy.getValue("CleanDir.ErrorMessage") + cleanUpDir, 97);
            customMsg.appendError(e.getMessage(), 97);
        }
        customMsg.log();
    }

    public static void cleanUpOnlyFilesInDir(String cleanUpDir, IAProxy installerProxy) {
        CustomError customMsg = (CustomError)installerProxy.getService(CustomError.class);
        List<File> files = null;
        try {
            files = CopyUtils.getFileListing(new File(cleanUpDir));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        if (files != null) {
            for (File file : files) {
                if (!file.isFile()) continue;
                try {
                    FileUtils.forceDelete(file);
                }
                catch (IOException e) {
                    customMsg.setLogDescription(installerProxy.getValue("CleanDir.ErrorLabel"));
                    customMsg.setRemedialText(installerProxy.getValue("CleanDir.ErrorRemedy"));
                    customMsg.appendError(installerProxy.getValue("CleanDir.ErrorMessage") + cleanUpDir, 97);
                    customMsg.appendError(e.getMessage(), 97);
                }
                customMsg.log();
            }
        }
    }

    public static void copyFileToFolder(String sourceFile, String destinationDir, IAProxy installerProxy) {
        int errorLevel = 98;
        CustomError customMsg = (CustomError)installerProxy.getService(CustomError.class);
        try {
            File srcFile = new File(sourceFile);
            File destDir = new File(destinationDir);
            if (srcFile.exists()) {
                boolean destWritable = destDir.canWrite();
                if (!destWritable) {
                    destDir.setWritable(true, true);
                }
                FileUtils.copyFileToDirectory(srcFile, destDir);
                if (!destWritable && !destDir.toString().contains("hf-updates")) {
                    destDir.setReadOnly();
                }
                customMsg.setLogDescription(installerProxy.getValue("CopyFileToFolder.Msg") + System.lineSeparator() + installerProxy.getValue("Source.Msg") + sourceFile + System.lineSeparator() + installerProxy.getValue("Destination.Msg") + destinationDir);
            }
            errorLevel = sourceFile.contains("PDFgServlet") ? 98 : 96;
        }
        catch (IOException e) {
            customMsg.setLogDescription(installerProxy.getValue("CopyFile.BackupFilesLabel"));
            customMsg.setRemedialText(installerProxy.getValue("CopyFile.BackupFilesRemedy"));
            customMsg.appendError(installerProxy.getValue("CopyFile.BackupFilesMessage"), errorLevel);
            customMsg.appendError(e.getMessage(), errorLevel);
        }
        customMsg.log();
    }

    public static void moveFileToNewFilePath(String sourceFile, String destinationFile, IAProxy installerProxy) {
        CustomError customMsg = (CustomError)installerProxy.getService(CustomError.class);
        try {
            File srcFile = new File(sourceFile);
            File destFile = new File(destinationFile);
            if (srcFile.exists()) {
                srcFile.getParentFile().setWritable(true, true);
                srcFile.setWritable(true, true);
                FileUtils.moveFile(srcFile, destFile);
                customMsg.setLogDescription(installerProxy.getValue("MoveFileToNewPath.Msg") + System.lineSeparator() + installerProxy.getValue("Source.Msg") + sourceFile + System.lineSeparator() + installerProxy.getValue("Destination.Msg") + destinationFile);
            }
        }
        catch (IOException e) {
            customMsg.setLogDescription(installerProxy.getValue("CopyFile.ErrorBackupLabel"));
            customMsg.setRemedialText(installerProxy.getValue("CopyFile.ErrorBackupRemedy"));
            int errorLevel = sourceFile.contains("PDFgServlet") ? 98 : 96;
            customMsg.appendError(installerProxy.getValue("CopyFile.ErrorBackupMessage1") + " " + sourceFile + " " + installerProxy.getValue("CopyFile.ErrorBackupMessage2") + " " + destinationFile, errorLevel);
        }
        customMsg.log();
    }

    public static List<File> getFileListing(File aStartingDir) throws FileNotFoundException {
        return CopyUtils.getFileListing(aStartingDir, null);
    }

    public static List<File> getFileListing(File aStartingDir, FileFilter filter) throws FileNotFoundException {
        CopyUtils.validateDirectory(aStartingDir);
        List<File> result = CopyUtils.getFileListingNoSort(aStartingDir, filter);
        Collections.sort(result);
        return result;
    }

    private static List<File> getFileListingNoSort(File aStartingDir, FileFilter filter) throws FileNotFoundException {
        ArrayList<File> result = new ArrayList<File>();
        File[] filesAndDirs = null;
        filesAndDirs = filter == null ? aStartingDir.listFiles() : aStartingDir.listFiles(filter);
        List<File> filesDirs = Arrays.asList(filesAndDirs);
        for (File file : filesDirs) {
            result.add(file);
            if (file.isFile()) continue;
            List<File> deeperList = CopyUtils.getFileListingNoSort(file, filter);
            result.addAll(deeperList);
        }
        return result;
    }

    public static void validateDirectory(File aDirectory) throws FileNotFoundException {
        if (aDirectory == null) {
            throw new IllegalArgumentException("Directory should not be null.");
        }
        if (!aDirectory.exists()) {
            throw new FileNotFoundException("Directory does not exist: " + aDirectory);
        }
        if (!aDirectory.isDirectory()) {
            throw new IllegalArgumentException("Is not a directory: " + aDirectory);
        }
        if (!aDirectory.canRead()) {
            throw new IllegalArgumentException("Directory cannot be read: " + aDirectory);
        }
    }

    public static void updateContextXML(String filePath, String defaultInstName, String instanceName) {
        try {
            String line;
            FileReader confReader = null;
            BufferedReader confbuff = null;
            if (!instanceName.equals(defaultInstName)) {
                filePath = filePath.replace(defaultInstName, instanceName);
            }
            File contextxmlfile = new File(filePath);
            confReader = new FileReader(contextxmlfile);
            confbuff = new BufferedReader(confReader);
            while (!(line = confbuff.readLine()).contains("<Manager pathname=\"\" />")) {
            }
            String s = line;
            s = s.replace(line, line + "\r\n<!--<Manager notifyListenersOnReplication=\"true\" className=\"org.apache.catalina.ha.session.DeltaManager\" expireSessionsOnShutdown=\"false\"/>-->");
            CopyUtils.updateFile(filePath, line, s, "<!--<Manager notifyListenersOnReplication=\"true\" className=\"org.apache.catalina.ha.session.DeltaManager\" expireSessionsOnShutdown=\"false\"/>-->", false, false, defaultInstName, instanceName);
            confbuff.close();
            confReader.close();
        }
        catch (IOException ioe) {
            System.err.println("Error: " + ioe.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateFile(String filePath, String targetStr, String replaceWithStr, String checkPreExistStrOrDoesNotExistStr, boolean checkForExistStrOrNonExistStr, boolean replaceInstanceName, String defaultInstName, String currentInstanceName) {
        File confFile = new File(filePath);
        FileReader confReader = null;
        BufferedReader confbuff = null;
        FileWriter fileWriteConf = null;
        BufferedWriter outconf = null;
        try {
            String line;
            confReader = new FileReader(confFile);
            confbuff = new BufferedReader(confReader);
            StringBuffer confsb = new StringBuffer();
            while ((line = confbuff.readLine()) != null) {
                confsb.append(line + System.lineSeparator());
            }
            Object configUpdated = confsb.toString();
            if (replaceInstanceName && !defaultInstName.equals(currentInstanceName)) {
                if (((String)configUpdated).contains(defaultInstName) && !((String)configUpdated).contains(currentInstanceName)) {
                    configUpdated = ((String)configUpdated).replace(defaultInstName, currentInstanceName);
                }
            } else if (checkForExistStrOrNonExistStr && ((String)configUpdated).contains(checkPreExistStrOrDoesNotExistStr)) {
                configUpdated = targetStr == null || targetStr.isEmpty() ? (String)configUpdated + replaceWithStr : ((String)configUpdated).replace(targetStr, replaceWithStr);
            } else if (!checkForExistStrOrNonExistStr && !((String)configUpdated).contains(checkPreExistStrOrDoesNotExistStr)) {
                configUpdated = targetStr == null || targetStr.isEmpty() ? (String)configUpdated + replaceWithStr : ((String)configUpdated).replace(targetStr, replaceWithStr);
            }
            if (!((String)configUpdated).equals(confsb.toString())) {
                fileWriteConf = new FileWriter(confFile);
                outconf = new BufferedWriter(fileWriteConf);
                outconf.write((String)configUpdated);
                outconf.flush();
                fileWriteConf.close();
                outconf.close();
            }
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
        finally {
            try {
                confReader.close();
                confbuff.close();
            }
            catch (IOException e) {
                System.err.println("Error: " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateWebXml(String webxmlPath) {
        Properties p = new Properties();
        try {
            p.setProperty("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", new File(webxmlPath + "/../web-app_2_3.dtd").getCanonicalPath());
            p.setProperty("web-app_2_3.dtd", new File(webxmlPath + "/../web-app_2_3.dtd").getCanonicalPath());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        File fXmlFile = new File(webxmlPath);
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setValidating(false);
        InputStream fis = null;
        BufferedInputStream bis = null;
        try {
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            dBuilder.setEntityResolver(new WebEntityResolver(p));
            fis = new FileInputStream(fXmlFile);
            bis = new BufferedInputStream(fis);
            Document document = dBuilder.parse(bis);
            Element webApp = document.getDocumentElement();
            String[] servletMappingIds = new String[]{"coldfusion_mapping_24", "coldfusion_mapping_25", "coldfusion_mapping_26", "coldfusion_mapping_27", "coldfusion_mapping_28", "coldfusion_mapping_29"};
            String[] servletNames = new String[]{"CfmServlet", "CfmServlet", "CfmServlet", "CfmServlet", "CFCServlet", "CFCServlet"};
            String[] urlPatterns = new String[]{"*.CFML/*", "*.Cfml/*", "*.CFM/*", "*.Cfm/*", "*.CFC/*", "*.Cfc/*"};
            boolean updated = false;
            for (int i = 0; i < servletMappingIds.length; ++i) {
                Element servletMappingExt = document.getElementById(servletMappingIds[i]);
                if (servletMappingExt != null) continue;
                updated = true;
                Element rootElement = document.createElement("servlet-mapping");
                webApp.appendChild(rootElement);
                rootElement.setAttribute("id", servletMappingIds[i]);
                Element servletName = document.createElement("servlet-name");
                Node sn = rootElement.appendChild(servletName);
                sn.setTextContent(servletNames[i]);
                Element urlPattern = document.createElement("url-pattern");
                Node urlPtn = rootElement.appendChild(urlPattern);
                urlPtn.setTextContent(urlPatterns[i]);
            }
            if (updated) {
                CopyUtils.writeXmlFile(document, webxmlPath);
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public static void writeXmlFile(Document doc, String filename) {
        try {
            try {
                FileUtils.copyFile(new File(filename), new File(filename + "/../web.xml.bak"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            DOMSource source = new DOMSource(doc);
            File file = new File(filename);
            StreamResult result = new StreamResult(file);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.setOutputProperty("indent", "yes");
            DocumentType doctype = doc.getDoctype();
            if (doctype != null) {
                xformer.setOutputProperty("doctype-public", doctype.getPublicId());
                xformer.setOutputProperty("doctype-system", doctype.getSystemId());
            }
            xformer.transform(source, result);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    public static void updateProperty(String propertiesPath, String key, String value) {
        Properties prop = new Properties(){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized Enumeration<Object> keys() {
                return Collections.enumeration(new TreeSet<Object>(super.keySet()));
            }
        };
        FileInputStream input = null;
        File propertiesFile = new File(propertiesPath);
        try {
            if (!propertiesFile.exists()) {
                propertiesFile.createNewFile();
            }
            if (propertiesFile.exists()) {
                input = new FileInputStream(propertiesFile);
                prop.load(input);
                prop.setProperty(key, value);
                FileOutputStream fileOut = new FileOutputStream(propertiesFile);
                prop.store(fileOut, "Properties");
                fileOut.close();
            }
        }
        catch (IOException e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    public static void main(String[] args) {
    }
}

