/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ia.action;

import com.adobe.utils.CopyUtils;
import com.adobe.utils.Executes;
import com.adobe.utils.InstanceList;
import com.zerog.ia.api.pub.CustomCodeAction;
import com.zerog.ia.api.pub.CustomError;
import com.zerog.ia.api.pub.InstallException;
import com.zerog.ia.api.pub.InstallerProxy;
import com.zerog.ia.api.pub.UninstallerProxy;
import java.io.File;
import java.util.Map;
import java.util.StringTokenizer;

public class StartServersAction
extends CustomCodeAction {
    String installerType = installerProxy.substitute("$INSTALLER_TYPE_1$");
    String j2eeConst = installerProxy.substitute("$J2EE_CONST$");
    String osName = System.getProperty("os.name").toLowerCase();

    @Override
    public String getInstallStatusMessage() {
        return null;
    }

    @Override
    public String getUninstallStatusMessage() {
        return null;
    }

    @Override
    public void install(InstallerProxy arg0) throws InstallException {
        if (this.j2eeConst.equals(this.installerType)) {
            this.jeeServerActions();
        } else {
            this.startServers();
        }
    }

    @Override
    public void uninstall(UninstallerProxy arg0) throws InstallException {
        if (this.j2eeConst.equals(this.installerType)) {
            this.jeeServerActions();
        } else {
            this.startServers();
        }
    }

    public void jeeServerActions() {
        String isWindows;
        block7: {
            if (this.j2eeConst.equals(this.installerType)) {
                String instanceRoot = installerProxy.substitute("$CF_INSTANCE_ROOT$");
                CopyUtils.deleteDir(instanceRoot + "/bin/felix-cache");
                Object updatePackagesCommand = "";
                updatePackagesCommand = this.osName.contains("windows") ? instanceRoot + "/bin/cfpm.bat update packages" : instanceRoot + "/bin/cfpm.sh update packages";
                try {
                    Executes.exec((String)updatePackagesCommand, true, installerProxy);
                }
                catch (Throwable e) {
                    if (installerProxy == null) break block7;
                    try {
                        CustomError customMsg = (CustomError)installerProxy.getService(CustomError.class);
                        customMsg.setLogDescription("Error while updating packages." + e.getLocalizedMessage());
                        customMsg.log();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
        if (!(isWindows = installerProxy.substitute("$IS_WINDOWS$")).equals("true")) {
            String jettyPath = installerProxy.substitute("$JETTY_PATH$");
            String jettyRuntimeUser = installerProxy.substitute("$JETTY_RUNTIME_USER$");
            if (jettyPath != null && new File(jettyPath).exists()) {
                Executes.exec("chown -R " + jettyRuntimeUser + " " + jettyPath, false, installerProxy);
            }
        }
    }

    public void startServers() {
        String hfJettyScriptPath;
        String serviceNameFromXML;
        String exceutionResult;
        String instList = installerProxy.substitute("$INSTANCE_LIST$");
        String defaultInstName = installerProxy.substitute("$CF_DEF_INST_NAME$");
        String cfVersion = installerProxy.substitute("$COLDFUSION_VERSION$");
        String isWindows = installerProxy.substitute("$IS_WINDOWS$");
        if (installerProxy.substitute("$HOTFIX_APIMANAGER$").equals("true") && installerProxy.substitute("$APIMANAGER_EXISTS$").equals("true")) {
            String apiManagerRootPath = installerProxy.substitute("$APIMANAGER_PATH$");
            String redisserverPath = apiManagerRootPath + "/database/datastore/redis-server";
            String analyticsserverPath = apiManagerRootPath + "/database/analytics/bin/elasticsearch";
            String apiManagerInvm = installerProxy.substitute("$APIMANAGER_INVM$");
            String dsRunning = "";
            String asRunning = "";
            boolean dsUP = false;
            boolean asUP = false;
            String analyticsServiceName = installerProxy.substitute("$HOTFIX_ANALYTICS_SERVICENAME$");
            String redisServiceName = installerProxy.substitute("$HOTFIX_DATASTORE_SERVICENAME$");
            String startAPIManagerServiceCommand = "sc start " + installerProxy.substitute("$HOTFIX_APIMANAGER_SERVICENAME$");
            if (isWindows.equals("true")) {
                String analyticsserviceDescription = Executes.exec("sc qdescription " + analyticsServiceName, true, installerProxy);
                String redisserviceDescription = Executes.exec("sc qdescription " + redisServiceName, true, installerProxy);
                long startTime = System.currentTimeMillis();
                do {
                    if (!analyticsserviceDescription.contains("service does not exist")) {
                        String startAnalyticsServiceCommand = "sc start " + analyticsServiceName;
                        asRunning = Executes.exec(startAnalyticsServiceCommand, true, installerProxy);
                    }
                    if (redisserviceDescription.contains("service does not exist")) continue;
                    String startDatastoreServiceCommand = "sc start " + redisServiceName;
                    dsRunning = Executes.exec(startDatastoreServiceCommand, true, installerProxy);
                } while (!asRunning.contains("running") && !dsRunning.contains("running") && System.currentTimeMillis() - startTime < 15000L);
                if (new File(redisserverPath + ".exe").exists() && dsRunning.toLowerCase().contains("running")) {
                    dsUP = true;
                }
                if (new File(analyticsserverPath + ".bat").exists() && asRunning.toLowerCase().contains("running")) {
                    asUP = true;
                }
                if (dsRunning.toLowerCase().contains("running")) {
                    dsUP = true;
                }
                if (asRunning.toLowerCase().contains("running")) {
                    asUP = true;
                }
                if (dsUP && asUP && apiManagerInvm.contains("false")) {
                    Executes.exec(startAPIManagerServiceCommand, true, installerProxy);
                }
                if ((redisserviceDescription.contains("service does not exist") || analyticsserviceDescription.contains("service does not exist")) && new File(apiManagerRootPath + File.separator + "bin\\apimanager.exe").exists()) {
                    Executes.exec(startAPIManagerServiceCommand, true, installerProxy);
                }
            } else {
                String installerUI = installerProxy.substitute("$INSTALLER_UI$");
                String installFromCommand = installerProxy.substitute("$COMMAND_INSTALL$");
                String apimserverPath = apiManagerRootPath + "/bin/apimanager";
                String ASExists = installerProxy.substitute("$ANALYTICS_EXISTS$");
                String DSExists = installerProxy.substitute("$DATASTORE_EXISTS$");
                String DScmd = apiManagerRootPath + File.separator + "database/datastore/apimdatastore start";
                String DScmdhf = apiManagerRootPath + File.separator + "database/datastore/apimdatastore_hf start";
                String AScmd = apiManagerRootPath + File.separator + "database/analytics/bin/apimanalytics start";
                String AScmdhf = apiManagerRootPath + File.separator + "database/analytics/bin/apimanalytics_hf start";
                if (installerUI != null && installerUI.equals("SILENT") && File.separatorChar == '/' && installFromCommand != null && !installFromCommand.equalsIgnoreCase("true") && !System.getProperty("os.name").contains("Mac")) {
                    Executes.exec(AScmdhf, true, installerProxy);
                } else if (ASExists.contains("true")) {
                    Executes.exec(AScmd, true, installerProxy);
                }
                if (installerUI != null && installerUI.equals("SILENT") && File.separatorChar == '/' && installFromCommand != null && !installFromCommand.equalsIgnoreCase("true") && !System.getProperty("os.name").contains("Mac")) {
                    Executes.exec(DScmdhf, true, installerProxy);
                } else if (DSExists.contains("true")) {
                    Executes.exec(DScmd, true, installerProxy);
                }
                if (new File(apimserverPath).exists() && apiManagerInvm.contains("false") && System.getProperty("os.name").contains("Mac")) {
                    String cmd = "sudo -u " + installerProxy.substitute("$HOTFIX_APIMANAGER_MACRUNUSER$");
                    Executes.exec(cmd + " " + apiManagerRootPath + File.separator + "bin/apimanager start", true, installerProxy);
                }
                if (installerUI != null && installerUI.equals("SILENT") && File.separatorChar == '/' && installFromCommand != null && !installFromCommand.equalsIgnoreCase("true") && new File(apimserverPath).exists() && apiManagerInvm.contains("false") && !System.getProperty("os.name").contains("Mac")) {
                    Executes.exec(apiManagerRootPath + File.separator + "/bin/apimanager_hf start", true, installerProxy);
                } else if (new File(apimserverPath).exists() && apiManagerInvm.contains("false") && !System.getProperty("os.name").contains("Mac")) {
                    Executes.exec(apiManagerRootPath + File.separator + "/bin/apimanager start", true, installerProxy);
                }
            }
        }
        if (!isWindows.equals("true")) {
            String jettyPath = installerProxy.substitute("$JETTY_PATH$");
            String jettyRuntimeUser = installerProxy.substitute("$JETTY_RUNTIME_USER$");
            if (jettyPath != null && new File(jettyPath).exists()) {
                Executes.exec("chown -R " + jettyRuntimeUser + " " + jettyPath, false, installerProxy);
            }
        }
        String servInstXML = installerProxy.substitute("$SERVER_INST_XML$");
        Map<String, String> fullServerMaps = InstanceList.getInst(servInstXML);
        boolean isProcessRunningAsRoot = false;
        if (!isWindows.equals("true") && (exceutionResult = Executes.exec("id -u", true, installerProxy)) != null && exceutionResult.trim().equals("0")) {
            isProcessRunningAsRoot = true;
        }
        Map<String, String> instanceServiceMap = null;
        Object defaultInstServiceName = cfVersion + " Application Server";
        if (isWindows.equals("true") && (serviceNameFromXML = (instanceServiceMap = InstanceList.getInstanceServiceMap(servInstXML)).get(defaultInstName)) != null) {
            defaultInstServiceName = serviceNameFromXML;
        }
        StringTokenizer tokens = new StringTokenizer(instList, ",");
        while (tokens.hasMoreElements()) {
            String inst = (String)tokens.nextElement();
            String instanceRoot = fullServerMaps.get(inst);
            Object startCommand = "";
            Object updatePackagesCommand = "";
            String installerUI = installerProxy.substitute("$INSTALLER_UI$");
            String installFromCommand = installerProxy.substitute("$COMMAND_INSTALL$");
            CopyUtils.deleteDir(instanceRoot + "/bin/felix-cache");
            startCommand = isProcessRunningAsRoot && !isWindows.equals("true") ? instanceRoot + "/bin/coldfusion start" : (installerUI != null && installerUI.equals("SILENT") && File.separatorChar == '/' && installFromCommand != null && !installFromCommand.equalsIgnoreCase("true") ? instanceRoot + "/bin/coldfusion_hf start" : instanceRoot + "/bin/coldfusion start");
            if (isWindows.equals("true")) {
                block48: {
                    updatePackagesCommand = instanceRoot + "/bin/cfpm.bat update packages";
                    try {
                        Executes.exec((String)updatePackagesCommand, true, installerProxy);
                    }
                    catch (Throwable e) {
                        if (installerProxy == null) break block48;
                        try {
                            CustomError customMsg = (CustomError)installerProxy.getService(CustomError.class);
                            customMsg.setLogDescription("Error while updating packages." + e.getLocalizedMessage());
                            customMsg.log();
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                }
                Object serviceName = instanceServiceMap.get(inst);
                if (inst.equals(defaultInstName)) {
                    serviceName = "\"" + (String)defaultInstServiceName + "\"";
                } else if (serviceName == null) {
                    serviceName = "\"" + (String)defaultInstServiceName + " " + inst + "\"";
                }
                String serviceDescription = Executes.exec("sc qdescription " + (String)serviceName, true, installerProxy);
                if (serviceDescription.contains("service does not exist")) {
                    Executes.exec((String)startCommand, false, installerProxy);
                } else {
                    String startServiceCommand = "sc start " + (String)serviceName;
                    Executes.exec(startServiceCommand, false, installerProxy);
                }
            } else {
                block49: {
                    updatePackagesCommand = instanceRoot + "/bin/cfpm.sh update packages";
                    try {
                        Executes.exec((String)updatePackagesCommand, true, installerProxy);
                    }
                    catch (Throwable e) {
                        if (installerProxy == null) break block49;
                        try {
                            CustomError customMsg = (CustomError)installerProxy.getService(CustomError.class);
                            customMsg.setLogDescription("Error while updating packages." + e.getLocalizedMessage());
                            customMsg.log();
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                }
                Executes.exec((String)startCommand, false, installerProxy);
            }
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (isWindows.equals("true")) {
            String restartOdbc = installerProxy.substitute("$RESTART_ODBC$");
            String restartJetty = installerProxy.substitute("$RESTART_JETTY$");
            String restartDotnet = installerProxy.substitute("$RESTART_DOTNET$");
            if (restartOdbc != null && restartOdbc.equals("true")) {
                String odbcServiceSrvName = "\"" + cfVersion + " ODBC Server\"";
                String odbcServiceAgentName = "\"" + cfVersion + " ODBC Agent\"";
                Executes.exec("sc start " + odbcServiceSrvName, false, installerProxy);
                Executes.exec("sc start " + odbcServiceAgentName, false, installerProxy);
            }
            if (restartJetty != null && restartJetty.equals("true")) {
                String addOnServiceName = installerProxy.substitute("$JETTY_SERVICENAME$");
                Executes.exec("sc start " + addOnServiceName, false, installerProxy);
            }
            if (restartDotnet != null && restartDotnet.equals("true")) {
                String dotnetServiceName = "\"" + cfVersion + " .NET Service\"";
                Executes.exec("sc start " + dotnetServiceName, false, installerProxy);
            }
        }
        if ((hfJettyScriptPath = installerProxy.substitute("$JETTY_SCRIPT_PATH$")) != null && new File(hfJettyScriptPath).exists()) {
            String hfJettyScriptPathToUse = "";
            String updatePackagesCommand = "";
            String installerUI = installerProxy.substitute("$INSTALLER_UI$");
            String installFromCommand = installerProxy.substitute("$COMMAND_INSTALL$");
            hfJettyScriptPathToUse = isProcessRunningAsRoot && !isWindows.equals("true") ? hfJettyScriptPath.replace("_hf", "") : (installerUI != null && installerUI.equals("SILENT") && File.separatorChar == '/' && installFromCommand != null && !installFromCommand.equalsIgnoreCase("true") ? hfJettyScriptPath : hfJettyScriptPath.replace("_hf", ""));
            Executes.exec(hfJettyScriptPathToUse + " start", false, installerProxy);
        }
    }
}

