/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.AccessPosition;
import ice.pilots.html4.BlockBox;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DRange;
import ice.pilots.html4.DTextNode;
import ice.pilots.html4.ImageObjectPainter;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.TextBox;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.lang.reflect.Method;
import java.util.Vector;

public class SelectionAgent {
    private DNode cachedStartNode;
    private int cachedStartOffset;
    private int originalSelectionLine;
    private int originalSelectionY;
    private AccessPosition startMarker;
    private AccessPosition endMarker;
    private boolean startTested;
    private DRange selection;
    private boolean somethingSelected;
    private Vector highlightNodes;
    private TextTransfer textTransfer;
    private Clipboard clippy;
    private static boolean printedWarning;
    static /* synthetic */ Class class$java$awt$Toolkit;

    public SelectionAgent(DRange range) {
        block5: {
            this.selection = range;
            this.highlightNodes = new Vector();
            this.startMarker = new AccessPosition();
            this.endMarker = new AccessPosition();
            Toolkit t = Toolkit.getDefaultToolkit();
            Class toolkitClass = class$java$awt$Toolkit == null ? (class$java$awt$Toolkit = SelectionAgent.class$("java.awt.Toolkit")) : class$java$awt$Toolkit;
            Object[] mArgs = new Class[]{};
            try {
                Method clipMethod = toolkitClass.getMethod("getSystemSelection", (Class<?>[])mArgs);
                this.clippy = (Clipboard)clipMethod.invoke((Object)t, mArgs);
                if (this.clippy != null) {
                    this.textTransfer = new TextTransfer();
                } else if (!printedWarning) {
                    Debug.trace("Application Clipboard not supported in this system");
                    printedWarning = true;
                }
            }
            catch (Exception e) {
                if (printedWarning) break block5;
                Debug.trace("Exception caught loading Clipboard: " + e);
                printedWarning = true;
            }
        }
    }

    public void empty() {
        this.selection.empty();
    }

    public void clearSelection(CSSLayout layout) {
        this.cachedStartNode = null;
        this.cachedStartOffset = 0;
        this.startTested = false;
        this.originalSelectionY = 0;
        this.originalSelectionLine = 0;
        this.startMarker.clear();
        this.endMarker.clear();
        if (this.somethingSelected) {
            this.selection.empty();
            layout.publishEvent("selection", null, "cleared");
        }
        this.somethingSelected = false;
    }

    public void markDocument(CSSLayout layout, int xPos, int yPos, int scrollX, int scrollY) {
        Point ppTest = new Point();
        layout.checkInit(this.startMarker);
        CSSBox endBox = layout.getBoxAt(xPos, yPos, scrollX, scrollY, ppTest);
        if (endBox instanceof TextBox) {
            TextBox tb = (TextBox)endBox;
            int chrDx = tb.getCharacterIndex(ppTest.x, true) + tb._startingCharOffset;
            layout.positionToIndex(1, chrDx, this.startMarker);
            this.endMarker.copy(this.startMarker);
        }
    }

    public void selectAll(CSSLayout layout) {
        DNode topNode = layout.topBox.getDomNode().first;
        DNode lastNode = layout.topBox.getDomNode().last;
        if (topNode != null && lastNode != null) {
            this.selection.setRange(topNode, 0, lastNode, 0);
            this.somethingSelected = true;
            this.postSelectedToClipboard(layout);
        }
    }

    public void setSelection(CSSLayout layout, int x1, int y1, int x2, int y2, int scrollX, int scrollY) {
        DNode end = null;
        int endOffset = 0;
        Point ppStart = new Point();
        Point ppEnd = new Point();
        Point absolutePositionStart = new Point();
        Point absolutePositionEnd = new Point();
        int startLineNumber = 0;
        int endLineNumber = 0;
        CSSBox startBox = null;
        CSSBox endBox = null;
        if (!this.startTested) {
            startBox = layout.getBoxAt(x1, y1, scrollX, scrollY, ppStart);
            this.startTested = true;
            startBox.findAbsolutePosition(absolutePositionStart);
            if (startBox instanceof TextBox) {
                this.cachedStartNode = startBox.getDomNode();
                this.originalSelectionLine = ((TextBox)startBox).getRenderedLineNumber(y1 + scrollY - absolutePositionStart.y);
                if (this.originalSelectionLine < 0) {
                    this.originalSelectionLine = 0;
                }
                this.originalSelectionY = y1;
            } else if (startBox instanceof ObjectBox) {
                if (((ObjectBox)startBox).getObjectPainter() instanceof ImageObjectPainter) {
                    endLineNumber = 0;
                    startLineNumber = 0;
                    this.cachedStartNode = startBox.getDomNode();
                }
                this.originalSelectionY = y1;
            }
        }
        if ((endBox = layout.getBoxAt(x2, y2, scrollX, scrollY, ppEnd)) != null) {
            endBox.findAbsolutePosition(absolutePositionEnd);
            if (endBox instanceof BlockBox) {
                endLineNumber = ((BlockBox)endBox).getLineNumber(ppEnd.y);
                if (endLineNumber < 0) {
                    return;
                }
                endBox = y2 < this.originalSelectionY ? ((BlockBox)endBox).getLeftmostBoxInLine(endLineNumber, ppEnd) : ((BlockBox)endBox).getRightmostBoxInLine(endLineNumber, ppEnd);
                if (!(endBox instanceof TextBox) && !(endBox instanceof ObjectBox)) {
                    return;
                }
            } else if (endBox instanceof TextBox) {
                endLineNumber = ((TextBox)endBox).getRenderedLineNumber(y2 + scrollY - absolutePositionEnd.y);
                if (this.cachedStartNode == null && (startBox = layout.getBoxAt(x2, y2, scrollX, scrollY, ppStart)) != null) {
                    this.cachedStartNode = startBox.getDomNode();
                    this.originalSelectionLine = endLineNumber;
                    this.originalSelectionY = y2;
                }
            } else if (endBox instanceof ObjectBox) {
                if (((ObjectBox)endBox).getObjectPainter() instanceof ImageObjectPainter) {
                    startLineNumber = 0;
                    endLineNumber = 0;
                    if (this.cachedStartNode == null && (startBox = layout.getBoxAt(x2, y2, scrollX, scrollY, ppStart)) != null) {
                        this.cachedStartNode = startBox.getDomNode();
                        this.originalSelectionLine = endLineNumber;
                        this.originalSelectionY = y2;
                    }
                }
            } else {
                return;
            }
            end = endBox.getDomNode();
        }
        startLineNumber = this.originalSelectionLine;
        boolean leftToRightSelection = false;
        int n = startLineNumber = this.cachedStartNode == null ? endLineNumber : startLineNumber;
        if (this.cachedStartNode == end) {
            if (endLineNumber > startLineNumber) {
                leftToRightSelection = true;
            } else if (endLineNumber == startLineNumber && x2 >= x1) {
                leftToRightSelection = true;
            }
        } else {
            leftToRightSelection = y2 > this.originalSelectionY;
        }
        if (startBox != null && startBox instanceof TextBox) {
            this.cachedStartOffset = ((TextBox)startBox).getCharacterIndex(ppStart.x, leftToRightSelection);
        }
        if (endBox != null && endBox instanceof TextBox) {
            endOffset = ((TextBox)endBox).getCharacterIndex(ppEnd.x, !leftToRightSelection);
        }
        if (this.cachedStartNode != null && end != null) {
            this.selection.setRange(this.cachedStartNode, this.cachedStartOffset, end, endOffset);
            this.somethingSelected = true;
            if (startBox instanceof TextBox) {
                layout.positionToIndex(1, this.cachedStartOffset + ((TextBox)startBox)._startingCharOffset, this.startMarker);
            }
            if (endBox instanceof TextBox) {
                layout.positionToIndex(1, endOffset + ((TextBox)endBox)._startingCharOffset, this.endMarker);
            }
        }
    }

    public boolean isSelectionActive() {
        return this.somethingSelected;
    }

    void selectWord(CSSLayout layout, int x, int y, int scrollX, int scrollY) {
        int charIndex = layout.getIndexAtPoint(x, y, scrollX, scrollY, this.startMarker);
        if (charIndex == -1) {
            return;
        }
        layout.positionToIndex(1, charIndex, this.startMarker);
        layout.positionToIndex(2, this.startMarker._wordInDoc, this.startMarker);
        this.endMarker.copy(this.startMarker);
        String text = layout.getText(2, this.startMarker._wordInDoc, this.endMarker, true);
        if (text != null) {
            this.endMarker._characterInDoc += text.length();
            this.selectRangeByCharIndex(layout, this.startMarker._characterInDoc, this.endMarker._characterInDoc);
            this.postSelectedToClipboard(layout);
        }
    }

    public void selectWordByIndex(CSSLayout layout, int index) {
        this.selectWordRangeByIndex(layout, index, index);
    }

    public void selectWordRangeByIndex(CSSLayout layout, int startIndex, int endIndex) {
        layout.positionToIndex(2, startIndex, this.startMarker);
        layout.positionToIndex(2, endIndex, this.endMarker);
        this.selectRangeByCharIndex(layout, this.startMarker._characterInDoc, this.endMarker._characterInDoc);
    }

    private void selectRangeByCharIndex(CSSLayout layout, int startIndex, int endIndex) {
        DNode startNode;
        CSSBox startBox = ((BlockBox)layout.topBox).findChildByIndex(1, startIndex);
        if (startBox == null || !(startBox instanceof TextBox)) {
            return;
        }
        DNode endNode = startNode = startBox.getDomNode();
        CSSBox endBox = startBox;
        if (endIndex != startIndex) {
            endBox = ((BlockBox)layout.topBox).findChildByIndex(1, endIndex);
            if (endBox == null || !(endBox instanceof TextBox)) {
                return;
            }
            endNode = endBox.getDomNode();
        }
        int spos = startIndex - ((TextBox)startBox)._startingCharOffset;
        int epos = endIndex - ((TextBox)endBox)._startingCharOffset;
        if (spos >= 0 && epos >= 0) {
            if (startBox.boxId < endBox.boxId) {
                layout.scrollToBox((DTextNode)endNode);
            } else {
                layout.scrollToBox((DTextNode)startNode);
            }
            this.selection.setRange(startNode, spos, endNode, epos);
            this.somethingSelected = true;
        }
    }

    public void selectWordRight(CSSLayout layout) {
        if (this.endMarker._wordInDoc == this.endMarker._maxWords - 1) {
            this.endMarker._characterInDoc = this.endMarker._maxCharacters - 1;
        } else if (this.endMarker._wordInDoc < this.endMarker._maxWords) {
            ++this.endMarker._wordInDoc;
            layout.positionToIndex(2, this.endMarker._wordInDoc, this.endMarker);
        }
        this.selectRangeByCharIndex(layout, Math.min(this.startMarker._characterInDoc, this.endMarker._characterInDoc), Math.max(this.startMarker._characterInDoc, this.endMarker._characterInDoc));
    }

    public void selectCharRight(CSSLayout layout) {
        if (this.endMarker._characterInDoc < this.endMarker._maxCharacters) {
            ++this.endMarker._characterInDoc;
            layout.positionToIndex(1, this.endMarker._characterInDoc, this.endMarker);
            this.selectRangeByCharIndex(layout, Math.min(this.startMarker._characterInDoc, this.endMarker._characterInDoc), Math.max(this.startMarker._characterInDoc, this.endMarker._characterInDoc));
        }
    }

    public void selectSentenceRight(CSSLayout layout) {
        if (this.endMarker._sentenceInDoc == this.endMarker._maxSentences - 1) {
            this.endMarker._characterInDoc = this.endMarker._maxCharacters - 1;
            this.endMarker._wordInDoc = this.endMarker._maxWords - 1;
        } else if (this.endMarker._sentenceInDoc < this.endMarker._maxSentences) {
            ++this.endMarker._sentenceInDoc;
            layout.positionToIndex(3, this.endMarker._sentenceInDoc, this.endMarker);
        }
        this.selectRangeByCharIndex(layout, Math.min(this.startMarker._characterInDoc, this.endMarker._characterInDoc), Math.max(this.startMarker._characterInDoc, this.endMarker._characterInDoc));
    }

    public void selectWordLeft(CSSLayout layout) {
        if (this.endMarker._wordInDoc > 0) {
            --this.endMarker._wordInDoc;
            layout.positionToIndex(2, this.endMarker._wordInDoc, this.endMarker);
            this.selectRangeByCharIndex(layout, Math.min(this.startMarker._characterInDoc, this.endMarker._characterInDoc), Math.max(this.startMarker._characterInDoc, this.endMarker._characterInDoc));
        }
    }

    public void selectCharLeft(CSSLayout layout) {
        if (this.endMarker._characterInDoc > 0) {
            --this.endMarker._characterInDoc;
            layout.positionToIndex(1, this.endMarker._characterInDoc, this.endMarker);
            this.selectRangeByCharIndex(layout, Math.min(this.startMarker._characterInDoc, this.endMarker._characterInDoc), Math.max(this.startMarker._characterInDoc, this.endMarker._characterInDoc));
        }
    }

    public void selectSentenceLeft(CSSLayout layout) {
        if (this.endMarker._sentenceInDoc > 0) {
            --this.endMarker._sentenceInDoc;
            layout.positionToIndex(3, this.endMarker._sentenceInDoc, this.endMarker);
            this.selectRangeByCharIndex(layout, Math.min(this.startMarker._characterInDoc, this.endMarker._characterInDoc), Math.max(this.startMarker._characterInDoc, this.endMarker._characterInDoc));
        }
    }

    public String toString() {
        return this.selection.toString();
    }

    public DNode getStartContainer() {
        return this.selection.getStartContainer();
    }

    public DNode getEndContainer() {
        return this.selection.getEndContainer();
    }

    public int getStartOffset() {
        return this.selection.getStartOffset();
    }

    public int getEndOffset() {
        return this.selection.getEndOffset();
    }

    public void select(DNode n1, int off1, DNode n2, int off2, CSSLayout layout) {
        layout.scrollToBox((DTextNode)n2);
        this.somethingSelected = true;
        this.selection.setRange(n1, off1, n2, off2);
        this.postSelectedToClipboard(layout);
    }

    public boolean isInside(DNode node) {
        return this.selection.isInside(node);
    }

    public boolean isInside(CSSLayout layout, int xPos, int yPos, int scrollX, int scrollY) {
        CSSBox cb;
        Point p;
        DNode node;
        boolean selected = false;
        if (this.somethingSelected && (node = layout.getBoxAt(xPos, yPos, scrollX, scrollY, p = new Point()).getDomNode()) instanceof DTextNode && (cb = layout.findCSSBox(node)) != null && cb instanceof TextBox) {
            TextBox tx = (TextBox)cb;
            int characterIndex = tx.getCharacterIndex(p.x, true);
            selected = this.selection.isInside(node, characterIndex);
        }
        return selected;
    }

    public DElement getSelectionParentNode() {
        if (this.somethingSelected) {
            return this.selection.duplicateSelectedDomHierarchy();
        }
        return null;
    }

    public void defineHighlight(CSSBox box, int startIndex, int endIndex) {
        if (box != null) {
            box.highlightArea(startIndex, endIndex);
            if (!this.highlightNodes.contains(box)) {
                this.highlightNodes.addElement(box);
            }
        }
    }

    public void clearHighlights() {
        for (int idx = 0; idx < this.highlightNodes.size(); ++idx) {
            CSSBox box = (CSSBox)this.highlightNodes.elementAt(idx);
            box.clearHighlights();
        }
        this.highlightNodes.removeAllElements();
    }

    public void postSelectedToClipboard(CSSLayout layout) {
        if (!this.somethingSelected) {
            return;
        }
        layout.publishEvent("selection", null, "defined");
        if (this.clippy != null) {
            String text = this.toString();
            this.textTransfer.setClipboardContents(text);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class TextTransfer
    implements ClipboardOwner {
        TextTransfer() {
        }

        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }

        public void setClipboardContents(String aString) {
            StringSelection stringSelection = new StringSelection(aString);
            SelectionAgent.this.clippy.setContents(stringSelection, this);
        }
    }
}

