/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import java.util.Vector;

class CSSCounters {
    private int num = 0;
    private int maxNum = 8;
    private int[] values = new int[this.maxNum];
    private String[] names = new String[this.maxNum];

    CSSCounters() {
    }

    void clear() {
        this.num = 0;
    }

    void resetCounters(Vector v) {
        for (int i = 0; i < v.size(); i += 2) {
            String name = (String)v.elementAt(i);
            Integer val = (Integer)v.elementAt(i + 1);
            if (this.num == this.maxNum) {
                this.grow();
            }
            this.names[this.num] = name;
            this.values[this.num] = val;
            ++this.num;
        }
    }

    void removeCounters(Vector v) {
        this.num -= v.size() >> 1;
    }

    void incCounters(Vector v) {
        for (int i = 0; i < v.size(); i += 2) {
            String name = (String)v.elementAt(i);
            Integer val = (Integer)v.elementAt(i + 1);
            for (int j = this.num - 1; j >= 0; --j) {
                if (!this.names[j].equals(name)) continue;
                int n = j;
                this.values[n] = this.values[n] + val;
                return;
            }
            if (this.num == this.maxNum) {
                this.grow();
            }
            System.arraycopy(this.names, 0, this.names, 1, this.num);
            System.arraycopy(this.values, 0, this.values, 1, this.num);
            ++this.num;
            this.names[0] = name;
            this.values[0] = val;
        }
    }

    void updateCounters(Vector v) {
        for (int i = 0; i < v.size(); i += 2) {
            String name = (String)v.elementAt(i);
            Integer val = (Integer)v.elementAt(i + 1);
            for (int j = this.num - 1; j >= 0; --j) {
                if (!this.names[j].equals(name)) continue;
                this.values[j] = val;
                return;
            }
            if (this.num == this.maxNum) {
                this.grow();
            }
            System.arraycopy(this.names, 0, this.names, 1, this.num);
            System.arraycopy(this.values, 0, this.values, 1, this.num);
            ++this.num;
            this.names[0] = name;
            this.values[0] = val;
        }
    }

    String getCounterValue(String name, boolean multiple, String sep, int style) {
        String val = "";
        if (multiple) {
            for (int j = 0; j < this.num; ++j) {
                if (!this.names[j].equals(name)) continue;
                val = val + this.getValue(this.values[j], style);
                if (j >= this.num - 1) continue;
                val = val + sep;
            }
        } else {
            for (int j = this.num - 1; j >= 0; --j) {
                if (!this.names[j].equals(name)) continue;
                val = this.getValue(this.values[j], style);
                break;
            }
        }
        return val;
    }

    private String getValue(int i, int style) {
        switch (style) {
            case 105: 
            case 106: {
                return this.getLowerAlphaValue(i);
            }
            case 107: 
            case 108: {
                return this.getUpperAlphaValue(i);
            }
            case 102: {
                if (i <= 0) break;
                return this.getLowerRomanValue(i);
            }
            case 103: {
                if (i <= 0) break;
                return this.getUpperRomanValue(i);
            }
        }
        return String.valueOf(i);
    }

    private String getLowerAlphaValue(int n) {
        return this.getAlphaValue(n, 97, 122);
    }

    private String getUpperAlphaValue(int n) {
        return this.getAlphaValue(n, 65, 90);
    }

    private String getAlphaValue(int n, int a, int z) {
        String result = "";
        if (n == 0) {
            return "@";
        }
        int c = n;
        if (c < 0) {
            c = -c;
        }
        int num = z - a + 1;
        while (c > 0) {
            int digit = c % num - 1;
            c /= num;
            String str = String.valueOf((char)(a + digit));
            result = str + result;
        }
        if (n < 0) {
            result = "-" + result;
        }
        return result;
    }

    private String getLowerRomanValue(int n) {
        String result = this.digitToRoman(n % 10, "i", "v", "x");
        result = this.digitToRoman((n /= 10) % 10, "x", "l", "c") + result;
        result = this.digitToRoman((n /= 10) % 10, "c", "d", "m") + result;
        result = this.digitToRoman((n /= 10) % 10, "m", "h", " ") + result;
        n /= 10;
        return result;
    }

    private String getUpperRomanValue(int n) {
        String result = this.digitToRoman(n % 10, "I", "V", "X");
        result = this.digitToRoman((n /= 10) % 10, "X", "L", "C") + result;
        result = this.digitToRoman((n /= 10) % 10, "C", "D", "M") + result;
        result = this.digitToRoman((n /= 10) % 10, "M", "H", " ") + result;
        n /= 10;
        return result;
    }

    private String digitToRoman(int n, String one, String five, String ten) {
        switch (n) {
            case 1: {
                return one;
            }
            case 2: {
                return one + one;
            }
            case 3: {
                return one + one + one;
            }
            case 4: {
                return one + five;
            }
            case 5: {
                return five;
            }
            case 6: {
                return five + one;
            }
            case 7: {
                return five + one + one;
            }
            case 8: {
                return five + one + one + one;
            }
            case 9: {
                return one + ten;
            }
        }
        return "";
    }

    private final void grow() {
        this.maxNum *= 2;
        String[] tmp1 = new String[this.maxNum];
        int[] tmp2 = new int[this.maxNum];
        System.arraycopy(this.names, 0, tmp1, 0, this.num);
        System.arraycopy(this.values, 0, tmp2, 0, this.num);
        this.names = tmp1;
        this.values = tmp2;
    }
}

