/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.AccessPosition;
import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.CSSUtil;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.FloatManager;
import ice.pilots.html4.HighlightListener;
import ice.pilots.html4.LineBox;
import ice.pilots.html4.ThePilot;
import ice.util.Defs;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;

abstract class CSSBox
implements ImageObserver,
HighlightListener {
    static final int BOX_INLINE = 0;
    static final int BOX_BLOCK = 1;
    static final int BOX_FLOAT_PLACEHOLDER = 2;
    static final int BOX_DEFAULT = 3;
    protected static int idCounter;
    protected int boxId;
    protected CSSLayout cssLayout;
    protected CSSBox parentBox;
    protected CSSBox next;
    protected DElement element;
    static int debugFlag;
    private static final int tileOptMaxSize = 64;
    private static int tileOptThreshold;
    private static boolean useTransparentTiling;
    private static boolean useITextBackgrounds;
    public static final int STATIC_LEVEL = 0;
    public static final int ABSOLUTE_LEVEL = 1;
    public static final int RELATIVE_LEVEL = 2;
    public static final int FIXED_LEVEL = 3;
    protected static boolean doCompleteZIndexTest;
    CSSAttribs css;
    byte dynamic = 0;
    int numBreaks;
    int totalWidth;
    protected int _startingCharOffset;
    protected int _startingWordOffset;
    protected int _startingSentenceOffset;
    int minWidth;
    int maxWidth;
    int ox;
    int oy;
    int width;
    int height;
    static Point cachedPoint;

    protected CSSBox(DElement e, CSSAttribs css, CSSLayout cssLayout) {
        this.element = e;
        this.css = css;
        this.cssLayout = cssLayout;
        this.boxId = ++idCounter;
    }

    protected CSSBox(CSSLayout cssLayout) {
        this(null, null, cssLayout);
    }

    void dispose() {
        this.parentBox = null;
        this.cssLayout = null;
        this.next = null;
    }

    protected final boolean setVisibility(short b) {
        CSSAttribs[] atrs;
        if (this.dynamic > 0 && (atrs = (CSSAttribs[])this.cssLayout.dynamicStyles.get(this.getDomNode())) != null) {
            for (int i = 0; i < atrs.length; ++i) {
                CSSAttribs c = atrs[i];
                if (c == null || (c.misc & 0x20) == 0) continue;
                c.misc = (short)(c.misc & 0xFFFFFFFE);
                c.misc = (short)(c.misc | b & 1);
            }
        }
        if ((this.css.misc & 0x20) == 0) {
            return false;
        }
        this.css.misc = (short)(this.css.misc & 0xFFFFFFFE);
        this.css.misc = (short)(this.css.misc | b & 1);
        return true;
    }

    public CSSAttribs getCSSAttribs() {
        return this.css;
    }

    void propagateVisibility(short b, boolean self) {
        if (self) {
            this.setVisibility(b);
        }
    }

    void notifyChildrenGenerated() {
    }

    CSSBox getLast() {
        return null;
    }

    void setParentBox(CSSBox parentBox) {
        this.parentBox = parentBox;
    }

    final CSSBox getParentBox() {
        return this.parentBox;
    }

    CSSBox getFirstChild() {
        return null;
    }

    public void highlightArea(int startPosition, int endPosition) {
    }

    public void clearHighlights() {
    }

    int getType() {
        return 3;
    }

    void invalidate() {
        CSSBox b = this;
        while (b != null) {
            b.minWidth = 0;
            b = b.parentBox;
        }
    }

    CSSBox getBoxAt(int x, int y, Point rv) {
        rv.x = x;
        rv.y = y;
        return this;
    }

    void applyDynamicStyle(int eventId) {
        CSSBox pb = this.parentBox;
        if (pb != null) {
            pb.applyDynamicStyle(eventId);
        }
    }

    void findAbsolutePosition(Point p) {
        p.x += this.ox;
        p.y += this.oy;
        if (this.parentBox != null) {
            this.parentBox.findAbsolutePosition(p);
        }
    }

    protected void findAbsPos(Point p) {
        this.findAbsolutePosition(p);
    }

    void findAbsolutePosition_int(Point p) {
        this.findAbsolutePosition(p);
    }

    void findBoundingBoxForPrinting(Point p) {
        p.x += this.ox;
        p.y += this.oy;
        if (this.parentBox != null) {
            this.parentBox.findBoundingBoxForPrinting(p);
        }
    }

    void findBoundingBox(Rectangle r) {
    }

    DNode getDomNode() {
        return null;
    }

    int calcBreaks() {
        return 0;
    }

    int getBreaks(int[] breaks, int idx) {
        return 0;
    }

    long getChunkDescentAscent(int x, int w, LineBox aLineMetrics) {
        return 0L;
    }

    void paintChunk(Graphics g, int x, int w, LineBox aLineMetrics, int aBoxId) {
    }

    int getCount(int aType, Point p) {
        return 0;
    }

    String getText(int aType, int aIndex, AccessPosition aCarat) {
        return null;
    }

    CSSBox findChildByIndex_r(int aType, int aIndex, Point aPoint) {
        return null;
    }

    int getStartingCharacterOffset() {
        return -1;
    }

    void calcMinMaxWidths() {
    }

    void layout(int parentContentWidth, int parentContentHeight, FloatManager m) {
    }

    void paint(Graphics g) {
    }

    CSSBox addChild(CSSBox b) {
        return this;
    }

    void reqReflow() {
        this.cssLayout.refresh();
    }

    void reqRepaint() {
        if (this.cssLayout != null && this.cssLayout.docPane != null) {
            this.cssLayout.docPane.reqRepaint();
        }
    }

    public String toString() {
        DNode n = this.getDomNode();
        String s = "NoNode";
        if (n != null) {
            s = n.toString();
        }
        return super.toString() + "[" + s + "]";
    }

    protected void paintBackground(Graphics g, Rectangle clip_r, int aX, int aY, int aW, int aH, int vadjust) {
        int y_clip_shift;
        boolean noBackground = false;
        Color backColor = this.css.background_color;
        Image backImage = null;
        if (this.css.background_image instanceof Image) {
            backImage = (Image)this.css.background_image;
        }
        if (this.cssLayout.topBox == this && backColor == null) {
            CSSBox f = this.getFirstChild();
            if (f != null) {
                Object o;
                if (backImage == null && (o = f.css.background_image) instanceof Image) {
                    backImage = (Image)o;
                    f.css.background_image = null;
                    this.css.background_params = f.css.background_params;
                    ThePilot.prepareImage(backImage, this);
                    this.css.background_image = backImage;
                }
                backColor = f.css.background_color;
                f.css.background_color = null;
            }
            if (backColor == null) {
                noBackground = true;
                backColor = Color.white;
            }
            this.css.background_color = backColor;
        }
        if (backImage == null && backColor == null) {
            return;
        }
        int boxWidth = aW;
        int boxHeight = aH;
        int x_clip_shift = clip_r.x - aX;
        if (x_clip_shift > 0) {
            aX = clip_r.x;
            if (clip_r.width < (aW -= x_clip_shift)) {
                aW = clip_r.width;
            }
        } else if (clip_r.width + x_clip_shift < aW) {
            aW = clip_r.width + x_clip_shift;
        }
        if ((y_clip_shift = clip_r.y - aY) > 0) {
            aY = clip_r.y;
            if (clip_r.height < (aH -= y_clip_shift)) {
                aH = clip_r.height;
            }
        } else if (clip_r.height + y_clip_shift < aH) {
            aH = clip_r.height + y_clip_shift;
        }
        if (aW > 0 && aH > 0) {
            if (backColor != null) {
                g.setColor(backColor);
                if (useITextBackgrounds) {
                    g.fillRect(aX - 1, aY - 1, aW, aH);
                } else if (!noBackground) {
                    g.fillRect(aX, aY, aW, aH);
                }
            }
            if (backImage != null) {
                this.setImageForBackground(g, backImage);
                this.paintBackgroundImage(g, backImage, boxWidth, boxHeight, aX, aY, aW, aH, vadjust);
            }
        }
    }

    private void paintBackgroundImage(Graphics g, Image img, int boxWidth, int boxHeight, int x, int y, int w, int h, int vadjust) {
        boolean repeat_y;
        boolean isBackgroundImage = img.getAccelerationPriority() == 0.99f;
        int orig_iw = img.getWidth(this);
        int orig_ih = img.getHeight(this);
        if (orig_iw < 1 || orig_ih < 1) {
            return;
        }
        boolean repeat_x = 0 == (this.css.background_params & 1);
        boolean bl = repeat_y = 0 == (this.css.background_params & 2);
        if ((orig_iw < tileOptThreshold || orig_ih < tileOptThreshold) && this.css.background_params == 0) {
            return;
        }
        if (orig_iw == 1 && orig_ih == 1 && repeat_x && repeat_y) {
            g.drawImage(img, 0, 0, 1, 1, x, y, w, h, this);
            return;
        }
        int iw = orig_iw;
        int ih = orig_ih;
        int zoom = this.cssLayout.getLayoutZoom();
        iw = iw * zoom >> 8;
        ih = ih * zoom >> 8;
        if (iw == 0) {
            iw = 1;
        }
        if (ih == 0) {
            ih = 1;
        }
        int widthForCalcs = boxWidth;
        int heightForCalcs = boxHeight;
        if ((this.css.background_params & 4) != 0 & this.cssLayout.docPane != null) {
            widthForCalcs = this.cssLayout.docPane.getPaneWidth();
            heightForCalcs = this.cssLayout.docPane.getPaneHeight();
        }
        int topLeftX = 0;
        int topLeftY = 0;
        if ((this.css.background_params & 0x1F0) > 0) {
            topLeftX = widthForCalcs / 2 - iw / 2;
            topLeftY = heightForCalcs / 2 - ih / 2;
            if ((this.css.background_params & 0x100) > 0) {
                topLeftX = 0;
            }
            if ((this.css.background_params & 0x10) > 0) {
                topLeftX = widthForCalcs - iw;
            }
            if ((this.css.background_params & 0x40) > 0) {
                topLeftY = 0;
            }
            if ((this.css.background_params & 0x80) > 0) {
                topLeftY = heightForCalcs - ih;
            }
        } else {
            if ((this.css.background_params & 0x200) > 0) {
                topLeftX = (this.css.percentage_flag & 1) > 0 ? (widthForCalcs - iw) * this.css.background_position_x / 100 : (int)this.css.background_position_x;
            }
            if ((this.css.background_params & 0x400) > 0) {
                topLeftY = (this.css.percentage_flag & 2) > 0 ? (heightForCalcs - ih) * this.css.background_position_y / 100 : (int)this.css.background_position_y;
            }
        }
        Rectangle paintingRect = null;
        paintingRect = !this.cssLayout.inPrintMode ? new Rectangle(this.cssLayout.docPane.getScrollX(), this.cssLayout.docPane.getScrollY(), this.cssLayout.docPane.getPaneWidth(), this.cssLayout.docPane.getPaneHeight()) : this.cssLayout.imageablePrintArea;
        int widthToPaint = 0;
        int heightToPaint = 0;
        if ((this.css.background_params & 4) != 0) {
            int scrollX = 0;
            int scrollY = 0;
            if (this.cssLayout != null && this.cssLayout.docPane != null) {
                scrollX = this.cssLayout.docPane.getScrollX();
                scrollY = this.cssLayout.docPane.getScrollY();
            }
            CSSBox.cachedPoint.x = -scrollX;
            CSSBox.cachedPoint.y = -scrollY - vadjust;
            this.findAbsolutePosition(cachedPoint);
            topLeftX -= CSSBox.cachedPoint.x;
            topLeftY -= CSSBox.cachedPoint.y;
            if (this.cssLayout.docPane != null) {
                widthToPaint = this.cssLayout.docPane.getDocWidth();
                heightToPaint = this.cssLayout.docPane.getDocHeight();
            } else if (this.cssLayout.docPane == null && this.cssLayout.inPrintMode) {
                widthToPaint = this.cssLayout.imageablePrintArea.width;
                heightToPaint = this.cssLayout.imageablePrintArea.height;
            }
        } else {
            widthToPaint = boxWidth;
            heightToPaint = boxHeight;
        }
        int tilingY = topLeftY;
        int tilingX = topLeftX;
        if (repeat_x) {
            tilingX = topLeftX % iw - iw;
        }
        if (repeat_y) {
            tilingY = topLeftY % ih - ih;
        }
        Rectangle saveShape = g.getClip().getBounds();
        Graphics clippingBounds = g.create(0, 0, boxWidth, boxHeight);
        Rectangle shape = clippingBounds.getClip().getBounds();
        clippingBounds.dispose();
        g.setClip(shape);
        while (tilingY < heightToPaint) {
            for (int tx = tilingX; tx < widthToPaint; tx += iw) {
                if (isBackgroundImage) {
                    this.setImageForBackground(g, img);
                }
                if (useITextBackgrounds && (repeat_x || repeat_y) && this.cssLayout.inPrintMode) {
                    Rectangle imgRect = new Rectangle(tx, tilingY, iw, ih);
                    if (!imgRect.intersects(paintingRect)) continue;
                    if (zoom != 256) {
                        g.drawImage(img, tx, tilingY, iw, ih, this);
                        continue;
                    }
                    g.drawImage(img, tx, tilingY, this);
                    continue;
                }
                if (zoom != 256) {
                    g.drawImage(img, tx, tilingY, iw, ih, this);
                    continue;
                }
                g.drawImage(img, tx, tilingY, this);
                if (repeat_x) continue;
            }
            tilingY += ih;
            if (repeat_y) continue;
            break;
        }
        g.setClip(saveShape);
    }

    private void setImageForBackground(Graphics g, Image img) {
        if ("org.apache.poi.hslf.model.PPGraphics2D".equalsIgnoreCase(g.getClass().getName())) {
            img.setAccelerationPriority(0.99f);
        }
    }

    void loadBackgroundImage(DDocument doc) {
        boolean flag;
        String loc = this.css.background_image_url;
        if (loc == null) {
            loc = this.css.background_image instanceof String ? (String)this.css.background_image : "";
        }
        String url = doc.resolveUrl(loc);
        Image img = doc.getPilot().objectPool.loadImage(url);
        this.css.background_image = img;
        if (img != null && (flag = ThePilot.prepareImage(img, this))) {
            this.imageUpdate(img, 32, 0, 0, -1, -1);
        }
    }

    public boolean imageUpdate(Image img, int info, int x, int y, int w, int h) {
        boolean frame;
        if (this.cssLayout == null) {
            return false;
        }
        if (this.cssLayout.docPane == null && !this.cssLayout.inPrintMode) {
            return false;
        }
        if ((info & 0xC0) != 0 || this.css.background_image != img) {
            if (this.css != null) {
                this.css.background_image = null;
                this.reqRepaint();
            }
            return false;
        }
        boolean all = (info & 0x20) != 0;
        boolean bl = frame = (info & 0x10) != 0;
        if (all || frame) {
            boolean pretiled = false;
            if (this.css != null) {
                pretiled = this.pretileImage(img, this.css.background_image_url);
            }
            if (!pretiled) {
                this.reqRepaint();
            }
            return frame && this.cssLayout.doImageAnimation && !pretiled && this.css.background_image != null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean pretileImage(Image img, String URL) {
        iw = img.getWidth(null);
        ih = img.getHeight(null);
        if (iw <= 0 || ih <= 0) {
            return false;
        }
        if (iw == 1 && ih == 1) {
            return false;
        }
        if (iw >= CSSBox.tileOptThreshold && ih >= CSSBox.tileOptThreshold) {
            return false;
        }
        if (iw >= 64) ** GOTO lbl-1000
        if ((this.css.background_params & 1) == 0) {
            countx = (64 + iw - 1) / iw;
        } else lbl-1000:
        // 2 sources

        {
            countx = 1;
        }
        if (ih >= 64) ** GOTO lbl-1000
        if ((this.css.background_params & 2) == 0) {
            county = (64 + ih - 1) / ih;
        } else lbl-1000:
        // 2 sources

        {
            county = 1;
        }
        if (countx == 1 && county == 1) {
            return false;
        }
        tiledImage = null;
        temp = null;
        temp = URL + "_" + countx + "_" + county;
        tiledImage = this.cssLayout.doc.getPilot().objectPool.getTiledImage(temp);
        hashkey = temp;
        if (tiledImage != null) {
            this.css.background_image = tiledImage;
            this.css.background_params = (short)(this.css.background_params | 8);
        } else {
            if (CSSBox.useTransparentTiling) {
                pg = new PixelGrabber(img, 0, 0, iw, ih, false){

                    public void abortGrabbing() {
                        super.abortGrabbing();
                        CSSBox.this.transparentTilingImpl(null, null, iw, ih, countx, county);
                    }

                    public void imageComplete(int status) {
                        super.imageComplete(status);
                        if (status == 1 || status == 4) {
                            CSSBox.this.transparentTilingImpl(null, null, iw, ih, countx, county);
                        } else {
                            CSSBox.this.transparentTilingImpl(this.getPixels(), this.getColorModel(), iw, ih, countx, county);
                        }
                        if (CSSBox.this.cssLayout != null && !CSSBox.this.cssLayout.inPrintMode) {
                            CSSBox.this.cssLayout.doc.getPilot().objectPool.addTiledImageToCache(hashkey, (Image)CSSBox.this.css.background_image);
                        }
                    }
                };
                pg.startGrabbing();
                return true;
            }
            tw = countx * iw;
            th = county * ih;
            tiled = this.cssLayout.docPane.createImage(tw, th);
            g = tiled.getGraphics();
            try {
                for (y = 0; y < county; ++y) {
                    for (x = 0; x < countx; ++x) {
                        g.drawImage(img, x * iw, y * ih, null);
                    }
                }
            }
            finally {
                g.dispose();
            }
            this.css.background_params = (short)(this.css.background_params | 8);
            this.css.background_image = tiled;
        }
        this.reqRepaint();
        return true;
    }

    void transparentTilingImpl(Object pixels, ColorModel cm, int iw, int ih, int countx, int county) {
        if (pixels == null || cm == null) {
            this.css.background_image = null;
            this.reqRepaint();
            return;
        }
        int tiledWidth = iw * countx;
        int tiledHeight = ih * county;
        int tiledSize = tiledWidth * tiledHeight;
        Object[] tiledPixels = pixels instanceof byte[] ? new byte[tiledSize] : (Object[])new int[tiledSize];
        for (int i = 0; i != ih; ++i) {
            System.arraycopy(pixels, i * iw, tiledPixels, i * tiledWidth, iw);
            CSSBox.tileBlock(tiledPixels, i * tiledWidth, iw, countx);
        }
        CSSBox.tileBlock(tiledPixels, 0, ih * tiledWidth, county);
        MemoryImageSource mis = pixels instanceof byte[] ? new MemoryImageSource(tiledWidth, tiledHeight, cm, (byte[])tiledPixels, 0, tiledWidth) : new MemoryImageSource(tiledWidth, tiledHeight, cm, (int[])tiledPixels, 0, tiledWidth);
        Image tiled = Toolkit.getDefaultToolkit().createImage(mis);
        this.css.background_params = (short)(this.css.background_params | 8);
        this.css.background_image = tiled;
        this.reqRepaint();
    }

    private static void tileBlock(Object array, int offset, int width, int count) {
        int n = 1;
        while (n * 2 <= count) {
            System.arraycopy(array, offset, array, offset + n * width, n * width);
            n *= 2;
        }
        System.arraycopy(array, offset, array, offset + n * width, (count - n) * width);
    }

    protected void paintBorders(Graphics g, Rectangle r, int x, int y, int w, int h, boolean isTop, boolean isBottom, boolean isLeft, boolean isRight) {
        int i;
        int dv2;
        int dv1;
        int v2;
        int v1;
        int y2;
        int y1;
        CSSBox b;
        Color c;
        if (isTop && y + this.css.border_top_width > r.y && y < r.y + r.height) {
            c = this.css.border_top_color;
            if (c == null && (this.css.border_top_style == 154 || this.css.border_top_style == 155)) {
                b = this;
                while (b != null && c == null) {
                    c = b.css.background_color;
                    b = b.parentBox;
                }
            }
            if (c == null) {
                c = this.css.color;
            }
            this.css.border_top_color = c;
            if (c != CSSAttribs.COLOR_TRANSPARENT) {
                if (this.css.border_top_style == 148 || this.css.border_top_style == 149) {
                    g.setColor(c);
                    CSSUtil.drawStyledLine(g, x, y, x + w - 1, y, this.css.border_top_style, this.css.border_top_width);
                } else {
                    if (this.css.border_top_style == 154) {
                        c = this.makeDark(c);
                    } else if (this.css.border_top_style == 155) {
                        c = this.makeBright(c);
                    }
                    g.setColor(c);
                    for (int i2 = 0; i2 < this.css.border_top_width; ++i2) {
                        g.drawLine(x, y + i2, x + w - 1, y + i2);
                    }
                }
            }
        }
        if (isBottom && y + h > r.y && y + h - this.css.border_bottom_width < r.y + r.height) {
            c = this.css.border_bottom_color;
            if (c == null && (this.css.border_bottom_style == 154 || this.css.border_bottom_style == 155)) {
                b = this;
                while (b != null && c == null) {
                    c = b.css.background_color;
                    b = b.parentBox;
                }
            }
            if (c == null) {
                c = this.css.color;
            }
            this.css.border_bottom_color = c;
            if (c != CSSAttribs.COLOR_TRANSPARENT) {
                if (this.css.border_bottom_style == 148 || this.css.border_bottom_style == 149) {
                    g.setColor(c);
                    int yy = y + h - this.css.border_bottom_width;
                    CSSUtil.drawStyledLine(g, x, yy, x + w - 1, yy, this.css.border_bottom_style, this.css.border_bottom_width);
                } else {
                    if (this.css.border_bottom_style == 154) {
                        c = this.makeBright(c);
                    } else if (this.css.border_bottom_style == 155) {
                        c = this.makeDark(c);
                    }
                    g.setColor(c);
                    for (int i3 = this.css.border_bottom_width; i3 > 0; --i3) {
                        g.drawLine(x, y + h - i3, x + w - 1, y + h - i3);
                    }
                }
            }
        }
        if (isLeft) {
            c = this.css.border_left_color;
            if (c == null && (this.css.border_left_style == 154 || this.css.border_left_style == 155)) {
                CSSBox b2 = this;
                while (b2 != null && c == null) {
                    c = b2.css.background_color;
                    b2 = b2.parentBox;
                }
            }
            if (c == null) {
                c = this.css.color;
            }
            this.css.border_left_color = c;
            if (c != CSSAttribs.COLOR_TRANSPARENT) {
                if (this.css.border_left_style == 148 || this.css.border_left_style == 149) {
                    g.setColor(c);
                    CSSUtil.drawStyledLine(g, x, y, x, y + h - 1, this.css.border_left_style, this.css.border_left_width);
                } else {
                    if (this.css.border_left_style == 154) {
                        c = this.makeDark(c);
                    } else if (this.css.border_left_style == 155) {
                        c = this.makeBright(c);
                    }
                    g.setColor(c);
                    int n = this.css.border_left_width;
                    y1 = y;
                    y2 = y + h;
                    if (y1 < r.y - n) {
                        y1 = r.y - n;
                    }
                    if (y2 > r.y + r.height + n) {
                        y2 = r.y + r.height + n;
                    }
                    v1 = 0;
                    v2 = 0;
                    dv1 = 0;
                    dv2 = 0;
                    if (isTop) {
                        dv1 = (this.css.border_top_width << 16) / n;
                    }
                    if (isBottom) {
                        dv2 = (this.css.border_bottom_width << 16) / n;
                    }
                    i = 0;
                    while (i < n) {
                        g.drawLine(x + i, y1 + (v1 >> 16), x + i, y2 - (v2 >> 16) - 1);
                        ++i;
                        v1 += dv1;
                        v2 += dv2;
                    }
                }
            }
        }
        if (isRight) {
            c = this.css.border_right_color;
            if (c == null && (this.css.border_right_style == 154 || this.css.border_right_style == 155)) {
                CSSBox b3 = this;
                while (b3 != null && c == null) {
                    c = b3.css.background_color;
                    b3 = b3.parentBox;
                }
            }
            if (c == null) {
                c = this.css.color;
            }
            this.css.border_right_color = c;
            if (c != CSSAttribs.COLOR_TRANSPARENT) {
                if (this.css.border_right_style == 148 || this.css.border_right_style == 149) {
                    g.setColor(c);
                    int xx = x + w - this.css.border_right_width;
                    CSSUtil.drawStyledLine(g, xx, y, xx, y + h - 1, this.css.border_right_style, this.css.border_right_width);
                } else {
                    if (this.css.border_right_style == 154) {
                        c = this.makeBright(c);
                    } else if (this.css.border_right_style == 155) {
                        c = this.makeDark(c);
                    }
                    g.setColor(c);
                    int n = this.css.border_right_width;
                    y1 = y;
                    y2 = y + h;
                    if (y1 < r.y - n) {
                        y1 = r.y - n;
                    }
                    if (y2 > r.y + r.height + n) {
                        y2 = r.y + r.height + n;
                    }
                    v1 = 0;
                    v2 = 0;
                    dv1 = 0;
                    dv2 = 0;
                    if (isTop) {
                        dv1 = (this.css.border_top_width << 16) / n;
                    }
                    if (isBottom) {
                        dv2 = (this.css.border_bottom_width << 16) / n;
                    }
                    i = 0;
                    while (i < n) {
                        g.drawLine(x + w - i - 1, y1 + (v1 >> 16), x + w - i - 1, y2 - (v2 >> 16) - 1);
                        ++i;
                        v1 += dv1;
                        v2 += dv2;
                    }
                }
            }
        }
    }

    private final Color makeDark(Color c) {
        if (c.equals(Color.black)) {
            return Color.gray;
        }
        if (c.equals(Color.white)) {
            return Color.gray;
        }
        return c.darker();
    }

    private final Color makeBright(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        if (r == 0 && g == 0 && b == 0) {
            return Color.lightGray;
        }
        if (r == 255 && g == 255 && b == 255) {
            return Color.lightGray;
        }
        int rr = (r << 1) + r >> 1;
        int gg = (g << 1) + g >> 1;
        int bb = (b << 1) + b >> 1;
        if (rr > 255) {
            rr = 255;
        }
        if (gg > 255) {
            gg = 255;
        }
        if (bb > 255) {
            bb = 255;
        }
        if (rr == r && gg == g && bb == b) {
            if (bb == 0) {
                bb += 128;
                if (rr == 255 && gg == 255) {
                    bb += 127;
                }
            }
            if (rr == 0) {
                rr += 128;
            }
            if (gg == 0) {
                gg += 128;
            }
        }
        return new Color(rr, gg, bb);
    }

    static long wrapDescentAscent(int aDescent, int aAscent, int aLineHeight) {
        return (long)(aLineHeight & 0xFFFF) << 32 | (long)(aDescent & 0xFFFF) << 16 | (long)aAscent & 0xFFFFL;
    }

    static int unwrapDescent(long aDawrap) {
        int val = 0xFFFF & (int)aDawrap >> 16;
        val <<= 16;
        return val >>= 16;
    }

    static int unwrapAscent(long aDawrap) {
        int val = 0xFFFF & (int)aDawrap;
        val <<= 16;
        return val >>= 16;
    }

    static int unwrapLineHeight(long aDawrap) {
        int val = 0xFFFF & (int)(aDawrap >> 32);
        val <<= 16;
        return val >>= 16;
    }

    static int getValueOrPercentage(int flagWord, int flag, int value, int control) {
        if (value == -123456) {
            return value;
        }
        if ((flagWord & flag) > 0) {
            return value * control / 100;
        }
        return value;
    }

    public boolean checkIfVisible() {
        boolean visible = true;
        if (doCompleteZIndexTest) {
            visible = this.isZOrderVisible();
        }
        return visible;
    }

    public void calculateBreaks(int parentContentWidth) {
    }

    private boolean isZOrderVisible() {
        boolean visible = true;
        if (this.cssLayout != null) {
            CSSBox box = this.cssLayout.topBox;
            if ((box = box.getFirstChild()) != null && box.element != null && box.element.getNameId() == 13 && this.css != null && box.css != null && this.css.z_index < box.css.z_index) {
                visible = false;
            }
        }
        return visible;
    }

    static {
        useTransparentTiling = true;
        useITextBackgrounds = false;
        String s = "ice.pilots.html4.tileOptThreshold";
        tileOptThreshold = Defs.intProperty(s, 32);
        if (tileOptThreshold < 0) {
            tileOptThreshold = 0;
        } else if (tileOptThreshold > 32) {
            tileOptThreshold = 32;
        }
        useITextBackgrounds = Defs.booleanProperty("ice.pilots.html4.printBackgrounds.iTextMode", false);
        doCompleteZIndexTest = Defs.booleanProperty("ice.pilots.html4.doZIndexTest", false);
        cachedPoint = new Point();
    }
}

