/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.org.slf4j.jul;

import java.util.logging.LogRecord;
import java.util.logging.Logger;
import macromedia.jdbc.sqlserver.externals.org.slf4j.Marker;
import macromedia.jdbc.sqlserver.externals.org.slf4j.event.Level;
import macromedia.jdbc.sqlserver.externals.org.slf4j.event.LoggingEvent;
import macromedia.jdbc.sqlserver.externals.org.slf4j.helpers.AbstractLogger;
import macromedia.jdbc.sqlserver.externals.org.slf4j.helpers.FormattingTuple;
import macromedia.jdbc.sqlserver.externals.org.slf4j.helpers.LegacyAbstractLogger;
import macromedia.jdbc.sqlserver.externals.org.slf4j.helpers.MessageFormatter;
import macromedia.jdbc.sqlserver.externals.org.slf4j.helpers.NormalizedParameters;
import macromedia.jdbc.sqlserver.externals.org.slf4j.helpers.SubstituteLogger;
import macromedia.jdbc.sqlserver.externals.org.slf4j.spi.DefaultLoggingEventBuilder;
import macromedia.jdbc.sqlserver.externals.org.slf4j.spi.LocationAwareLogger;

public final class JDK14LoggerAdapter
extends LegacyAbstractLogger
implements LocationAwareLogger {
    private static final long serialVersionUID = -8053026990503422791L;
    final transient Logger logger;
    static String SELF = JDK14LoggerAdapter.class.getName();
    static String SUPER = LegacyAbstractLogger.class.getName();
    static String SUPER_OF_SUPER = AbstractLogger.class.getName();
    static String SUBSTITUE = SubstituteLogger.class.getName();
    static String FLUENT = DefaultLoggingEventBuilder.class.getName();
    static String[] BARRIER_CLASSES = new String[]{SUPER_OF_SUPER, SUPER, SELF, SUBSTITUE, FLUENT};

    JDK14LoggerAdapter(Logger logger) {
        this.logger = logger;
        this.name = logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(java.util.logging.Level.FINEST);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(java.util.logging.Level.FINE);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(java.util.logging.Level.INFO);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(java.util.logging.Level.WARNING);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(java.util.logging.Level.SEVERE);
    }

    @Override
    protected void handleNormalizedLoggingCall(Level level, Marker marker, String string, Object[] objectArray, Throwable throwable) {
        this.innerNormalizedLoggingCallHandler(this.getFullyQualifiedCallerName(), level, marker, string, objectArray, throwable);
    }

    private void innerNormalizedLoggingCallHandler(String string, Level level, Marker marker, String string2, Object[] objectArray, Throwable throwable) {
        java.util.logging.Level level2 = JDK14LoggerAdapter.slf4jLevelToJULLevel(level);
        String string3 = MessageFormatter.basicArrayFormat(string2, objectArray);
        LogRecord logRecord = new LogRecord(level2, string3);
        logRecord.setLoggerName(this.getName());
        logRecord.setThrown(throwable);
        this.fillCallerData(string, logRecord);
        this.logger.log(logRecord);
    }

    @Override
    protected String getFullyQualifiedCallerName() {
        return SELF;
    }

    @Override
    public void log(Marker marker, String string, int n2, String string2, Object[] objectArray, Throwable throwable) {
        Level level = Level.intToLevel(n2);
        java.util.logging.Level level2 = JDK14LoggerAdapter.slf4jLevelIntToJULLevel(n2);
        if (this.logger.isLoggable(level2)) {
            NormalizedParameters normalizedParameters = NormalizedParameters.normalize(string2, objectArray, throwable);
            this.innerNormalizedLoggingCallHandler(string, level, marker, normalizedParameters.getMessage(), normalizedParameters.getArguments(), normalizedParameters.getThrowable());
        }
    }

    private final void fillCallerData(String string, LogRecord logRecord) {
        int n2;
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        int n3 = -1;
        for (n2 = 0; n2 < stackTraceElementArray.length; ++n2) {
            String string2 = stackTraceElementArray[n2].getClassName();
            if (!this.barrierMatch(string, string2)) continue;
            n3 = n2;
            break;
        }
        n2 = -1;
        for (int i2 = n3 + 1; i2 < stackTraceElementArray.length; ++i2) {
            String string3 = stackTraceElementArray[i2].getClassName();
            if (this.barrierMatch(string, string3)) continue;
            n2 = i2;
            break;
        }
        if (n2 != -1) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n2];
            logRecord.setSourceClassName(stackTraceElement.getClassName());
            logRecord.setSourceMethodName(stackTraceElement.getMethodName());
        }
    }

    private boolean barrierMatch(String string, String string2) {
        if (string2.equals(string)) {
            return true;
        }
        for (String string3 : BARRIER_CLASSES) {
            if (!string3.equals(string2)) continue;
            return true;
        }
        return false;
    }

    private static java.util.logging.Level slf4jLevelIntToJULLevel(int n2) {
        Level level = Level.intToLevel(n2);
        return JDK14LoggerAdapter.slf4jLevelToJULLevel(level);
    }

    private static java.util.logging.Level slf4jLevelToJULLevel(Level level) {
        java.util.logging.Level level2;
        switch (level) {
            case TRACE: {
                level2 = java.util.logging.Level.FINEST;
                break;
            }
            case DEBUG: {
                level2 = java.util.logging.Level.FINE;
                break;
            }
            case INFO: {
                level2 = java.util.logging.Level.INFO;
                break;
            }
            case WARN: {
                level2 = java.util.logging.Level.WARNING;
                break;
            }
            case ERROR: {
                level2 = java.util.logging.Level.SEVERE;
                break;
            }
            default: {
                throw new IllegalStateException("Level " + (Object)((Object)level) + " is not recognized.");
            }
        }
        return level2;
    }

    public void log(LoggingEvent loggingEvent) {
        java.util.logging.Level level = JDK14LoggerAdapter.slf4jLevelToJULLevel(loggingEvent.getLevel());
        if (this.logger.isLoggable(level)) {
            LogRecord logRecord = this.eventToRecord(loggingEvent, level);
            this.logger.log(logRecord);
        }
    }

    private LogRecord eventToRecord(LoggingEvent loggingEvent, java.util.logging.Level level) {
        Object[] objectArray;
        String string = loggingEvent.getMessage();
        FormattingTuple formattingTuple = MessageFormatter.arrayFormat(string, objectArray = loggingEvent.getArgumentArray());
        if (formattingTuple.getThrowable() != null && loggingEvent.getThrowable() != null) {
            throw new IllegalArgumentException("both last element in argument array and last argument are of type Throwable");
        }
        Throwable throwable = loggingEvent.getThrowable();
        if (formattingTuple.getThrowable() != null) {
            throwable = formattingTuple.getThrowable();
            throw new IllegalStateException("fix above code");
        }
        LogRecord logRecord = new LogRecord(level, formattingTuple.getMessage());
        logRecord.setLoggerName(loggingEvent.getLoggerName());
        logRecord.setMillis(loggingEvent.getTimeStamp());
        logRecord.setSourceClassName("NA/SubstituteLogger");
        logRecord.setSourceMethodName("NA/SubstituteLogger");
        logRecord.setThrown(throwable);
        return logRecord;
    }
}

