/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.utils;

import java.security.PublicKey;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEObjectType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSSigner;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.factories.DefaultJWSSignerFactory;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.factories.DefaultJWSVerifierFactory;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.AsymmetricJWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.Curve;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.ECKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKMatcher;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSelector;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.KeyType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.OctetKeyPair;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.BadJOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.SignedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;

public class JWTUtils {
    public static JWSAlgorithm resolveSigningAlgorithm(JWK jWK) throws JOSEException {
        KeyType keyType = jWK.getKeyType();
        if (KeyType.RSA.equals(keyType)) {
            if (jWK.getAlgorithm() != null) {
                return new JWSAlgorithm(jWK.getAlgorithm().getName());
            }
            return JWSAlgorithm.RS256;
        }
        if (KeyType.EC.equals(keyType)) {
            ECKey eCKey = jWK.toECKey();
            if (jWK.getAlgorithm() != null) {
                return new JWSAlgorithm(eCKey.getAlgorithm().getName());
            }
            if (Curve.P_256.equals(eCKey.getCurve())) {
                return JWSAlgorithm.ES256;
            }
            if (Curve.P_384.equals(eCKey.getCurve())) {
                return JWSAlgorithm.ES384;
            }
            if (Curve.P_521.equals(eCKey.getCurve())) {
                return JWSAlgorithm.ES512;
            }
            if (Curve.SECP256K1.equals(eCKey.getCurve())) {
                return JWSAlgorithm.ES256K;
            }
            throw new JOSEException("Unsupported ECDSA curve: " + eCKey.getCurve());
        }
        if (KeyType.OKP.equals(keyType)) {
            OctetKeyPair octetKeyPair = jWK.toOctetKeyPair();
            if (Curve.Ed25519.equals(octetKeyPair.getCurve())) {
                return JWSAlgorithm.EdDSA;
            }
            throw new JOSEException("Unsupported EdDSA curve: " + octetKeyPair.getCurve());
        }
        throw new JOSEException("Unsupported JWK type: " + keyType);
    }

    public static SignedJWT sign(JWK jWK, JWSAlgorithm jWSAlgorithm, JOSEObjectType jOSEObjectType, JWTClaimsSet jWTClaimsSet) throws JOSEException {
        JWSSigner jWSSigner = new DefaultJWSSignerFactory().createJWSSigner(jWK, jWSAlgorithm);
        JWSHeader jWSHeader = new JWSHeader.Builder(jWSAlgorithm).type(jOSEObjectType).keyID(jWK.getKeyID()).build();
        SignedJWT signedJWT = new SignedJWT(jWSHeader, jWTClaimsSet);
        signedJWT.sign(jWSSigner);
        return signedJWT;
    }

    public static Base64URL verifySignature(SignedJWT signedJWT, JOSEObjectType jOSEObjectType, JWTClaimsSetVerifier<?> jWTClaimsSetVerifier, JWKSet jWKSet) throws BadJOSEException, JOSEException {
        if (!jOSEObjectType.equals(signedJWT.getHeader().getType())) {
            throw new BadJOSEException("JWT rejected: Invalid or missing JWT typ (type) header");
        }
        try {
            jWTClaimsSetVerifier.verify(signedJWT.getJWTClaimsSet(), null);
        }
        catch (java.text.ParseException parseException) {
            throw new BadJOSEException(parseException.getMessage(), parseException);
        }
        List<JWK> list = new JWKSelector(JWKMatcher.forJWSHeader(signedJWT.getHeader())).select(jWKSet);
        if (list.isEmpty()) {
            throw new BadJOSEException("JWT rejected: Another JOSE algorithm expected, or no matching key(s) found");
        }
        DefaultJWSVerifierFactory defaultJWSVerifierFactory = new DefaultJWSVerifierFactory();
        for (JWK jWK : list) {
            if (!(jWK instanceof AsymmetricJWK)) continue;
            PublicKey publicKey = ((AsymmetricJWK)((Object)jWK)).toPublicKey();
            JWSVerifier jWSVerifier = defaultJWSVerifierFactory.createJWSVerifier(signedJWT.getHeader(), publicKey);
            if (!signedJWT.verify(jWSVerifier)) continue;
            return jWK.computeThumbprint();
        }
        throw new BadJOSEException("JWT rejected: Invalid signature");
    }

    public static JWTClaimsSet parseSignedJWTClaimsSet(SignedJWT signedJWT) throws ParseException {
        if (JWSObject.State.UNSIGNED.equals((Object)signedJWT.getState())) {
            throw new ParseException("The JWT is not signed");
        }
        try {
            return signedJWT.getJWTClaimsSet();
        }
        catch (java.text.ParseException parseException) {
            throw new ParseException(parseException.getMessage(), parseException);
        }
    }

    private JWTUtils() {
    }
}

