/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities;

import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEObjectType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.BadJOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.SignedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.EntityID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.EntityStatementClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.EntityStatementClaimsVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.utils.JWTUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public final class EntityStatement {
    public static final JOSEObjectType JOSE_OBJECT_TYPE = new JOSEObjectType("entity-statement+jwt");
    public static final ContentType CONTENT_TYPE = new ContentType("application", JOSE_OBJECT_TYPE.getType(), new ContentType.Parameter[0]);
    private final SignedJWT statementJWT;
    private final EntityStatementClaimsSet claimsSet;

    private EntityStatement(SignedJWT signedJWT, EntityStatementClaimsSet entityStatementClaimsSet) {
        if (signedJWT == null) {
            throw new IllegalArgumentException("The entity statement must not be null");
        }
        if (JWSObject.State.UNSIGNED.equals((Object)signedJWT.getState())) {
            throw new IllegalArgumentException("The statement is not signed");
        }
        this.statementJWT = signedJWT;
        if (entityStatementClaimsSet == null) {
            throw new IllegalArgumentException("The entity statement claims set must not be null");
        }
        this.claimsSet = entityStatementClaimsSet;
    }

    public EntityID getEntityID() {
        return this.getClaimsSet().getSubjectEntityID();
    }

    public SignedJWT getSignedStatement() {
        return this.statementJWT;
    }

    public EntityStatementClaimsSet getClaimsSet() {
        return this.claimsSet;
    }

    public Base64URL verifySignatureOfSelfStatement() throws BadJOSEException, JOSEException {
        if (!this.getClaimsSet().isSelfStatement()) {
            throw new BadJOSEException("Entity statement not self-issued");
        }
        return this.verifySignature(this.getClaimsSet().getJWKSet());
    }

    public Base64URL verifySignature(JWKSet jWKSet) throws BadJOSEException, JOSEException {
        return JWTUtils.verifySignature(this.statementJWT, JOSE_OBJECT_TYPE, new EntityStatementClaimsVerifier(null), jWKSet);
    }

    public static EntityStatement sign(EntityStatementClaimsSet entityStatementClaimsSet, JWK jWK) throws JOSEException {
        return EntityStatement.sign(entityStatementClaimsSet, jWK, JWTUtils.resolveSigningAlgorithm(jWK));
    }

    public static EntityStatement sign(EntityStatementClaimsSet entityStatementClaimsSet, JWK jWK, JWSAlgorithm jWSAlgorithm) throws JOSEException {
        if (entityStatementClaimsSet.isSelfStatement() && !entityStatementClaimsSet.getJWKSet().containsJWK(jWK)) {
            throw new JOSEException("Signing JWK not found in JWK set of self-statement");
        }
        try {
            return new EntityStatement(JWTUtils.sign(jWK, jWSAlgorithm, JOSE_OBJECT_TYPE, entityStatementClaimsSet.toJWTClaimsSet()), entityStatementClaimsSet);
        }
        catch (ParseException parseException) {
            throw new JOSEException(parseException.getMessage(), parseException);
        }
    }

    public static EntityStatement parse(SignedJWT signedJWT) throws ParseException {
        return new EntityStatement(signedJWT, new EntityStatementClaimsSet(JWTUtils.parseSignedJWTClaimsSet(signedJWT)));
    }

    public static EntityStatement parse(String string) throws ParseException {
        try {
            return EntityStatement.parse(SignedJWT.parse(string));
        }
        catch (java.text.ParseException parseException) {
            throw new ParseException("Invalid entity statement: " + parseException.getMessage(), parseException);
        }
    }
}

