/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.config;

import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.SignedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.config.FederationEntityConfigurationResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;

public class FederationEntityConfigurationSuccessResponse
extends FederationEntityConfigurationResponse {
    private static final ContentType CONTENT_TYPE = EntityStatement.CONTENT_TYPE;
    private final EntityStatement entityStatement;

    public FederationEntityConfigurationSuccessResponse(EntityStatement entityStatement) {
        if (entityStatement == null) {
            throw new IllegalArgumentException("The federation entity statement must not be null");
        }
        this.entityStatement = entityStatement;
    }

    public EntityStatement getEntityStatement() {
        return this.entityStatement;
    }

    @Override
    public boolean indicatesSuccess() {
        return true;
    }

    @Override
    public HTTPResponse toHTTPResponse() {
        HTTPResponse hTTPResponse = new HTTPResponse(200);
        hTTPResponse.setEntityContentType(CONTENT_TYPE);
        hTTPResponse.setContent(this.entityStatement.getSignedStatement().serialize());
        return hTTPResponse;
    }

    public static FederationEntityConfigurationSuccessResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        SignedJWT signedJWT;
        hTTPResponse.ensureStatusCode(200);
        hTTPResponse.ensureEntityContentType(CONTENT_TYPE);
        String string = hTTPResponse.getContent();
        if (StringUtils.isBlank(string)) {
            throw new ParseException("Empty HTTP entity body");
        }
        try {
            signedJWT = SignedJWT.parse(hTTPResponse.getContent());
        }
        catch (java.text.ParseException parseException) {
            throw new ParseException(parseException.getMessage(), parseException);
        }
        return new FederationEntityConfigurationSuccessResponse(EntityStatement.parse(signedJWT));
    }
}

