/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences;

import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.Policy;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.Procedure;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.Status;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.CommonMethodAttributes;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.ValidationMethodType;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public final class ValidationMethod
extends CommonMethodAttributes {
    private final ValidationMethodType type;

    public ValidationMethod(ValidationMethodType validationMethodType, Policy policy, Procedure procedure, Status status) {
        super(policy, procedure, status);
        Objects.requireNonNull(validationMethodType);
        this.type = validationMethodType;
    }

    public ValidationMethodType getType() {
        return this.type;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ValidationMethod)) {
            return false;
        }
        ValidationMethod validationMethod = (ValidationMethod)object;
        return this.getType().equals(validationMethod.getType()) && Objects.equals(this.getPolicy(), validationMethod.getPolicy()) && Objects.equals(this.getProcedure(), validationMethod.getProcedure()) && Objects.equals(this.getStatus(), validationMethod.getStatus());
    }

    public int hashCode() {
        return Objects.hash(this.getType(), this.getPolicy(), this.getProcedure(), this.getStatus());
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("type", this.getType().getValue());
        return jSONObject;
    }

    public static ValidationMethod parse(JSONObject jSONObject) throws ParseException {
        try {
            ValidationMethodType validationMethodType = new ValidationMethodType(JSONObjectUtils.getString(jSONObject, "type"));
            Policy policy = null;
            if (jSONObject.get("policy") != null) {
                policy = new Policy(JSONObjectUtils.getString(jSONObject, "policy"));
            }
            Procedure procedure = null;
            if (jSONObject.get("procedure") != null) {
                procedure = new Procedure(JSONObjectUtils.getString(jSONObject, "procedure"));
            }
            Status status = null;
            if (jSONObject.get("status") != null) {
                status = new Status(JSONObjectUtils.getString(jSONObject, "status"));
            }
            return new ValidationMethod(validationMethodType, policy, procedure, status);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }
}

