/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONUtils;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONArray;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public final class JSONObjectUtils {
    public static boolean containsKey(JSONObject jSONObject, String string) {
        return jSONObject != null && jSONObject.containsKey(string);
    }

    public static JSONObject parse(String string) throws ParseException {
        Object object = JSONUtils.parseJSON(string);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        throw new ParseException("The JSON entity is not an object");
    }

    public static LinkedHashMap<String, Object> parseKeepingOrder(String string) throws ParseException {
        Object object = JSONUtils.parseJSONKeepingOrder(string);
        if (object instanceof LinkedHashMap) {
            return (LinkedHashMap)object;
        }
        throw new ParseException("The JSON entity is not an object");
    }

    @Deprecated
    public static JSONObject parseJSONObject(String string) throws ParseException {
        return JSONObjectUtils.parse(string);
    }

    public static <T> T getGeneric(JSONObject jSONObject, String string, Class<T> clazz) throws ParseException {
        if (!jSONObject.containsKey(string)) {
            throw new ParseException("Missing JSON object member with key " + string + "");
        }
        Object v2 = jSONObject.get(string);
        if (v2 == null) {
            throw new ParseException("JSON object member with key " + string + " has null value");
        }
        try {
            return JSONUtils.to(v2, clazz);
        }
        catch (ParseException parseException) {
            throw new ParseException("Unexpected type of JSON object member with key " + string + "", parseException);
        }
    }

    public static boolean getBoolean(JSONObject jSONObject, String string) throws ParseException {
        return JSONObjectUtils.getGeneric(jSONObject, string, Boolean.class);
    }

    public static boolean getBoolean(JSONObject jSONObject, String string, boolean bl2) throws ParseException {
        if (jSONObject.get(string) != null) {
            return JSONObjectUtils.getBoolean(jSONObject, string);
        }
        return bl2;
    }

    public static int getInt(JSONObject jSONObject, String string) throws ParseException {
        return JSONObjectUtils.getGeneric(jSONObject, string, Number.class).intValue();
    }

    public static int getInt(JSONObject jSONObject, String string, int n2) throws ParseException {
        if (jSONObject.get(string) != null) {
            return JSONObjectUtils.getInt(jSONObject, string);
        }
        return n2;
    }

    public static long getLong(JSONObject jSONObject, String string) throws ParseException {
        return JSONObjectUtils.getGeneric(jSONObject, string, Number.class).longValue();
    }

    public static long getLong(JSONObject jSONObject, String string, long l2) throws ParseException {
        if (jSONObject.get(string) != null) {
            return JSONObjectUtils.getLong(jSONObject, string);
        }
        return l2;
    }

    public static float getFloat(JSONObject jSONObject, String string) throws ParseException {
        return JSONObjectUtils.getGeneric(jSONObject, string, Number.class).floatValue();
    }

    public static float getFloat(JSONObject jSONObject, String string, float f2) throws ParseException {
        if (jSONObject.get(string) != null) {
            return JSONObjectUtils.getFloat(jSONObject, string);
        }
        return f2;
    }

    public static double getDouble(JSONObject jSONObject, String string) throws ParseException {
        return JSONObjectUtils.getGeneric(jSONObject, string, Number.class).doubleValue();
    }

    public static double getDouble(JSONObject jSONObject, String string, double d2) throws ParseException {
        if (jSONObject.get(string) != null) {
            return JSONObjectUtils.getDouble(jSONObject, string);
        }
        return d2;
    }

    public static Number getNumber(JSONObject jSONObject, String string) throws ParseException {
        return JSONObjectUtils.getGeneric(jSONObject, string, Number.class);
    }

    public static Number getNumber(JSONObject jSONObject, String string, Number number) throws ParseException {
        if (jSONObject.get(string) != null) {
            return JSONObjectUtils.getNumber(jSONObject, string);
        }
        return number;
    }

    public static String getString(JSONObject jSONObject, String string) throws ParseException {
        return JSONObjectUtils.getGeneric(jSONObject, string, String.class);
    }

    public static String getString(JSONObject jSONObject, String string, String string2) throws ParseException {
        if (jSONObject.get(string) != null) {
            return JSONObjectUtils.getString(jSONObject, string);
        }
        return string2;
    }

    public static <T extends Enum<T>> T getEnum(JSONObject jSONObject, String string, Class<T> clazz) throws ParseException {
        String string2 = JSONObjectUtils.getString(jSONObject, string);
        for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
            if (!enum_.toString().equalsIgnoreCase(string2)) continue;
            return (T)enum_;
        }
        throw new ParseException("Unexpected value of JSON object member with key " + string + "");
    }

    public static <T extends Enum<T>> T getEnum(JSONObject jSONObject, String string, Class<T> clazz, T t2) throws ParseException {
        if (jSONObject.get(string) != null) {
            return JSONObjectUtils.getEnum(jSONObject, string, clazz);
        }
        return t2;
    }

    public static URI getURI(JSONObject jSONObject, String string) throws ParseException {
        try {
            return new URI(JSONObjectUtils.getGeneric(jSONObject, string, String.class));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ParseException(uRISyntaxException.getMessage(), uRISyntaxException);
        }
    }

    public static URI getURI(JSONObject jSONObject, String string, URI uRI) throws ParseException {
        if (jSONObject.get(string) != null) {
            return JSONObjectUtils.getURI(jSONObject, string);
        }
        return uRI;
    }

    public static URL getURL(JSONObject jSONObject, String string) throws ParseException {
        try {
            return new URL(JSONObjectUtils.getGeneric(jSONObject, string, String.class));
        }
        catch (MalformedURLException malformedURLException) {
            throw new ParseException(malformedURLException.getMessage(), malformedURLException);
        }
    }

    public static URL getURL(JSONObject jSONObject, String string, URL uRL) throws ParseException {
        if (jSONObject.get(string) != null) {
            return JSONObjectUtils.getURL(jSONObject, string);
        }
        return uRL;
    }

    public static JSONArray getJSONArray(JSONObject jSONObject, String string) throws ParseException {
        List list = JSONObjectUtils.getGeneric(jSONObject, string, List.class);
        JSONArray jSONArray = new JSONArray();
        jSONArray.addAll(list);
        return jSONArray;
    }

    public static JSONArray getJSONArray(JSONObject jSONObject, String string, JSONArray jSONArray) throws ParseException {
        if (jSONObject.get(string) != null) {
            return JSONObjectUtils.getJSONArray(jSONObject, string);
        }
        return jSONArray;
    }

    public static List<Object> getList(JSONObject jSONObject, String string) throws ParseException {
        return JSONObjectUtils.getGeneric(jSONObject, string, List.class);
    }

    public static List<Object> getList(JSONObject jSONObject, String string, List<Object> list) throws ParseException {
        if (jSONObject.get(string) != null) {
            return JSONObjectUtils.getList(jSONObject, string);
        }
        return list;
    }

    public static String[] getStringArray(JSONObject jSONObject, String string) throws ParseException {
        List<Object> list = JSONObjectUtils.getList(jSONObject, string);
        try {
            return list.toArray(new String[0]);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new ParseException("JSON object member with key " + string + " is not an array of strings");
        }
    }

    public static String[] getStringArray(JSONObject jSONObject, String string, String[] stringArray) throws ParseException {
        if (jSONObject.get(string) != null) {
            return JSONObjectUtils.getStringArray(jSONObject, string);
        }
        return stringArray;
    }

    public static List<String> getStringList(JSONObject jSONObject, String string) throws ParseException {
        return Arrays.asList(JSONObjectUtils.getStringArray(jSONObject, string));
    }

    public static List<String> getStringList(JSONObject jSONObject, String string, List<String> list) throws ParseException {
        if (jSONObject.get(string) != null) {
            return JSONObjectUtils.getStringList(jSONObject, string);
        }
        return list;
    }

    public static Set<String> getStringSet(JSONObject jSONObject, String string) throws ParseException {
        List<Object> list = JSONObjectUtils.getList(jSONObject, string);
        HashSet<String> hashSet = new HashSet<String>();
        for (Object object : list) {
            try {
                hashSet.add((String)object);
            }
            catch (Exception exception) {
                throw new ParseException("JSON object member with key " + string + " is not an array of strings");
            }
        }
        return hashSet;
    }

    public static Set<String> getStringSet(JSONObject jSONObject, String string, Set<String> set) throws ParseException {
        if (jSONObject.get(string) != null) {
            return JSONObjectUtils.getStringSet(jSONObject, string);
        }
        return set;
    }

    public static JSONObject getJSONObject(JSONObject jSONObject, String string) throws ParseException {
        Map map = JSONObjectUtils.getGeneric(jSONObject, string, Map.class);
        return new JSONObject(map);
    }

    public static JSONObject getJSONObject(JSONObject jSONObject, String string, JSONObject jSONObject2) throws ParseException {
        if (jSONObject.get(string) != null) {
            return JSONObjectUtils.getJSONObject(jSONObject, string);
        }
        return jSONObject2;
    }

    public static JSONObject toJSONObject(JWTClaimsSet jWTClaimsSet) {
        if (jWTClaimsSet == null) {
            return null;
        }
        if (jWTClaimsSet.getClaims().isEmpty()) {
            return new JSONObject();
        }
        String string = jWTClaimsSet.toString();
        try {
            return JSONObjectUtils.parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static JSONObject toJSONObject(JWKSet jWKSet) {
        if (jWKSet == null) {
            return null;
        }
        String string = jWKSet.toString(false);
        try {
            return JSONObjectUtils.parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    private JSONObjectUtils() {
    }
}

