/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONUtils;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONArray;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public final class JSONArrayUtils {
    public static JSONArray parse(String string) throws ParseException {
        Object object = JSONUtils.parseJSON(string);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw new ParseException("The JSON entity is not an array");
    }

    public static List<String> toStringList(JSONArray jSONArray) {
        if (CollectionUtils.isEmpty(jSONArray)) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(jSONArray.size());
        for (Object e2 : jSONArray) {
            if (e2 == null) continue;
            arrayList.add(e2.toString());
        }
        return arrayList;
    }

    public static List<URI> toURIList(JSONArray jSONArray) throws ParseException {
        if (CollectionUtils.isEmpty(jSONArray)) {
            return Collections.emptyList();
        }
        ArrayList<URI> arrayList = new ArrayList<URI>(jSONArray.size());
        for (Object e2 : jSONArray) {
            if (e2 == null) continue;
            try {
                arrayList.add(new URI(e2.toString()));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new ParseException("Illegal URI: " + uRISyntaxException.getMessage(), uRISyntaxException);
            }
        }
        return arrayList;
    }

    public static List<JSONObject> toJSONObjectList(JSONArray jSONArray) throws ParseException {
        if (CollectionUtils.isEmpty(jSONArray)) {
            return Collections.emptyList();
        }
        ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>(jSONArray.size());
        int n2 = -1;
        for (Object e2 : jSONArray) {
            ++n2;
            if (e2 == null) continue;
            if (e2 instanceof JSONObject) {
                arrayList.add((JSONObject)e2);
                continue;
            }
            if (e2 instanceof Map) {
                JSONObject jSONObject = new JSONObject((Map)e2);
                arrayList.add(jSONObject);
                continue;
            }
            throw new ParseException("Invalid JSON object at position " + n2);
        }
        return arrayList;
    }

    private JSONArrayUtils() {
    }
}

