/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.device;

import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.SuccessResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.device.DeviceAuthorizationResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.device.DeviceCode;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.device.UserCode;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public class DeviceAuthorizationSuccessResponse
extends DeviceAuthorizationResponse
implements SuccessResponse {
    private static final Set<String> REGISTERED_PARAMETER_NAMES;
    private final DeviceCode deviceCode;
    private final UserCode userCode;
    private final URI verificationURI;
    private final URI verificationURIComplete;
    private final long lifetime;
    private final long interval;
    private final Map<String, Object> customParams;

    public DeviceAuthorizationSuccessResponse(DeviceCode deviceCode, UserCode userCode, URI uRI, long l2) {
        this(deviceCode, userCode, uRI, null, l2, 5L, null);
    }

    public DeviceAuthorizationSuccessResponse(DeviceCode deviceCode, UserCode userCode, URI uRI, URI uRI2, long l2, long l3, Map<String, Object> map) {
        if (deviceCode == null) {
            throw new IllegalArgumentException("The device_code must not be null");
        }
        this.deviceCode = deviceCode;
        if (userCode == null) {
            throw new IllegalArgumentException("The user_code must not be null");
        }
        this.userCode = userCode;
        if (uRI == null) {
            throw new IllegalArgumentException("The verification_uri must not be null");
        }
        this.verificationURI = uRI;
        this.verificationURIComplete = uRI2;
        if (l2 <= 0L) {
            throw new IllegalArgumentException("The lifetime must be greater than 0");
        }
        this.lifetime = l2;
        this.interval = l3;
        this.customParams = map;
    }

    public static Set<String> getRegisteredParameterNames() {
        return REGISTERED_PARAMETER_NAMES;
    }

    @Override
    public boolean indicatesSuccess() {
        return true;
    }

    public DeviceCode getDeviceCode() {
        return this.deviceCode;
    }

    public UserCode getUserCode() {
        return this.userCode;
    }

    public URI getVerificationURI() {
        return this.verificationURI;
    }

    @Deprecated
    public URI getVerificationUri() {
        return this.getVerificationURI();
    }

    public URI getVerificationURIComplete() {
        return this.verificationURIComplete;
    }

    @Deprecated
    public URI getVerificationUriComplete() {
        return this.getVerificationURIComplete();
    }

    public long getLifetime() {
        return this.lifetime;
    }

    public long getInterval() {
        return this.interval;
    }

    public Map<String, Object> getCustomParameters() {
        if (this.customParams == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.customParams);
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("device_code", this.getDeviceCode());
        jSONObject.put("user_code", this.getUserCode());
        jSONObject.put("verification_uri", this.getVerificationURI().toString());
        if (this.getVerificationURIComplete() != null) {
            jSONObject.put("verification_uri_complete", this.getVerificationURIComplete().toString());
        }
        jSONObject.put("expires_in", this.getLifetime());
        if (this.getInterval() > 0L) {
            jSONObject.put("interval", this.getInterval());
        }
        if (this.customParams != null) {
            jSONObject.putAll(this.customParams);
        }
        return jSONObject;
    }

    @Override
    public HTTPResponse toHTTPResponse() {
        HTTPResponse hTTPResponse = new HTTPResponse(200);
        hTTPResponse.setEntityContentType(ContentType.APPLICATION_JSON);
        hTTPResponse.setCacheControl("no-store");
        hTTPResponse.setPragma("no-cache");
        hTTPResponse.setContent(this.toJSONObject().toString());
        return hTTPResponse;
    }

    public static DeviceAuthorizationSuccessResponse parse(JSONObject jSONObject) throws ParseException {
        Object object;
        long l2;
        DeviceCode deviceCode = new DeviceCode(JSONObjectUtils.getString(jSONObject, "device_code"));
        UserCode userCode = new UserCode(JSONObjectUtils.getString(jSONObject, "user_code"));
        URI uRI = JSONObjectUtils.getURI(jSONObject, "verification_uri");
        URI uRI2 = JSONObjectUtils.getURI(jSONObject, "verification_uri_complete", null);
        if (jSONObject.get("expires_in") instanceof Number) {
            l2 = JSONObjectUtils.getLong(jSONObject, "expires_in");
        } else {
            String string = JSONObjectUtils.getString(jSONObject, "expires_in");
            try {
                l2 = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Invalid expires_in parameter, must be integer");
            }
        }
        long l3 = 5L;
        if (jSONObject.containsKey("interval")) {
            if (jSONObject.get("interval") instanceof Number) {
                l3 = JSONObjectUtils.getLong(jSONObject, "interval");
            } else {
                object = JSONObjectUtils.getString(jSONObject, "interval");
                try {
                    l3 = Long.parseLong((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParseException("Invalid interval parameter, must be integer");
                }
            }
        }
        object = new HashSet(jSONObject.keySet());
        object.removeAll(DeviceAuthorizationSuccessResponse.getRegisteredParameterNames());
        LinkedHashMap<String, Object> linkedHashMap = null;
        if (!object.isEmpty()) {
            linkedHashMap = new LinkedHashMap<String, Object>();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                linkedHashMap.put(string, jSONObject.get(string));
            }
        }
        return new DeviceAuthorizationSuccessResponse(deviceCode, userCode, uRI, uRI2, l2, l3, linkedHashMap);
    }

    public static DeviceAuthorizationSuccessResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        hTTPResponse.ensureStatusCode(200);
        JSONObject jSONObject = hTTPResponse.getContentAsJSONObject();
        return DeviceAuthorizationSuccessResponse.parse(jSONObject);
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("device_code");
        hashSet.add("user_code");
        hashSet.add("verification_uri");
        hashSet.add("verification_uri_complete");
        hashSet.add("expires_in");
        hashSet.add("interval");
        REGISTERED_PARAMETER_NAMES = Collections.unmodifiableSet(hashSet);
    }
}

