/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.device;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.AbstractOptionallyIdentifiedRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.OAuth2Error;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.Scope;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.SerializeException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.ClientID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URLUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class DeviceAuthorizationRequest
extends AbstractOptionallyIdentifiedRequest {
    private static final Set<String> REGISTERED_PARAMETER_NAMES;
    private final Scope scope;
    private final Map<String, List<String>> customParams;

    public DeviceAuthorizationRequest(URI uRI, ClientID clientID) {
        this(uRI, clientID, null, null);
    }

    public DeviceAuthorizationRequest(URI uRI, ClientID clientID, Scope scope) {
        this(uRI, clientID, scope, null);
    }

    public DeviceAuthorizationRequest(URI uRI, ClientID clientID, Scope scope, Map<String, List<String>> map) {
        super(uRI, clientID);
        if (clientID == null) {
            throw new IllegalArgumentException("The client ID must not be null");
        }
        this.scope = scope;
        this.customParams = MapUtils.isNotEmpty(map) ? Collections.unmodifiableMap(map) : Collections.emptyMap();
    }

    public DeviceAuthorizationRequest(URI uRI, ClientAuthentication clientAuthentication, Scope scope, Map<String, List<String>> map) {
        super(uRI, clientAuthentication);
        if (clientAuthentication == null) {
            throw new IllegalArgumentException("The client authentication must not be null");
        }
        this.scope = scope;
        this.customParams = MapUtils.isNotEmpty(map) ? Collections.unmodifiableMap(map) : Collections.emptyMap();
    }

    public static Set<String> getRegisteredParameterNames() {
        return REGISTERED_PARAMETER_NAMES;
    }

    public Scope getScope() {
        return this.scope;
    }

    public Map<String, List<String>> getCustomParameters() {
        return this.customParams;
    }

    public List<String> getCustomParameter(String string) {
        return this.customParams.get(string);
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        LinkedHashMap<String, List<String>> linkedHashMap;
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        HTTPRequest hTTPRequest = new HTTPRequest(HTTPRequest.Method.POST, this.getEndpointURI());
        hTTPRequest.setEntityContentType(ContentType.APPLICATION_URLENCODED);
        if (this.getClientAuthentication() != null) {
            this.getClientAuthentication().applyTo(hTTPRequest);
        }
        try {
            linkedHashMap = new LinkedHashMap<String, List<String>>(hTTPRequest.getBodyAsFormParameters());
        }
        catch (ParseException parseException) {
            throw new SerializeException(parseException.getMessage(), parseException);
        }
        if (this.scope != null && !this.scope.isEmpty()) {
            linkedHashMap.put("scope", Collections.singletonList(this.scope.toString()));
        }
        if (this.getClientID() != null) {
            linkedHashMap.put("client_id", Collections.singletonList(this.getClientID().getValue()));
        }
        if (!this.getCustomParameters().isEmpty()) {
            linkedHashMap.putAll(this.getCustomParameters());
        }
        hTTPRequest.setBody(URLUtils.serializeParameters(linkedHashMap));
        return hTTPRequest;
    }

    public static DeviceAuthorizationRequest parse(HTTPRequest hTTPRequest) throws ParseException {
        ClientID clientID;
        String string;
        ClientAuthentication clientAuthentication;
        URI uRI = hTTPRequest.getURI();
        hTTPRequest.ensureMethod(HTTPRequest.Method.POST);
        hTTPRequest.ensureEntityContentType(ContentType.APPLICATION_URLENCODED);
        try {
            clientAuthentication = ClientAuthentication.parse(hTTPRequest);
        }
        catch (ParseException parseException) {
            throw new ParseException(parseException.getMessage(), OAuth2Error.INVALID_REQUEST.appendDescription(": " + parseException.getMessage()));
        }
        Map map = hTTPRequest.getBodyAsFormParameters();
        if (clientAuthentication == null) {
            string = (String)MultivaluedMapUtils.getFirstValue(map, "client_id");
            if (StringUtils.isBlank(string)) {
                String string2 = "Missing client_id parameter";
                throw new ParseException(string2, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string2));
            }
            clientID = new ClientID(string);
        } else {
            clientID = null;
        }
        string = (String)MultivaluedMapUtils.getFirstValue(map, "scope");
        Scope scope = null;
        if (StringUtils.isNotBlank(string)) {
            scope = Scope.parse(string);
        }
        HashMap hashMap = null;
        for (Map.Entry entry : map.entrySet()) {
            if (REGISTERED_PARAMETER_NAMES.contains(entry.getKey())) continue;
            if (hashMap == null) {
                hashMap = new HashMap();
            }
            hashMap.put(entry.getKey(), entry.getValue());
        }
        if (clientAuthentication == null) {
            return new DeviceAuthorizationRequest(uRI, clientID, scope, hashMap);
        }
        return new DeviceAuthorizationRequest(uRI, clientAuthentication, scope, hashMap);
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("client_id");
        hashSet.add("scope");
        REGISTERED_PARAMETER_NAMES = Collections.unmodifiableSet(hashSet);
    }

    public static class Builder {
        private URI uri;
        private final ClientAuthentication clientAuth;
        private final ClientID clientID;
        private Scope scope;
        private final Map<String, List<String>> customParams = new HashMap<String, List<String>>();

        public Builder(ClientID clientID) {
            if (clientID == null) {
                throw new IllegalArgumentException("The client ID must not be null");
            }
            this.clientID = clientID;
            this.clientAuth = null;
        }

        public Builder(ClientAuthentication clientAuthentication) {
            if (clientAuthentication == null) {
                throw new IllegalArgumentException("The client authentication must not be null");
            }
            this.clientID = null;
            this.clientAuth = clientAuthentication;
        }

        public Builder(DeviceAuthorizationRequest deviceAuthorizationRequest) {
            this.uri = deviceAuthorizationRequest.getEndpointURI();
            this.clientAuth = deviceAuthorizationRequest.getClientAuthentication();
            this.scope = deviceAuthorizationRequest.scope;
            this.clientID = deviceAuthorizationRequest.getClientID();
            this.customParams.putAll(deviceAuthorizationRequest.getCustomParameters());
        }

        public Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public Builder customParameter(String string, String ... stringArray) {
            if (stringArray == null || stringArray.length == 0) {
                this.customParams.remove(string);
            } else {
                this.customParams.put(string, Arrays.asList(stringArray));
            }
            return this;
        }

        public Builder endpointURI(URI uRI) {
            this.uri = uRI;
            return this;
        }

        public DeviceAuthorizationRequest build() {
            try {
                if (this.clientAuth == null) {
                    return new DeviceAuthorizationRequest(this.uri, this.clientID, this.scope, this.customParams);
                }
                return new DeviceAuthorizationRequest(this.uri, this.clientAuth, this.scope, this.customParams);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalStateException(illegalArgumentException.getMessage(), illegalArgumentException);
            }
        }
    }
}

