/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ciba;

import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ErrorObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.OAuth2Error;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ciba.AuthRequestID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ciba.CIBAError;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ciba.CIBAPushCallback;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public class CIBAErrorDelivery
extends CIBAPushCallback {
    private static final Set<ErrorObject> STANDARD_ERRORS;
    private final ErrorObject errorObject;

    public static Set<ErrorObject> getStandardErrors() {
        return STANDARD_ERRORS;
    }

    public CIBAErrorDelivery(URI uRI, BearerAccessToken bearerAccessToken, AuthRequestID authRequestID, ErrorObject errorObject) {
        super(uRI, bearerAccessToken, authRequestID);
        if (uRI == null) {
            throw new IllegalArgumentException("The error object must not be null");
        }
        this.errorObject = errorObject;
    }

    @Override
    public boolean indicatesSuccess() {
        return false;
    }

    public ErrorObject getErrorObject() {
        return this.errorObject;
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        HTTPRequest hTTPRequest = new HTTPRequest(HTTPRequest.Method.POST, this.getEndpointURI());
        hTTPRequest.setAuthorization(this.getAccessToken().toAuthorizationHeader());
        hTTPRequest.setEntityContentType(ContentType.APPLICATION_JSON);
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("auth_req_id", this.getAuthRequestID().getValue());
        jSONObject.putAll(this.getErrorObject().toJSONObject());
        hTTPRequest.setBody(jSONObject.toJSONString());
        return hTTPRequest;
    }

    public static CIBAErrorDelivery parse(HTTPRequest hTTPRequest) throws ParseException {
        URI uRI = hTTPRequest.getURI();
        hTTPRequest.ensureMethod(HTTPRequest.Method.POST);
        hTTPRequest.ensureEntityContentType(ContentType.APPLICATION_JSON);
        BearerAccessToken bearerAccessToken = BearerAccessToken.parse(hTTPRequest);
        AuthRequestID authRequestID = new AuthRequestID(JSONObjectUtils.getString(hTTPRequest.getQueryAsJSONObject(), "auth_req_id"));
        ErrorObject errorObject = ErrorObject.parse(hTTPRequest.getQueryAsJSONObject());
        return new CIBAErrorDelivery(uRI, bearerAccessToken, authRequestID, errorObject);
    }

    static {
        HashSet<ErrorObject> hashSet = new HashSet<ErrorObject>();
        hashSet.add(OAuth2Error.ACCESS_DENIED);
        hashSet.add(CIBAError.EXPIRED_TOKEN);
        hashSet.add(CIBAError.TRANSACTION_FAILED);
        STANDARD_ERRORS = Collections.unmodifiableSet(hashSet);
    }
}

