/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth;

import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLSocketFactory;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.SerializeException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.ClientID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URLUtils;

public abstract class TLSClientAuthentication
extends ClientAuthentication {
    protected final X509Certificate certificate;
    private final SSLSocketFactory sslSocketFactory;

    protected TLSClientAuthentication(ClientAuthenticationMethod clientAuthenticationMethod, ClientID clientID, SSLSocketFactory sSLSocketFactory) {
        super(clientAuthenticationMethod, clientID);
        this.sslSocketFactory = sSLSocketFactory;
        this.certificate = null;
    }

    protected TLSClientAuthentication(ClientAuthenticationMethod clientAuthenticationMethod, ClientID clientID, X509Certificate x509Certificate) {
        super(clientAuthenticationMethod, clientID);
        this.sslSocketFactory = null;
        this.certificate = x509Certificate;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    public X509Certificate getClientX509Certificate() {
        return this.certificate;
    }

    @Override
    public Set<String> getFormParameterNames() {
        return Collections.singleton("client_id");
    }

    @Override
    public void applyTo(HTTPRequest hTTPRequest) {
        if (hTTPRequest.getMethod() != HTTPRequest.Method.POST) {
            throw new SerializeException("The HTTP request method must be POST");
        }
        ContentType contentType = hTTPRequest.getEntityContentType();
        if (contentType == null) {
            throw new SerializeException("Missing HTTP Content-Type header");
        }
        if (!contentType.matches(ContentType.APPLICATION_JSON)) {
            if (contentType.matches(ContentType.APPLICATION_URLENCODED)) {
                LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
                try {
                    linkedHashMap.putAll(hTTPRequest.getBodyAsFormParameters());
                }
                catch (ParseException parseException) {
                    throw new SerializeException(parseException.getMessage(), parseException);
                }
                linkedHashMap.put("client_id", Collections.singletonList(this.getClientID().getValue()));
                hTTPRequest.setBody(URLUtils.serializeParameters(linkedHashMap));
            } else {
                throw new SerializeException("The HTTP Content-Type header must be " + ContentType.APPLICATION_URLENCODED);
            }
        }
        hTTPRequest.setSSLSocketFactory(this.sslSocketFactory);
    }
}

