/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.assertions.saml2;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.SerializeException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.assertions.AssertionDetails;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.assertions.saml2.SAML2Utils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Audience;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Identifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Subject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.ACR;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import org.joda.time.DateTime;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.InitializationService;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.core.xml.schema.impl.XSStringBuilder;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AttributeValue;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.AuthnContext;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;

@Immutable
public class SAML2AssertionDetails
extends AssertionDetails {
    private final String subjectFormat;
    private final Date subjectAuthTime;
    private final ACR subjectACR;
    private final Date nbf;
    private final InetAddress clientAddress;
    private final Map<String, List<String>> attrStatement;

    public SAML2AssertionDetails(macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer issuer, Subject subject, Audience audience) {
        this(issuer, subject, null, null, null, audience.toSingleAudienceList(), new Date(new Date().getTime() + 300000L), null, new Date(), new Identifier(), null, null);
    }

    public SAML2AssertionDetails(macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer issuer, Subject subject, String string, Date date, ACR aCR, List<Audience> list, Date date2, Date date3, Date date4, Identifier identifier, InetAddress inetAddress, Map<String, List<String>> map) {
        super(issuer, subject, list, date4, date2, identifier);
        if (date4 == null) {
            throw new IllegalArgumentException("The issue time must not be null");
        }
        if (identifier == null) {
            throw new IllegalArgumentException("The assertion identifier must not be null");
        }
        this.subjectFormat = string;
        this.subjectAuthTime = date;
        this.subjectACR = aCR;
        this.clientAddress = inetAddress;
        this.nbf = date3;
        this.attrStatement = map;
    }

    public String getSubjectFormat() {
        return this.subjectFormat;
    }

    public Date getSubjectAuthenticationTime() {
        return this.subjectAuthTime;
    }

    public ACR getSubjectACR() {
        return this.subjectACR;
    }

    public Date getNotBeforeTime() {
        return this.nbf;
    }

    public InetAddress getClientInetAddress() {
        return this.clientAddress;
    }

    public Map<String, List<String>> getAttributeStatement() {
        return this.attrStatement;
    }

    public Assertion toSAML2Assertion() throws SerializeException {
        AuthnStatement authnStatement;
        org.opensaml.saml.saml2.core.Audience audience;
        Audience audience222;
        try {
            InitializationService.initialize();
        }
        catch (InitializationException initializationException) {
            throw new SerializeException(initializationException.getMessage(), initializationException);
        }
        Assertion assertion = SAML2Utils.buildSAMLObject(Assertion.class);
        assertion.setID(this.getID().getValue());
        assertion.setIssueInstant(new DateTime((Object)this.getIssueTime()));
        Issuer issuer = SAML2Utils.buildSAMLObject(Issuer.class);
        issuer.setValue(this.getIssuer().getValue());
        assertion.setIssuer(issuer);
        Conditions conditions = SAML2Utils.buildSAMLObject(Conditions.class);
        AudienceRestriction audienceRestriction = SAML2Utils.buildSAMLObject(AudienceRestriction.class);
        for (Audience audience222 : this.getAudience()) {
            audience = SAML2Utils.buildSAMLObject(org.opensaml.saml.saml2.core.Audience.class);
            audience.setAudienceURI(audience222.getValue());
            audienceRestriction.getAudiences().add(audience);
        }
        conditions.getAudienceRestrictions().add(audienceRestriction);
        assertion.setConditions(conditions);
        org.opensaml.saml.saml2.core.Subject subject = SAML2Utils.buildSAMLObject(org.opensaml.saml.saml2.core.Subject.class);
        audience222 = SAML2Utils.buildSAMLObject(NameID.class);
        audience222.setFormat(this.subjectFormat);
        audience222.setValue(this.getSubject().getValue());
        subject.setNameID((NameID)audience222);
        audience = SAML2Utils.buildSAMLObject(SubjectConfirmation.class);
        audience.setMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        SubjectConfirmationData subjectConfirmationData = SAML2Utils.buildSAMLObject(SubjectConfirmationData.class);
        subjectConfirmationData.setNotOnOrAfter(new DateTime((Object)this.getExpirationTime()));
        subjectConfirmationData.setNotBefore(this.getNotBeforeTime() != null ? new DateTime((Object)this.getNotBeforeTime()) : null);
        subjectConfirmationData.setRecipient(this.getAudience().get(0).getValue());
        if (this.clientAddress != null) {
            subjectConfirmationData.setAddress(this.clientAddress.getHostAddress());
        }
        audience.setSubjectConfirmationData(subjectConfirmationData);
        subject.getSubjectConfirmations().add(audience);
        assertion.setSubject(subject);
        if (this.subjectAuthTime != null || this.subjectACR != null) {
            authnStatement = SAML2Utils.buildSAMLObject(AuthnStatement.class);
            if (this.subjectAuthTime != null) {
                authnStatement.setAuthnInstant(new DateTime((Object)this.subjectAuthTime));
            }
            if (this.subjectACR != null) {
                AuthnContext authnContext = SAML2Utils.buildSAMLObject(AuthnContext.class);
                AuthnContextClassRef object = SAML2Utils.buildSAMLObject(AuthnContextClassRef.class);
                object.setAuthnContextClassRef(this.subjectACR.getValue());
                authnContext.setAuthnContextClassRef(object);
                authnStatement.setAuthnContext(authnContext);
            }
            assertion.getAuthnStatements().add(authnStatement);
        }
        if (MapUtils.isNotEmpty(this.attrStatement)) {
            authnStatement = SAML2Utils.buildSAMLObject(AttributeStatement.class);
            for (Map.Entry entry : this.attrStatement.entrySet()) {
                Attribute attribute = SAML2Utils.buildSAMLObject(Attribute.class);
                attribute.setName((String)entry.getKey());
                XSStringBuilder xSStringBuilder = (XSStringBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(XSString.TYPE_NAME);
                for (String string : (List)entry.getValue()) {
                    XSString xSString = (XSString)xSStringBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSString.TYPE_NAME);
                    xSString.setValue(string);
                    attribute.getAttributeValues().add(xSString);
                }
                authnStatement.getAttributes().add(attribute);
            }
            assertion.getAttributeStatements().add(authnStatement);
        }
        return assertion;
    }

    public static SAML2AssertionDetails parse(Assertion assertion) throws ParseException {
        Object object;
        Object object22;
        AudienceRestriction audienceRestriction;
        Object object3;
        Object object4;
        if (assertion.getIssuer() == null) {
            throw new ParseException("Missing Assertion Issuer element");
        }
        macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer issuer = new macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer(assertion.getIssuer().getValue());
        if (assertion.getSubject() == null) {
            throw new ParseException("Missing Assertion Subject element");
        }
        if (assertion.getSubject().getNameID() == null) {
            throw new ParseException("Missing Assertion Subject NameID element");
        }
        Subject subject = new Subject(assertion.getSubject().getNameID().getValue());
        String string = assertion.getSubject().getNameID().getFormat();
        Date date = null;
        ACR aCR = null;
        if (CollectionUtils.isNotEmpty(assertion.getAuthnStatements())) {
            object4 = assertion.getAuthnStatements().iterator();
            while (object4.hasNext()) {
                AuthnStatement authnStatement = (AuthnStatement)object4.next();
                if (authnStatement == null) continue;
                if (authnStatement.getAuthnInstant() != null) {
                    date = authnStatement.getAuthnInstant().toDate();
                }
                if (authnStatement.getAuthnContext() == null || authnStatement.getAuthnContext().getAuthnContextClassRef() == null) continue;
                aCR = new ACR(authnStatement.getAuthnContext().getAuthnContextClassRef().getAuthnContextClassRef());
            }
        }
        if (CollectionUtils.isEmpty(object4 = assertion.getSubject().getSubjectConfirmations())) {
            throw new ParseException("Missing SubjectConfirmation element");
        }
        boolean bl2 = false;
        Conditions conditions = object4.iterator();
        while (conditions.hasNext()) {
            object3 = (SubjectConfirmation)conditions.next();
            if (!"urn:oasis:names:tc:SAML:2.0:cm:bearer".equals(object3.getMethod())) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            throw new ParseException("Missing SubjectConfirmation Method urn:oasis:names:tc:SAML:2.0:cm:bearer attribute");
        }
        conditions = assertion.getConditions();
        if (conditions == null) {
            throw new ParseException("Missing Conditions element");
        }
        object3 = conditions.getAudienceRestrictions();
        if (CollectionUtils.isEmpty(object3)) {
            throw new ParseException("Missing AudienceRestriction element");
        }
        HashSet<Audience> hashSet = new HashSet<Audience>();
        Iterator iterator = object3.iterator();
        while (iterator.hasNext()) {
            audienceRestriction = (AudienceRestriction)iterator.next();
            if (CollectionUtils.isEmpty(audienceRestriction.getAudiences())) continue;
            for (Object object22 : audienceRestriction.getAudiences()) {
                hashSet.add(new Audience(object22.getAudienceURI()));
            }
        }
        iterator = object4.iterator();
        while (iterator.hasNext()) {
            audienceRestriction = (SubjectConfirmation)iterator.next();
            if (audienceRestriction.getSubjectConfirmationData() == null) continue;
            if (audienceRestriction.getSubjectConfirmationData().getRecipient() == null) {
                throw new ParseException("Missing SubjectConfirmationData Recipient attribute");
            }
            hashSet.add(new Audience(audienceRestriction.getSubjectConfirmationData().getRecipient()));
        }
        iterator = conditions.getNotOnOrAfter() != null ? conditions.getNotOnOrAfter().toDate() : null;
        Date date2 = audienceRestriction = conditions.getNotBefore() != null ? conditions.getNotBefore().toDate() : null;
        if (iterator == null) {
            object = object4.iterator();
            while (object.hasNext()) {
                object22 = (SubjectConfirmation)object.next();
                if (object22.getSubjectConfirmationData() == null) continue;
                iterator = object22.getSubjectConfirmationData().getNotOnOrAfter() != null ? object22.getSubjectConfirmationData().getNotOnOrAfter().toDate() : null;
                audienceRestriction = object22.getSubjectConfirmationData().getNotBefore() != null ? object22.getSubjectConfirmationData().getNotBefore().toDate() : null;
            }
        }
        if (assertion.getID() == null) {
            throw new ParseException("Missing Assertion ID attribute");
        }
        object = new Identifier(assertion.getID());
        if (assertion.getIssueInstant() == null) {
            throw new ParseException("Missing Assertion IssueInstant attribute");
        }
        object22 = assertion.getIssueInstant().toDate();
        InetAddress inetAddress = null;
        Object object5 = object4.iterator();
        while (object5.hasNext()) {
            SubjectConfirmation subjectConfirmation = (SubjectConfirmation)object5.next();
            if (subjectConfirmation.getSubjectConfirmationData() == null || subjectConfirmation.getSubjectConfirmationData().getAddress() == null) continue;
            try {
                inetAddress = InetAddress.getByName(subjectConfirmation.getSubjectConfirmationData().getAddress());
            }
            catch (UnknownHostException unknownHostException) {
                throw new ParseException("Invalid Address: " + unknownHostException.getMessage(), unknownHostException);
            }
        }
        object5 = null;
        if (CollectionUtils.isNotEmpty(assertion.getAttributeStatements())) {
            object5 = new HashMap();
            for (AttributeStatement attributeStatement : assertion.getAttributeStatements()) {
                if (attributeStatement == null) continue;
                for (Attribute attribute : attributeStatement.getAttributes()) {
                    String string2 = attribute.getName();
                    LinkedList<String> linkedList = new LinkedList<String>();
                    for (XMLObject xMLObject : attribute.getAttributeValues()) {
                        linkedList.add(xMLObject.getDOM().getTextContent());
                    }
                    object5.put(string2, linkedList);
                }
            }
        }
        return new SAML2AssertionDetails(issuer, subject, string, date, aCR, (List<Audience>)new ArrayList<Audience>(hashSet), (Date)((Object)iterator), (Date)audienceRestriction, (Date)object22, (Identifier)object, inetAddress, (Map<String, List<String>>)object5);
    }
}

