/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTParser;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.AuthorizationCode;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.AuthorizationResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ResponseMode;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ResponseType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.SuccessResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.State;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.AccessToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URIUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONAware;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public class AuthorizationSuccessResponse
extends AuthorizationResponse
implements SuccessResponse {
    private final AuthorizationCode code;
    private final AccessToken accessToken;

    public AuthorizationSuccessResponse(URI uRI, AuthorizationCode authorizationCode, AccessToken accessToken, State state, ResponseMode responseMode) {
        this(uRI, authorizationCode, accessToken, state, null, responseMode);
    }

    public AuthorizationSuccessResponse(URI uRI, AuthorizationCode authorizationCode, AccessToken accessToken, State state, Issuer issuer, ResponseMode responseMode) {
        super(uRI, state, issuer, responseMode);
        this.code = authorizationCode;
        this.accessToken = accessToken;
    }

    public AuthorizationSuccessResponse(URI uRI, JWT jWT, ResponseMode responseMode) {
        super(uRI, jWT, responseMode);
        this.code = null;
        this.accessToken = null;
    }

    @Override
    public boolean indicatesSuccess() {
        return true;
    }

    public ResponseType impliedResponseType() {
        ResponseType responseType = new ResponseType();
        if (this.code != null) {
            responseType.add(ResponseType.Value.CODE);
        }
        if (this.accessToken != null) {
            responseType.add(ResponseType.Value.TOKEN);
        }
        return responseType;
    }

    @Override
    public ResponseMode impliedResponseMode() {
        if (this.getResponseMode() != null) {
            return this.getResponseMode();
        }
        if (this.getJWTResponse() != null) {
            return ResponseMode.JWT;
        }
        if (this.accessToken != null) {
            return ResponseMode.FRAGMENT;
        }
        return ResponseMode.QUERY;
    }

    public AuthorizationCode getAuthorizationCode() {
        return this.code;
    }

    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    @Override
    public Map<String, List<String>> toParameters() {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        if (this.getJWTResponse() != null) {
            hashMap.put("response", Collections.singletonList(this.getJWTResponse().serialize()));
            return hashMap;
        }
        if (this.code != null) {
            hashMap.put("code", Collections.singletonList(this.code.getValue()));
        }
        if (this.accessToken != null) {
            for (Map.Entry entry : this.accessToken.toJSONObject().entrySet()) {
                hashMap.put((String)entry.getKey(), Collections.singletonList(entry.getValue().toString()));
            }
        }
        if (this.getState() != null) {
            hashMap.put("state", Collections.singletonList(this.getState().getValue()));
        }
        if (this.getIssuer() != null) {
            hashMap.put("iss", Collections.singletonList(this.getIssuer().getValue()));
        }
        return hashMap;
    }

    public static AuthorizationSuccessResponse parse(URI uRI, Map<String, List<String>> map) throws ParseException {
        JSONAware jSONAware;
        String string = MultivaluedMapUtils.getFirstValue(map, "response");
        if (string != null) {
            JWT jWT;
            try {
                jWT = JWTParser.parse(string);
            }
            catch (java.text.ParseException parseException) {
                throw new ParseException("Invalid JWT response: " + parseException.getMessage(), parseException);
            }
            return new AuthorizationSuccessResponse(uRI, jWT, ResponseMode.JWT);
        }
        AuthorizationCode authorizationCode = null;
        if (map.get("code") != null) {
            authorizationCode = new AuthorizationCode(MultivaluedMapUtils.getFirstValue(map, "code"));
        }
        AccessToken accessToken = null;
        if (map.get("access_token") != null) {
            jSONAware = new JSONObject();
            jSONAware.putAll(MultivaluedMapUtils.toSingleValuedMap(map));
            accessToken = AccessToken.parse(jSONAware);
        }
        jSONAware = State.parse(MultivaluedMapUtils.getFirstValue(map, "state"));
        Issuer issuer = Issuer.parse(MultivaluedMapUtils.getFirstValue(map, "iss"));
        return new AuthorizationSuccessResponse(uRI, authorizationCode, accessToken, (State)jSONAware, issuer, null);
    }

    public static AuthorizationSuccessResponse parse(URI uRI) throws ParseException {
        return AuthorizationSuccessResponse.parse(URIUtils.getBaseURI(uRI), AuthorizationSuccessResponse.parseResponseParameters(uRI));
    }

    public static AuthorizationSuccessResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        URI uRI = hTTPResponse.getLocation();
        if (uRI == null) {
            throw new ParseException("Missing redirection URL / HTTP Location header");
        }
        return AuthorizationSuccessResponse.parse(uRI);
    }

    public static AuthorizationSuccessResponse parse(HTTPRequest hTTPRequest) throws ParseException {
        return AuthorizationSuccessResponse.parse(hTTPRequest.getURI(), AuthorizationSuccessResponse.parseResponseParameters(hTTPRequest));
    }
}

