/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.AuthorizationErrorResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.AuthorizationSuccessResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.Response;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ResponseMode;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.SerializeException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.State;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.jarm.JARMUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.jarm.JARMValidator;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URIUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URLUtils;

public abstract class AuthorizationResponse
implements Response {
    private final URI redirectURI;
    private final State state;
    private final Issuer issuer;
    private final JWT jwtResponse;
    private final ResponseMode rm;

    protected AuthorizationResponse(URI uRI, State state, Issuer issuer, ResponseMode responseMode) {
        if (uRI == null) {
            throw new IllegalArgumentException("The redirection URI must not be null");
        }
        this.redirectURI = uRI;
        this.jwtResponse = null;
        this.state = state;
        this.issuer = issuer;
        this.rm = responseMode;
    }

    protected AuthorizationResponse(URI uRI, JWT jWT, ResponseMode responseMode) {
        if (uRI == null) {
            throw new IllegalArgumentException("The redirection URI must not be null");
        }
        this.redirectURI = uRI;
        if (jWT == null) {
            throw new IllegalArgumentException("The JWT response must not be null");
        }
        this.jwtResponse = jWT;
        this.state = null;
        this.issuer = null;
        this.rm = responseMode;
    }

    public URI getRedirectionURI() {
        return this.redirectURI;
    }

    public State getState() {
        return this.state;
    }

    public Issuer getIssuer() {
        return this.issuer;
    }

    public JWT getJWTResponse() {
        return this.jwtResponse;
    }

    public ResponseMode getResponseMode() {
        return this.rm;
    }

    public abstract ResponseMode impliedResponseMode();

    public abstract Map<String, List<String>> toParameters();

    public URI toURI() {
        ResponseMode responseMode = this.impliedResponseMode();
        StringBuilder stringBuilder = new StringBuilder(this.getRedirectionURI().toString());
        String string = URLUtils.serializeParameters(this.toParameters());
        if (StringUtils.isNotBlank(string)) {
            if (ResponseMode.QUERY.equals(responseMode) || ResponseMode.QUERY_JWT.equals(responseMode)) {
                if (!this.getRedirectionURI().toString().endsWith("?")) {
                    if (StringUtils.isBlank(this.getRedirectionURI().getRawQuery())) {
                        stringBuilder.append('?');
                    } else {
                        stringBuilder.append('&');
                    }
                }
            } else if (ResponseMode.FRAGMENT.equals(responseMode) || ResponseMode.FRAGMENT_JWT.equals(responseMode)) {
                stringBuilder.append('#');
            } else {
                throw new SerializeException("The (implied) response mode must be query or fragment");
            }
            stringBuilder.append(string);
        }
        try {
            return new URI(stringBuilder.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new SerializeException("Couldn't serialize response: " + uRISyntaxException.getMessage(), uRISyntaxException);
        }
    }

    @Override
    public HTTPResponse toHTTPResponse() {
        if (ResponseMode.FORM_POST.equals(this.rm)) {
            throw new SerializeException("The response mode must not be form_post");
        }
        HTTPResponse hTTPResponse = new HTTPResponse(302);
        hTTPResponse.setLocation(this.toURI());
        return hTTPResponse;
    }

    public HTTPRequest toHTTPRequest() {
        if (!ResponseMode.FORM_POST.equals(this.rm) && !ResponseMode.FORM_POST_JWT.equals(this.rm)) {
            throw new SerializeException("The response mode must be form_post or form_post.jwt");
        }
        HTTPRequest hTTPRequest = new HTTPRequest(HTTPRequest.Method.POST, this.getRedirectionURI());
        hTTPRequest.setEntityContentType(ContentType.APPLICATION_URLENCODED);
        hTTPRequest.appendQueryParameters(this.toParameters());
        return hTTPRequest;
    }

    public AuthorizationSuccessResponse toSuccessResponse() {
        return (AuthorizationSuccessResponse)this;
    }

    public AuthorizationErrorResponse toErrorResponse() {
        return (AuthorizationErrorResponse)this;
    }

    public static AuthorizationResponse parse(URI uRI, Map<String, List<String>> map) throws ParseException {
        return AuthorizationResponse.parse(uRI, map, null);
    }

    public static AuthorizationResponse parse(URI uRI, Map<String, List<String>> map, JARMValidator jARMValidator) throws ParseException {
        Map<String, List<String>> map2 = map;
        String string = MultivaluedMapUtils.getFirstValue(map, "response");
        if (jARMValidator != null) {
            if (StringUtils.isBlank(string)) {
                throw new ParseException("Missing JWT-secured (JARM) authorization response parameter");
            }
            try {
                JWTClaimsSet jWTClaimsSet = jARMValidator.validate(string);
                map2 = JARMUtils.toMultiValuedStringParameters(jWTClaimsSet);
            }
            catch (Exception exception) {
                throw new ParseException("Invalid JWT-secured (JARM) authorization response: " + exception.getMessage());
            }
        }
        if (StringUtils.isNotBlank(MultivaluedMapUtils.getFirstValue(map2, "error"))) {
            return AuthorizationErrorResponse.parse(uRI, map2);
        }
        if (StringUtils.isNotBlank(string)) {
            boolean bl2 = JARMUtils.impliesAuthorizationErrorResponse(string);
            if (bl2) {
                return AuthorizationErrorResponse.parse(uRI, map2);
            }
            return AuthorizationSuccessResponse.parse(uRI, map2);
        }
        return AuthorizationSuccessResponse.parse(uRI, map2);
    }

    public static AuthorizationResponse parse(URI uRI) throws ParseException {
        return AuthorizationResponse.parse(URIUtils.getBaseURI(uRI), AuthorizationResponse.parseResponseParameters(uRI));
    }

    public static AuthorizationResponse parse(URI uRI, JARMValidator jARMValidator) throws ParseException {
        if (jARMValidator == null) {
            throw new IllegalArgumentException("The JARM validator must not be null");
        }
        return AuthorizationResponse.parse(URIUtils.getBaseURI(uRI), AuthorizationResponse.parseResponseParameters(uRI), jARMValidator);
    }

    public static AuthorizationResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        URI uRI = hTTPResponse.getLocation();
        if (uRI == null) {
            throw new ParseException("Missing redirection URI / HTTP Location header");
        }
        return AuthorizationResponse.parse(uRI);
    }

    public static AuthorizationResponse parse(HTTPResponse hTTPResponse, JARMValidator jARMValidator) throws ParseException {
        URI uRI = hTTPResponse.getLocation();
        if (uRI == null) {
            throw new ParseException("Missing redirection URI / HTTP Location header");
        }
        return AuthorizationResponse.parse(uRI, jARMValidator);
    }

    public static AuthorizationResponse parse(HTTPRequest hTTPRequest) throws ParseException {
        return AuthorizationResponse.parse(hTTPRequest.getURI(), AuthorizationResponse.parseResponseParameters(hTTPRequest));
    }

    public static AuthorizationResponse parse(HTTPRequest hTTPRequest, JARMValidator jARMValidator) throws ParseException {
        if (jARMValidator == null) {
            throw new IllegalArgumentException("The JARM validator must not be null");
        }
        return AuthorizationResponse.parse(hTTPRequest.getURI(), AuthorizationResponse.parseResponseParameters(hTTPRequest), jARMValidator);
    }

    public static Map<String, List<String>> parseResponseParameters(URI uRI) throws ParseException {
        if (uRI.getRawFragment() != null) {
            return URLUtils.parseParameters(uRI.getRawFragment());
        }
        if (uRI.getRawQuery() != null) {
            return URLUtils.parseParameters(uRI.getRawQuery());
        }
        throw new ParseException("Missing URI fragment or query string");
    }

    public static Map<String, List<String>> parseResponseParameters(HTTPRequest hTTPRequest) throws ParseException {
        Map<String, List<String>> map = hTTPRequest.getQueryStringParameters();
        if (!map.isEmpty()) {
            return hTTPRequest.getQueryStringParameters();
        }
        if (StringUtils.isNotBlank(hTTPRequest.getBody()) && hTTPRequest.getBodyAsFormParameters() != null) {
            return hTTPRequest.getBodyAsFormParameters();
        }
        if (hTTPRequest.getURL().getRef() != null) {
            return URLUtils.parseParameters(hTTPRequest.getURL().getRef());
        }
        throw new ParseException("Missing URI fragment, query string or post body");
    }
}

