/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.cache;

import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.Immutable;

@Immutable
public final class CachedObject<V> {
    private final V object;
    private final long timestamp;
    private final long expirationTime;

    public static long computeExpirationTime(long l2, long l3) {
        long l4 = l2 + l3;
        if (l4 < 0L) {
            return Long.MAX_VALUE;
        }
        return l4;
    }

    public CachedObject(V v2, long l2, long l3) {
        this.object = Objects.requireNonNull(v2);
        this.timestamp = l2;
        this.expirationTime = l3;
    }

    public V get() {
        return this.object;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public boolean isValid(long l2) {
        return l2 < this.expirationTime;
    }

    public boolean isExpired(long l2) {
        return !this.isValid(l2);
    }
}

