/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.internal.sql;

import java.io.IOException;
import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.Gson;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.JsonSyntaxException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.TypeAdapter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.TypeAdapterFactory;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.reflect.TypeToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.stream.JsonReader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.stream.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.stream.JsonWriter;

final class SqlTimeTypeAdapter
extends TypeAdapter<Time> {
    static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            return typeToken.getRawType() == Time.class ? new SqlTimeTypeAdapter() : null;
        }
    };
    private final DateFormat format = new SimpleDateFormat("hh:mm:ss a");

    private SqlTimeTypeAdapter() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Time read(JsonReader jsonReader) throws IOException {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        String string = jsonReader.nextString();
        SqlTimeTypeAdapter sqlTimeTypeAdapter = this;
        synchronized (sqlTimeTypeAdapter) {
            TimeZone timeZone = this.format.getTimeZone();
            try {
                Date date = this.format.parse(string);
                Time time = new Time(date.getTime());
                return time;
            }
            catch (ParseException parseException) {
                throw new JsonSyntaxException("Failed parsing '" + string + "' as SQL Time; at path " + jsonReader.getPreviousPath(), parseException);
            }
            finally {
                this.format.setTimeZone(timeZone);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(JsonWriter jsonWriter, Time time) throws IOException {
        String string;
        if (time == null) {
            jsonWriter.nullValue();
            return;
        }
        SqlTimeTypeAdapter sqlTimeTypeAdapter = this;
        synchronized (sqlTimeTypeAdapter) {
            string = this.format.format(time);
        }
        jsonWriter.value(string);
    }
}

