/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.InlineMe;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.ExclusionStrategy;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.FieldNamingPolicy;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.FieldNamingStrategy;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.FormattingStyle;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.Gson;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.InstanceCreator;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.JsonDeserializer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.JsonElement;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.JsonSerializer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.LongSerializationPolicy;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.ReflectionAccessFilter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.Strictness;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.ToNumberStrategy;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.TypeAdapter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.TypeAdapterFactory;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.internal.$Gson$Preconditions;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.internal.Excluder;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.internal.bind.DefaultDateTypeAdapter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.internal.bind.TreeTypeAdapter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.internal.bind.TypeAdapters;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.internal.sql.SqlTypesSupport;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.reflect.TypeToken;

public final class GsonBuilder {
    private Excluder excluder = Excluder.DEFAULT;
    private LongSerializationPolicy longSerializationPolicy = LongSerializationPolicy.DEFAULT;
    private FieldNamingStrategy fieldNamingPolicy = FieldNamingPolicy.IDENTITY;
    private final Map<Type, InstanceCreator<?>> instanceCreators = new HashMap();
    private final List<TypeAdapterFactory> factories = new ArrayList<TypeAdapterFactory>();
    private final List<TypeAdapterFactory> hierarchyFactories = new ArrayList<TypeAdapterFactory>();
    private boolean serializeNulls = false;
    private String datePattern = Gson.DEFAULT_DATE_PATTERN;
    private int dateStyle = 2;
    private int timeStyle = 2;
    private boolean complexMapKeySerialization = false;
    private boolean serializeSpecialFloatingPointValues = false;
    private boolean escapeHtmlChars = true;
    private FormattingStyle formattingStyle = Gson.DEFAULT_FORMATTING_STYLE;
    private boolean generateNonExecutableJson = false;
    private Strictness strictness = Gson.DEFAULT_STRICTNESS;
    private boolean useJdkUnsafe = true;
    private ToNumberStrategy objectToNumberStrategy = Gson.DEFAULT_OBJECT_TO_NUMBER_STRATEGY;
    private ToNumberStrategy numberToNumberStrategy = Gson.DEFAULT_NUMBER_TO_NUMBER_STRATEGY;
    private final ArrayDeque<ReflectionAccessFilter> reflectionFilters = new ArrayDeque();

    public GsonBuilder() {
    }

    GsonBuilder(Gson gson) {
        this.excluder = gson.excluder;
        this.fieldNamingPolicy = gson.fieldNamingStrategy;
        this.instanceCreators.putAll(gson.instanceCreators);
        this.serializeNulls = gson.serializeNulls;
        this.complexMapKeySerialization = gson.complexMapKeySerialization;
        this.generateNonExecutableJson = gson.generateNonExecutableJson;
        this.escapeHtmlChars = gson.htmlSafe;
        this.formattingStyle = gson.formattingStyle;
        this.strictness = gson.strictness;
        this.serializeSpecialFloatingPointValues = gson.serializeSpecialFloatingPointValues;
        this.longSerializationPolicy = gson.longSerializationPolicy;
        this.datePattern = gson.datePattern;
        this.dateStyle = gson.dateStyle;
        this.timeStyle = gson.timeStyle;
        this.factories.addAll(gson.builderFactories);
        this.hierarchyFactories.addAll(gson.builderHierarchyFactories);
        this.useJdkUnsafe = gson.useJdkUnsafe;
        this.objectToNumberStrategy = gson.objectToNumberStrategy;
        this.numberToNumberStrategy = gson.numberToNumberStrategy;
        this.reflectionFilters.addAll(gson.reflectionFilters);
    }

    @CanIgnoreReturnValue
    public GsonBuilder setVersion(double d2) {
        if (Double.isNaN(d2) || d2 < 0.0) {
            throw new IllegalArgumentException("Invalid version: " + d2);
        }
        this.excluder = this.excluder.withVersion(d2);
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder excludeFieldsWithModifiers(int ... nArray) {
        Objects.requireNonNull(nArray);
        this.excluder = this.excluder.withModifiers(nArray);
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder generateNonExecutableJson() {
        this.generateNonExecutableJson = true;
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder excludeFieldsWithoutExposeAnnotation() {
        this.excluder = this.excluder.excludeFieldsWithoutExposeAnnotation();
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder serializeNulls() {
        this.serializeNulls = true;
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder enableComplexMapKeySerialization() {
        this.complexMapKeySerialization = true;
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder disableInnerClassSerialization() {
        this.excluder = this.excluder.disableInnerClassSerialization();
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder setLongSerializationPolicy(LongSerializationPolicy longSerializationPolicy) {
        this.longSerializationPolicy = Objects.requireNonNull(longSerializationPolicy);
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder setFieldNamingPolicy(FieldNamingPolicy fieldNamingPolicy) {
        return this.setFieldNamingStrategy(fieldNamingPolicy);
    }

    @CanIgnoreReturnValue
    public GsonBuilder setFieldNamingStrategy(FieldNamingStrategy fieldNamingStrategy) {
        this.fieldNamingPolicy = Objects.requireNonNull(fieldNamingStrategy);
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder setObjectToNumberStrategy(ToNumberStrategy toNumberStrategy) {
        this.objectToNumberStrategy = Objects.requireNonNull(toNumberStrategy);
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder setNumberToNumberStrategy(ToNumberStrategy toNumberStrategy) {
        this.numberToNumberStrategy = Objects.requireNonNull(toNumberStrategy);
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder setExclusionStrategies(ExclusionStrategy ... exclusionStrategyArray) {
        Objects.requireNonNull(exclusionStrategyArray);
        for (ExclusionStrategy exclusionStrategy : exclusionStrategyArray) {
            this.excluder = this.excluder.withExclusionStrategy(exclusionStrategy, true, true);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder addSerializationExclusionStrategy(ExclusionStrategy exclusionStrategy) {
        Objects.requireNonNull(exclusionStrategy);
        this.excluder = this.excluder.withExclusionStrategy(exclusionStrategy, true, false);
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder addDeserializationExclusionStrategy(ExclusionStrategy exclusionStrategy) {
        Objects.requireNonNull(exclusionStrategy);
        this.excluder = this.excluder.withExclusionStrategy(exclusionStrategy, false, true);
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder setPrettyPrinting() {
        return this.setFormattingStyle(FormattingStyle.PRETTY);
    }

    @CanIgnoreReturnValue
    public GsonBuilder setFormattingStyle(FormattingStyle formattingStyle) {
        this.formattingStyle = Objects.requireNonNull(formattingStyle);
        return this;
    }

    @Deprecated
    @InlineMe(replacement="this.setStrictness(Strictness.LENIENT)", imports={"macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.Strictness"})
    @CanIgnoreReturnValue
    public GsonBuilder setLenient() {
        return this.setStrictness(Strictness.LENIENT);
    }

    @CanIgnoreReturnValue
    public GsonBuilder setStrictness(Strictness strictness) {
        this.strictness = Objects.requireNonNull(strictness);
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder disableHtmlEscaping() {
        this.escapeHtmlChars = false;
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder setDateFormat(String string) {
        if (string != null) {
            try {
                new SimpleDateFormat(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("The date pattern '" + string + "' is not valid", illegalArgumentException);
            }
        }
        this.datePattern = string;
        return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public GsonBuilder setDateFormat(int n2) {
        this.dateStyle = GsonBuilder.checkDateFormatStyle(n2);
        this.datePattern = null;
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder setDateFormat(int n2, int n3) {
        this.dateStyle = GsonBuilder.checkDateFormatStyle(n2);
        this.timeStyle = GsonBuilder.checkDateFormatStyle(n3);
        this.datePattern = null;
        return this;
    }

    private static int checkDateFormatStyle(int n2) {
        if (n2 < 0 || n2 > 3) {
            throw new IllegalArgumentException("Invalid style: " + n2);
        }
        return n2;
    }

    @CanIgnoreReturnValue
    public GsonBuilder registerTypeAdapter(Type type, Object object) {
        Object object2;
        Objects.requireNonNull(type);
        $Gson$Preconditions.checkArgument(object instanceof JsonSerializer || object instanceof JsonDeserializer || object instanceof InstanceCreator || object instanceof TypeAdapter);
        if (GsonBuilder.isTypeObjectOrJsonElement(type)) {
            throw new IllegalArgumentException("Cannot override built-in adapter for " + type);
        }
        if (object instanceof InstanceCreator) {
            this.instanceCreators.put(type, (InstanceCreator)object);
        }
        if (object instanceof JsonSerializer || object instanceof JsonDeserializer) {
            object2 = TypeToken.get(type);
            this.factories.add(TreeTypeAdapter.newFactoryWithMatchRawType(object2, object));
        }
        if (object instanceof TypeAdapter) {
            object2 = TypeAdapters.newFactory(TypeToken.get(type), (TypeAdapter)object);
            this.factories.add((TypeAdapterFactory)object2);
        }
        return this;
    }

    private static boolean isTypeObjectOrJsonElement(Type type) {
        return type instanceof Class && (type == Object.class || JsonElement.class.isAssignableFrom((Class)type));
    }

    @CanIgnoreReturnValue
    public GsonBuilder registerTypeAdapterFactory(TypeAdapterFactory typeAdapterFactory) {
        Objects.requireNonNull(typeAdapterFactory);
        this.factories.add(typeAdapterFactory);
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder registerTypeHierarchyAdapter(Class<?> clazz, Object object) {
        Objects.requireNonNull(clazz);
        $Gson$Preconditions.checkArgument(object instanceof JsonSerializer || object instanceof JsonDeserializer || object instanceof TypeAdapter);
        if (JsonElement.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Cannot override built-in adapter for " + clazz);
        }
        if (object instanceof JsonDeserializer || object instanceof JsonSerializer) {
            this.hierarchyFactories.add(TreeTypeAdapter.newTypeHierarchyFactory(clazz, object));
        }
        if (object instanceof TypeAdapter) {
            TypeAdapterFactory typeAdapterFactory = TypeAdapters.newTypeHierarchyFactory(clazz, (TypeAdapter)object);
            this.factories.add(typeAdapterFactory);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder serializeSpecialFloatingPointValues() {
        this.serializeSpecialFloatingPointValues = true;
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder disableJdkUnsafe() {
        this.useJdkUnsafe = false;
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder addReflectionAccessFilter(ReflectionAccessFilter reflectionAccessFilter) {
        Objects.requireNonNull(reflectionAccessFilter);
        this.reflectionFilters.addFirst(reflectionAccessFilter);
        return this;
    }

    public Gson create() {
        ArrayList<TypeAdapterFactory> arrayList = new ArrayList<TypeAdapterFactory>(this.factories.size() + this.hierarchyFactories.size() + 3);
        arrayList.addAll(this.factories);
        Collections.reverse(arrayList);
        ArrayList<TypeAdapterFactory> arrayList2 = new ArrayList<TypeAdapterFactory>(this.hierarchyFactories);
        Collections.reverse(arrayList2);
        arrayList.addAll(arrayList2);
        GsonBuilder.addTypeAdaptersForDate(this.datePattern, this.dateStyle, this.timeStyle, arrayList);
        return new Gson(this.excluder, this.fieldNamingPolicy, new HashMap(this.instanceCreators), this.serializeNulls, this.complexMapKeySerialization, this.generateNonExecutableJson, this.escapeHtmlChars, this.formattingStyle, this.strictness, this.serializeSpecialFloatingPointValues, this.useJdkUnsafe, this.longSerializationPolicy, this.datePattern, this.dateStyle, this.timeStyle, new ArrayList<TypeAdapterFactory>(this.factories), new ArrayList<TypeAdapterFactory>(this.hierarchyFactories), arrayList, this.objectToNumberStrategy, this.numberToNumberStrategy, new ArrayList<ReflectionAccessFilter>(this.reflectionFilters));
    }

    private static void addTypeAdaptersForDate(String string, int n2, int n3, List<TypeAdapterFactory> list) {
        TypeAdapterFactory typeAdapterFactory;
        boolean bl2 = SqlTypesSupport.SUPPORTS_SQL_TYPES;
        TypeAdapterFactory typeAdapterFactory2 = null;
        TypeAdapterFactory typeAdapterFactory3 = null;
        if (string != null && !string.trim().isEmpty()) {
            typeAdapterFactory = DefaultDateTypeAdapter.DateType.DATE.createAdapterFactory(string);
            if (bl2) {
                typeAdapterFactory2 = SqlTypesSupport.TIMESTAMP_DATE_TYPE.createAdapterFactory(string);
                typeAdapterFactory3 = SqlTypesSupport.DATE_DATE_TYPE.createAdapterFactory(string);
            }
        } else if (n2 != 2 || n3 != 2) {
            typeAdapterFactory = DefaultDateTypeAdapter.DateType.DATE.createAdapterFactory(n2, n3);
            if (bl2) {
                typeAdapterFactory2 = SqlTypesSupport.TIMESTAMP_DATE_TYPE.createAdapterFactory(n2, n3);
                typeAdapterFactory3 = SqlTypesSupport.DATE_DATE_TYPE.createAdapterFactory(n2, n3);
            }
        } else {
            return;
        }
        list.add(typeAdapterFactory);
        if (bl2) {
            list.add(typeAdapterFactory2);
            list.add(typeAdapterFactory3);
        }
    }
}

