/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc;

import java.security.Key;
import java.text.ParseException;
import java.util.List;
import java.util.ListIterator;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEDecrypter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Payload;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.PlainObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.factories.DefaultJWEDecrypterFactory;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.factories.DefaultJWSVerifierFactory;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.BadJOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.BadJWEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.BadJWSException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.ConfigurableJOSEProcessor;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.DefaultJOSEObjectTypeVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.JOSEObjectTypeVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.JWEDecrypterFactory;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.JWEKeySelector;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.JWSKeySelector;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.JWSVerifierFactory;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.SecurityContext;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.ThreadSafe;

@ThreadSafe
public class DefaultJOSEProcessor<C extends SecurityContext>
implements ConfigurableJOSEProcessor<C> {
    private JOSEObjectTypeVerifier<C> jwsTypeVerifier = DefaultJOSEObjectTypeVerifier.JOSE;
    private JOSEObjectTypeVerifier<C> jweTypeVerifier = DefaultJOSEObjectTypeVerifier.JOSE;
    private JWSKeySelector<C> jwsKeySelector;
    private JWEKeySelector<C> jweKeySelector;
    private JWSVerifierFactory jwsVerifierFactory = new DefaultJWSVerifierFactory();
    private JWEDecrypterFactory jweDecrypterFactory = new DefaultJWEDecrypterFactory();

    @Override
    public JOSEObjectTypeVerifier<C> getJWSTypeVerifier() {
        return this.jwsTypeVerifier;
    }

    @Override
    public void setJWSTypeVerifier(JOSEObjectTypeVerifier<C> jOSEObjectTypeVerifier) {
        this.jwsTypeVerifier = jOSEObjectTypeVerifier;
    }

    @Override
    public JWSKeySelector<C> getJWSKeySelector() {
        return this.jwsKeySelector;
    }

    @Override
    public void setJWSKeySelector(JWSKeySelector<C> jWSKeySelector) {
        this.jwsKeySelector = jWSKeySelector;
    }

    @Override
    public JOSEObjectTypeVerifier<C> getJWETypeVerifier() {
        return this.jweTypeVerifier;
    }

    @Override
    public void setJWETypeVerifier(JOSEObjectTypeVerifier<C> jOSEObjectTypeVerifier) {
        this.jweTypeVerifier = jOSEObjectTypeVerifier;
    }

    @Override
    public JWEKeySelector<C> getJWEKeySelector() {
        return this.jweKeySelector;
    }

    @Override
    public void setJWEKeySelector(JWEKeySelector<C> jWEKeySelector) {
        this.jweKeySelector = jWEKeySelector;
    }

    @Override
    public JWSVerifierFactory getJWSVerifierFactory() {
        return this.jwsVerifierFactory;
    }

    @Override
    public void setJWSVerifierFactory(JWSVerifierFactory jWSVerifierFactory) {
        this.jwsVerifierFactory = jWSVerifierFactory;
    }

    @Override
    public JWEDecrypterFactory getJWEDecrypterFactory() {
        return this.jweDecrypterFactory;
    }

    @Override
    public void setJWEDecrypterFactory(JWEDecrypterFactory jWEDecrypterFactory) {
        this.jweDecrypterFactory = jWEDecrypterFactory;
    }

    @Override
    public Payload process(String string, C c2) throws ParseException, BadJOSEException, JOSEException {
        return this.process(JOSEObject.parse(string), c2);
    }

    @Override
    public Payload process(JOSEObject jOSEObject, C c2) throws BadJOSEException, JOSEException {
        if (jOSEObject instanceof JWSObject) {
            return this.process((JWSObject)jOSEObject, c2);
        }
        if (jOSEObject instanceof JWEObject) {
            return this.process((JWEObject)jOSEObject, c2);
        }
        if (jOSEObject instanceof PlainObject) {
            return this.process((PlainObject)jOSEObject, c2);
        }
        throw new JOSEException("Unexpected JOSE object type: " + jOSEObject.getClass());
    }

    @Override
    public Payload process(PlainObject plainObject, C c2) throws BadJOSEException {
        if (this.jwsTypeVerifier == null) {
            throw new BadJOSEException("Unsecured (plain) JOSE object rejected: No JWS header typ (type) verifier is configured");
        }
        this.jwsTypeVerifier.verify(plainObject.getHeader().getType(), c2);
        throw new BadJOSEException("Unsecured (plain) JOSE objects are rejected, extend class to handle");
    }

    @Override
    public Payload process(JWSObject jWSObject, C c2) throws BadJOSEException, JOSEException {
        if (this.jwsTypeVerifier == null) {
            throw new BadJOSEException("JWS object rejected: No JWS header typ (type) verifier is configured");
        }
        this.jwsTypeVerifier.verify(jWSObject.getHeader().getType(), c2);
        if (this.getJWSKeySelector() == null) {
            throw new BadJOSEException("JWS object rejected: No JWS key selector is configured");
        }
        if (this.getJWSVerifierFactory() == null) {
            throw new JOSEException("No JWS verifier is configured");
        }
        List<Key> list = this.getJWSKeySelector().selectJWSKeys(jWSObject.getHeader(), c2);
        if (list == null || list.isEmpty()) {
            throw new BadJOSEException("JWS object rejected: Another algorithm expected, or no matching key(s) found");
        }
        ListIterator<Key> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            JWSVerifier jWSVerifier = this.getJWSVerifierFactory().createJWSVerifier(jWSObject.getHeader(), listIterator.next());
            if (jWSVerifier == null) continue;
            boolean bl2 = jWSObject.verify(jWSVerifier);
            if (bl2) {
                return jWSObject.getPayload();
            }
            if (listIterator.hasNext()) continue;
            throw new BadJWSException("JWS object rejected: Invalid signature");
        }
        throw new BadJOSEException("JWS object rejected: No matching verifier(s) found");
    }

    @Override
    public Payload process(JWEObject jWEObject, C c2) throws BadJOSEException, JOSEException {
        if (this.jweTypeVerifier == null) {
            throw new BadJOSEException("JWE object rejected: No JWE header typ (type) verifier is configured");
        }
        this.jweTypeVerifier.verify(jWEObject.getHeader().getType(), c2);
        if (this.getJWEKeySelector() == null) {
            throw new BadJOSEException("JWE object rejected: No JWE key selector is configured");
        }
        if (this.getJWEDecrypterFactory() == null) {
            throw new JOSEException("No JWE decrypter is configured");
        }
        List<Key> list = this.getJWEKeySelector().selectJWEKeys(jWEObject.getHeader(), c2);
        if (list == null || list.isEmpty()) {
            throw new BadJOSEException("JWE object rejected: Another algorithm expected, or no matching key(s) found");
        }
        ListIterator<Key> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            JWEDecrypter jWEDecrypter = this.getJWEDecrypterFactory().createJWEDecrypter(jWEObject.getHeader(), listIterator.next());
            if (jWEDecrypter == null) continue;
            try {
                jWEObject.decrypt(jWEDecrypter);
            }
            catch (JOSEException jOSEException) {
                if (listIterator.hasNext()) continue;
                throw new BadJWEException("JWE object rejected: " + jOSEException.getMessage(), jOSEException);
            }
            if ("JWT".equalsIgnoreCase(jWEObject.getHeader().getContentType())) {
                JWSObject jWSObject = jWEObject.getPayload().toJWSObject();
                if (jWSObject == null) {
                    return jWEObject.getPayload();
                }
                return this.process(jWSObject, c2);
            }
            return jWEObject.getPayload();
        }
        throw new BadJOSEException("JWE object rejected: No matching decrypter(s) found");
    }
}

