/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source;

import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSetSource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSetSourceWrapper;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.SecurityContext;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.ThreadSafe;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.cache.CachedObject;

@ThreadSafe
abstract class AbstractCachingJWKSetSource<C extends SecurityContext>
extends JWKSetSourceWrapper<C> {
    private volatile CachedObject<JWKSet> cachedJWKSet;
    private final long timeToLive;

    AbstractCachingJWKSetSource(JWKSetSource<C> jWKSetSource, long l2) {
        super(jWKSetSource);
        this.timeToLive = l2;
    }

    CachedObject<JWKSet> getCachedJWKSet() {
        return this.cachedJWKSet;
    }

    void setCachedJWKSet(CachedObject<JWKSet> cachedObject) {
        this.cachedJWKSet = cachedObject;
    }

    CachedObject<JWKSet> getCachedJWKSetIfValid(long l2) {
        CachedObject<JWKSet> cachedObject = this.getCachedJWKSet();
        if (cachedObject != null && cachedObject.isValid(l2)) {
            return cachedObject;
        }
        return null;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    CachedObject<JWKSet> cacheJWKSet(JWKSet jWKSet, long l2) {
        long l3 = this.currentTimeMillis();
        CachedObject<JWKSet> cachedObject = new CachedObject<JWKSet>(jWKSet, l3, CachedObject.computeExpirationTime(l2, this.getTimeToLive()));
        this.setCachedJWKSet(cachedObject);
        return cachedObject;
    }

    long currentTimeMillis() {
        return System.currentTimeMillis();
    }
}

