/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.Immutable;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;

@Immutable
public class ThumbprintURI {
    public static final String PREFIX = "urn:ietf:params:oauth:jwk-thumbprint:";
    private final String hashAlg;
    private final Base64URL thumbprint;

    public ThumbprintURI(String string, Base64URL base64URL) {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("The hash algorithm must not be empty");
        }
        this.hashAlg = string;
        if (base64URL.toString().isEmpty()) {
            throw new IllegalArgumentException("The thumbprint must not be empty");
        }
        this.thumbprint = base64URL;
    }

    public String getAlgorithmString() {
        return this.hashAlg;
    }

    public Base64URL getThumbprint() {
        return this.thumbprint;
    }

    public URI toURI() {
        return URI.create(this.toString());
    }

    public String toString() {
        return PREFIX + this.hashAlg + ":" + this.thumbprint;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ThumbprintURI)) {
            return false;
        }
        ThumbprintURI thumbprintURI = (ThumbprintURI)object;
        return this.hashAlg.equals(thumbprintURI.hashAlg) && this.getThumbprint().equals(thumbprintURI.getThumbprint());
    }

    public int hashCode() {
        return Objects.hash(this.hashAlg, this.getThumbprint());
    }

    public static ThumbprintURI compute(JWK jWK) throws JOSEException {
        return new ThumbprintURI("sha-256", jWK.computeThumbprint());
    }

    public static ThumbprintURI parse(URI uRI) throws ParseException {
        String string = uRI.toString();
        if (!string.startsWith(PREFIX)) {
            throw new ParseException("Illegal JWK thumbprint prefix", 0);
        }
        String string2 = string.substring(PREFIX.length());
        if (string2.isEmpty()) {
            throw new ParseException("Illegal JWK thumbprint: Missing value", 0);
        }
        String[] stringArray = string2.split(":");
        if (stringArray.length != 2) {
            throw new ParseException("Illegal JWK thumbprint: Unexpected number of components", 0);
        }
        if (stringArray[0].isEmpty()) {
            throw new ParseException("Illegal JWK thumbprint: The hash algorithm must not be empty", 0);
        }
        return new ThumbprintURI(stringArray[0], new Base64URL(stringArray[1]));
    }

    public static ThumbprintURI parse(String string) throws ParseException {
        try {
            return ThumbprintURI.parse(new URI(string));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ParseException(uRISyntaxException.getMessage(), 0);
        }
    }
}

