/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl;

import com.google.crypto.tink.subtle.XChaCha20Poly1305;
import java.security.GeneralSecurityException;
import javax.crypto.SecretKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AuthenticatedCipherText;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.ThreadSafe;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.ByteUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Container;

@ThreadSafe
public class XC20P {
    public static final int AUTH_TAG_BIT_LENGTH = 128;
    public static final int IV_BIT_LENGTH = 192;

    public static AuthenticatedCipherText encryptAuthenticated(SecretKey secretKey, Container<byte[]> container, byte[] byArray, byte[] byArray2) throws JOSEException {
        byte[] byArray3;
        XChaCha20Poly1305 xChaCha20Poly1305;
        try {
            xChaCha20Poly1305 = new XChaCha20Poly1305(secretKey.getEncoded());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new JOSEException("Invalid XChaCha20Poly1305 key: " + generalSecurityException.getMessage(), generalSecurityException);
        }
        try {
            byArray3 = xChaCha20Poly1305.encrypt(byArray, byArray2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new JOSEException("Couldn't encrypt with XChaCha20Poly1305: " + generalSecurityException.getMessage(), generalSecurityException);
        }
        int n2 = byArray3.length - ByteUtils.byteLength(128);
        int n3 = ByteUtils.byteLength(192);
        byte[] byArray4 = ByteUtils.subArray(byArray3, 0, n3);
        byte[] byArray5 = ByteUtils.subArray(byArray3, n3, n2 - n3);
        byte[] byArray6 = ByteUtils.subArray(byArray3, n2, ByteUtils.byteLength(128));
        container.set(byArray4);
        return new AuthenticatedCipherText(byArray5, byArray6);
    }

    public static byte[] decryptAuthenticated(SecretKey secretKey, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) throws JOSEException {
        XChaCha20Poly1305 xChaCha20Poly1305;
        try {
            xChaCha20Poly1305 = new XChaCha20Poly1305(secretKey.getEncoded());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new JOSEException("Invalid XChaCha20Poly1305 key: " + generalSecurityException.getMessage(), generalSecurityException);
        }
        byte[] byArray5 = ByteUtils.concat(byArray, byArray2, byArray4);
        try {
            return xChaCha20Poly1305.decrypt(byArray5, byArray3);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new JOSEException("XChaCha20Poly1305 decryption failed: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }
}

