/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.ThreadSafe;

@ThreadSafe
public class HMAC {
    public static Mac getInitMac(SecretKey secretKey, Provider provider) throws JOSEException {
        return HMAC.getInitMac(secretKey.getAlgorithm(), secretKey, provider);
    }

    public static Mac getInitMac(String string, SecretKey secretKey, Provider provider) throws JOSEException {
        Mac mac;
        try {
            mac = provider != null ? Mac.getInstance(string, provider) : Mac.getInstance(string);
            mac.init(secretKey);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new JOSEException("Unsupported HMAC algorithm: " + noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new JOSEException("Invalid HMAC key: " + invalidKeyException.getMessage(), invalidKeyException);
        }
        return mac;
    }

    @Deprecated
    public static byte[] compute(String string, byte[] byArray, byte[] byArray2, Provider provider) throws JOSEException {
        return HMAC.compute(string, new SecretKeySpec(byArray, string), byArray2, provider);
    }

    public static byte[] compute(String string, SecretKey secretKey, byte[] byArray, Provider provider) throws JOSEException {
        Mac mac = HMAC.getInitMac(string, secretKey, provider);
        mac.update(byArray);
        return mac.doFinal();
    }

    public static byte[] compute(SecretKey secretKey, byte[] byArray, Provider provider) throws JOSEException {
        return HMAC.compute(secretKey.getAlgorithm(), secretKey, byArray, provider);
    }
}

