/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.crypto.SecretKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.EncryptionMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWECryptoParts;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AESKW;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AlgorithmSupportMessage;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.BaseJWEProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.ConcatKDF;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.ContentCryptoProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.ECDH;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.ECDH1PU;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.JWEHeaderValidation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.Curve;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;

public abstract class ECDH1PUCryptoProvider
extends BaseJWEProvider {
    public static final Set<JWEAlgorithm> SUPPORTED_ALGORITHMS;
    public static final Set<EncryptionMethod> SUPPORTED_ENCRYPTION_METHODS;
    private final Curve curve;
    private final ConcatKDF concatKDF;

    protected ECDH1PUCryptoProvider(Curve curve, SecretKey secretKey) throws JOSEException {
        super(SUPPORTED_ALGORITHMS, ContentCryptoProvider.SUPPORTED_ENCRYPTION_METHODS, secretKey);
        Curve curve2;
        Curve curve3 = curve2 = curve != null ? curve : new Curve("unknown");
        if (!this.supportedEllipticCurves().contains(curve)) {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedEllipticCurve(curve2, this.supportedEllipticCurves()));
        }
        this.curve = curve;
        this.concatKDF = new ConcatKDF("SHA-256");
    }

    protected ConcatKDF getConcatKDF() {
        return this.concatKDF;
    }

    public abstract Set<Curve> supportedEllipticCurves();

    public Curve getCurve() {
        return this.curve;
    }

    protected JWECryptoParts encryptWithZ(JWEHeader jWEHeader, SecretKey secretKey, byte[] byArray, byte[] byArray2) throws JOSEException {
        JWEAlgorithm jWEAlgorithm = JWEHeaderValidation.getAlgorithmAndEnsureNotNull(jWEHeader);
        ECDH.AlgorithmMode algorithmMode = ECDH1PU.resolveAlgorithmMode(jWEAlgorithm);
        EncryptionMethod encryptionMethod = jWEHeader.getEncryptionMethod();
        if (algorithmMode.equals((Object)ECDH.AlgorithmMode.DIRECT)) {
            if (this.isCEKProvided()) {
                throw new JOSEException("The provided CEK is not supported");
            }
            this.getConcatKDF().getJCAContext().setProvider(this.getJCAContext().getMACProvider());
            SecretKey secretKey2 = ECDH1PU.deriveSharedKey(jWEHeader, secretKey, this.getConcatKDF());
            return ContentCryptoProvider.encrypt(jWEHeader, byArray, byArray2, secretKey2, null, this.getJCAContext());
        }
        if (algorithmMode.equals((Object)ECDH.AlgorithmMode.KW)) {
            if (!EncryptionMethod.Family.AES_CBC_HMAC_SHA.contains(encryptionMethod)) {
                throw new JOSEException(AlgorithmSupportMessage.unsupportedEncryptionMethod(jWEHeader.getEncryptionMethod(), EncryptionMethod.Family.AES_CBC_HMAC_SHA));
            }
            SecretKey secretKey3 = this.getCEK(encryptionMethod);
            JWECryptoParts jWECryptoParts = ContentCryptoProvider.encrypt(jWEHeader, byArray, byArray2, secretKey3, null, this.getJCAContext());
            SecretKey secretKey4 = ECDH1PU.deriveSharedKey(jWEHeader, secretKey, jWECryptoParts.getAuthenticationTag(), this.getConcatKDF());
            Base64URL base64URL = Base64URL.encode(AESKW.wrapCEK(secretKey3, secretKey4, this.getJCAContext().getKeyEncryptionProvider()));
            return new JWECryptoParts(jWEHeader, base64URL, jWECryptoParts.getInitializationVector(), jWECryptoParts.getCipherText(), jWECryptoParts.getAuthenticationTag());
        }
        throw new JOSEException("Unexpected JWE ECDH algorithm mode: " + (Object)((Object)algorithmMode));
    }

    protected byte[] decryptWithZ(JWEHeader jWEHeader, byte[] byArray, SecretKey secretKey, Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, Base64URL base64URL4) throws JOSEException {
        SecretKey secretKey2;
        JWEAlgorithm jWEAlgorithm = JWEHeaderValidation.getAlgorithmAndEnsureNotNull(jWEHeader);
        ECDH.AlgorithmMode algorithmMode = ECDH1PU.resolveAlgorithmMode(jWEAlgorithm);
        this.getConcatKDF().getJCAContext().setProvider(this.getJCAContext().getMACProvider());
        if (algorithmMode.equals((Object)ECDH.AlgorithmMode.DIRECT)) {
            secretKey2 = ECDH1PU.deriveSharedKey(jWEHeader, secretKey, this.getConcatKDF());
        } else if (algorithmMode.equals((Object)ECDH.AlgorithmMode.KW)) {
            if (base64URL == null) {
                throw new JOSEException("Missing JWE encrypted key");
            }
            SecretKey secretKey3 = ECDH1PU.deriveSharedKey(jWEHeader, secretKey, base64URL4, this.getConcatKDF());
            secretKey2 = AESKW.unwrapCEK(secretKey3, base64URL.decode(), this.getJCAContext().getKeyEncryptionProvider());
        } else {
            throw new JOSEException("Unexpected JWE ECDH algorithm mode: " + (Object)((Object)algorithmMode));
        }
        return ContentCryptoProvider.decrypt(jWEHeader, byArray, null, base64URL2, base64URL3, base64URL4, secretKey2, this.getJCAContext());
    }

    static {
        SUPPORTED_ENCRYPTION_METHODS = ContentCryptoProvider.SUPPORTED_ENCRYPTION_METHODS;
        LinkedHashSet<JWEAlgorithm> linkedHashSet = new LinkedHashSet<JWEAlgorithm>();
        linkedHashSet.add(JWEAlgorithm.ECDH_1PU);
        linkedHashSet.add(JWEAlgorithm.ECDH_1PU_A128KW);
        linkedHashSet.add(JWEAlgorithm.ECDH_1PU_A192KW);
        linkedHashSet.add(JWEAlgorithm.ECDH_1PU_A256KW);
        SUPPORTED_ALGORITHMS = Collections.unmodifiableSet(linkedHashSet);
    }
}

