/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto;

import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.util.Collections;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.ActionRequiredForJWSCompletionException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.CompletableJWSObjectSigning;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSSigner;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSSignerOption;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.RSAKeyUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.RSASSA;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.RSASSAProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.opts.AllowWeakRSAKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.opts.OptionUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.opts.UserAuthenticationRequired;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.RSAKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.ThreadSafe;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;

@ThreadSafe
public class RSASSASigner
extends RSASSAProvider
implements JWSSigner {
    private final PrivateKey privateKey;
    private final Set<JWSSignerOption> opts;

    public RSASSASigner(PrivateKey privateKey) {
        this(privateKey, false);
    }

    @Deprecated
    public RSASSASigner(PrivateKey privateKey, boolean bl2) {
        this(privateKey, bl2 ? Collections.singleton(AllowWeakRSAKey.getInstance()) : Collections.emptySet());
    }

    public RSASSASigner(PrivateKey privateKey, Set<JWSSignerOption> set) {
        int n2;
        if (!(privateKey instanceof RSAPrivateKey) && !"RSA".equalsIgnoreCase(privateKey.getAlgorithm())) {
            throw new IllegalArgumentException("The private key algorithm must be RSA");
        }
        this.privateKey = privateKey;
        Set<JWSSignerOption> set2 = this.opts = set != null ? set : Collections.emptySet();
        if (!OptionUtils.optionIsPresent(this.opts, AllowWeakRSAKey.class) && (n2 = RSAKeyUtils.keyBitLength(privateKey)) > 0 && n2 < 2048) {
            throw new IllegalArgumentException("The RSA key size must be at least 2048 bits");
        }
    }

    public RSASSASigner(RSAKey rSAKey) throws JOSEException {
        this(rSAKey, null);
    }

    @Deprecated
    public RSASSASigner(RSAKey rSAKey, boolean bl2) throws JOSEException {
        this(RSAKeyUtils.toRSAPrivateKey(rSAKey), bl2);
    }

    public RSASSASigner(RSAKey rSAKey, Set<JWSSignerOption> set) throws JOSEException {
        this(RSAKeyUtils.toRSAPrivateKey(rSAKey), set);
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public Base64URL sign(JWSHeader jWSHeader, final byte[] byArray) throws JOSEException {
        final Signature signature = this.getInitiatedSignature(jWSHeader);
        if (OptionUtils.optionIsPresent(this.opts, UserAuthenticationRequired.class)) {
            throw new ActionRequiredForJWSCompletionException("Authenticate user to complete signing", UserAuthenticationRequired.getInstance(), new CompletableJWSObjectSigning(){

                @Override
                public Signature getInitializedSignature() {
                    return signature;
                }

                @Override
                public Base64URL complete() throws JOSEException {
                    return RSASSASigner.this.sign(byArray, signature);
                }
            });
        }
        return this.sign(byArray, signature);
    }

    private Signature getInitiatedSignature(JWSHeader jWSHeader) throws JOSEException {
        Signature signature = RSASSA.getSignerAndVerifier(jWSHeader.getAlgorithm(), this.getJCAContext().getProvider());
        try {
            signature.initSign(this.privateKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new JOSEException("Invalid private RSA key: " + invalidKeyException.getMessage(), invalidKeyException);
        }
        return signature;
    }

    private Base64URL sign(byte[] byArray, Signature signature) throws JOSEException {
        try {
            signature.update(byArray);
            return Base64URL.encode(signature.sign());
        }
        catch (SignatureException signatureException) {
            throw new JOSEException("RSA signature exception: " + signatureException.getMessage(), signatureException);
        }
    }
}

