/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import javax.crypto.SecretKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWECryptoParts;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEEncrypter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AAD;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.ECDH1PU;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.ECDH1PUCryptoProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.Curve;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.OctetKeyPair;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.gen.OctetKeyPairGenerator;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.ThreadSafe;

@ThreadSafe
public class ECDH1PUX25519Encrypter
extends ECDH1PUCryptoProvider
implements JWEEncrypter {
    private final OctetKeyPair publicKey;
    private final OctetKeyPair privateKey;

    public ECDH1PUX25519Encrypter(OctetKeyPair octetKeyPair, OctetKeyPair octetKeyPair2) throws JOSEException {
        this(octetKeyPair, octetKeyPair2, null);
    }

    public ECDH1PUX25519Encrypter(OctetKeyPair octetKeyPair, OctetKeyPair octetKeyPair2, SecretKey secretKey) throws JOSEException {
        super(octetKeyPair2.getCurve(), secretKey);
        this.publicKey = octetKeyPair2;
        this.privateKey = octetKeyPair;
    }

    @Override
    public Set<Curve> supportedEllipticCurves() {
        return Collections.singleton(Curve.X25519);
    }

    public OctetKeyPair getPublicKey() {
        return this.publicKey;
    }

    public OctetKeyPair getPrivateKey() {
        return this.privateKey;
    }

    @Deprecated
    public JWECryptoParts encrypt(JWEHeader jWEHeader, byte[] byArray) throws JOSEException {
        return this.encrypt(jWEHeader, byArray, AAD.compute(jWEHeader));
    }

    @Override
    public JWECryptoParts encrypt(JWEHeader jWEHeader, byte[] byArray, byte[] byArray2) throws JOSEException {
        OctetKeyPair octetKeyPair = new OctetKeyPairGenerator(this.getCurve()).generate();
        OctetKeyPair octetKeyPair2 = octetKeyPair.toPublicJWK();
        JWEHeader jWEHeader2 = new JWEHeader.Builder(jWEHeader).ephemeralPublicKey(octetKeyPair2).build();
        SecretKey secretKey = ECDH1PU.deriveSenderZ(this.privateKey, this.publicKey, octetKeyPair);
        byte[] byArray3 = Arrays.equals(AAD.compute(jWEHeader), byArray2) ? AAD.compute(jWEHeader2) : byArray2;
        return this.encryptWithZ(jWEHeader2, secretKey, byArray, byArray3);
    }
}

