/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.crypto.SecretKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWECryptoParts;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEEncrypter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AAD;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.ECDH1PU;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.ECDH1PUCryptoProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.Curve;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.ECKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.ThreadSafe;

@ThreadSafe
public class ECDH1PUEncrypter
extends ECDH1PUCryptoProvider
implements JWEEncrypter {
    public static final Set<Curve> SUPPORTED_ELLIPTIC_CURVES;
    private final ECPublicKey publicKey;
    private final ECPrivateKey privateKey;

    public ECDH1PUEncrypter(ECPrivateKey eCPrivateKey, ECPublicKey eCPublicKey) throws JOSEException {
        this(eCPrivateKey, eCPublicKey, null);
    }

    public ECDH1PUEncrypter(ECPrivateKey eCPrivateKey, ECPublicKey eCPublicKey, SecretKey secretKey) throws JOSEException {
        super(Curve.forECParameterSpec(eCPublicKey.getParams()), secretKey);
        this.privateKey = eCPrivateKey;
        this.publicKey = eCPublicKey;
    }

    public ECPublicKey getPublicKey() {
        return this.publicKey;
    }

    public ECPrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public Set<Curve> supportedEllipticCurves() {
        return SUPPORTED_ELLIPTIC_CURVES;
    }

    @Deprecated
    public JWECryptoParts encrypt(JWEHeader jWEHeader, byte[] byArray) throws JOSEException {
        return this.encrypt(jWEHeader, byArray, AAD.compute(jWEHeader));
    }

    @Override
    public JWECryptoParts encrypt(JWEHeader jWEHeader, byte[] byArray, byte[] byArray2) throws JOSEException {
        KeyPair keyPair = this.generateEphemeralKeyPair(this.publicKey.getParams());
        ECPublicKey eCPublicKey = (ECPublicKey)keyPair.getPublic();
        ECPrivateKey eCPrivateKey = (ECPrivateKey)keyPair.getPrivate();
        JWEHeader jWEHeader2 = new JWEHeader.Builder(jWEHeader).ephemeralPublicKey(new ECKey.Builder(this.getCurve(), eCPublicKey).build()).build();
        SecretKey secretKey = ECDH1PU.deriveSenderZ(this.privateKey, this.publicKey, eCPrivateKey, this.getJCAContext().getKeyEncryptionProvider());
        byte[] byArray3 = Arrays.equals(AAD.compute(jWEHeader), byArray2) ? AAD.compute(jWEHeader2) : byArray2;
        return this.encryptWithZ(jWEHeader2, secretKey, byArray, byArray3);
    }

    private KeyPair generateEphemeralKeyPair(ECParameterSpec eCParameterSpec) throws JOSEException {
        Provider provider = this.getJCAContext().getKeyEncryptionProvider();
        try {
            KeyPairGenerator keyPairGenerator = provider != null ? KeyPairGenerator.getInstance("EC", provider) : KeyPairGenerator.getInstance("EC");
            keyPairGenerator.initialize(eCParameterSpec);
            return keyPairGenerator.generateKeyPair();
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException generalSecurityException) {
            throw new JOSEException("Couldn't generate ephemeral EC key pair: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    static {
        LinkedHashSet<Curve> linkedHashSet = new LinkedHashSet<Curve>();
        linkedHashSet.add(Curve.P_256);
        linkedHashSet.add(Curve.P_384);
        linkedHashSet.add(Curve.P_521);
        SUPPORTED_ELLIPTIC_CURVES = Collections.unmodifiableSet(linkedHashSet);
    }
}

