/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Algorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.HeaderValidation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.IllegalHeaderException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEObjectType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.PlainHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.UnprotectedHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.JSONObjectUtils;

public abstract class Header
implements Serializable {
    public static final int MAX_HEADER_STRING_LENGTH = 20000;
    private static final long serialVersionUID = 1L;
    private final Algorithm alg;
    private final JOSEObjectType typ;
    private final String cty;
    private final Set<String> crit;
    private final Map<String, Object> customParams;
    private static final Map<String, Object> EMPTY_CUSTOM_PARAMS = Collections.unmodifiableMap(new HashMap());
    private final Base64URL parsedBase64URL;

    protected Header(Algorithm algorithm, JOSEObjectType jOSEObjectType, String string, Set<String> set, Map<String, Object> map, Base64URL base64URL) {
        this.alg = algorithm;
        this.typ = jOSEObjectType;
        this.cty = string;
        this.crit = set != null ? Collections.unmodifiableSet(new HashSet<String>(set)) : null;
        this.customParams = map != null ? Collections.unmodifiableMap(new HashMap<String, Object>(map)) : EMPTY_CUSTOM_PARAMS;
        this.parsedBase64URL = base64URL;
    }

    protected Header(Header header) {
        this(header.getAlgorithm(), header.getType(), header.getContentType(), header.getCriticalParams(), header.getCustomParams(), header.getParsedBase64URL());
    }

    public Algorithm getAlgorithm() {
        return this.alg;
    }

    public JOSEObjectType getType() {
        return this.typ;
    }

    public String getContentType() {
        return this.cty;
    }

    public Set<String> getCriticalParams() {
        return this.crit;
    }

    public Object getCustomParam(String string) {
        return this.customParams.get(string);
    }

    public Map<String, Object> getCustomParams() {
        return this.customParams;
    }

    public Base64URL getParsedBase64URL() {
        return this.parsedBase64URL;
    }

    public Set<String> getIncludedParams() {
        HashSet<String> hashSet = new HashSet<String>(this.getCustomParams().keySet());
        if (this.getAlgorithm() != null) {
            hashSet.add("alg");
        }
        if (this.getType() != null) {
            hashSet.add("typ");
        }
        if (this.getContentType() != null) {
            hashSet.add("cty");
        }
        if (this.getCriticalParams() != null && !this.getCriticalParams().isEmpty()) {
            hashSet.add("crit");
        }
        return hashSet;
    }

    public Map<String, Object> toJSONObject() {
        Map<String, Object> map = JSONObjectUtils.newJSONObject();
        map.putAll(this.customParams);
        if (this.alg != null) {
            map.put("alg", this.alg.toString());
        }
        if (this.typ != null) {
            map.put("typ", this.typ.toString());
        }
        if (this.cty != null) {
            map.put("cty", this.cty);
        }
        if (this.crit != null && !this.crit.isEmpty()) {
            map.put("crit", new ArrayList<String>(this.crit));
        }
        return map;
    }

    public String toString() {
        return JSONObjectUtils.toJSONString(this.toJSONObject());
    }

    public Base64URL toBase64URL() {
        if (this.parsedBase64URL == null) {
            return Base64URL.encode(this.toString());
        }
        return this.parsedBase64URL;
    }

    public static Algorithm parseAlgorithm(Map<String, Object> map) throws ParseException {
        String string = JSONObjectUtils.getString(map, "alg");
        if (string == null) {
            throw new ParseException("Missing \"alg\" in header JSON object", 0);
        }
        if (string.equals(Algorithm.NONE.getName())) {
            return Algorithm.NONE;
        }
        if (map.containsKey("enc")) {
            return JWEAlgorithm.parse(string);
        }
        return JWSAlgorithm.parse(string);
    }

    public Header join(UnprotectedHeader unprotectedHeader) throws ParseException {
        Map<String, Object> map = this.toJSONObject();
        try {
            HeaderValidation.ensureDisjoint(this, unprotectedHeader);
        }
        catch (IllegalHeaderException illegalHeaderException) {
            throw new ParseException(illegalHeaderException.getMessage(), 0);
        }
        if (unprotectedHeader != null) {
            map.putAll(unprotectedHeader.toJSONObject());
        }
        return Header.parse(map, null);
    }

    public static Header parse(Map<String, Object> map) throws ParseException {
        return Header.parse(map, null);
    }

    public static Header parse(Map<String, Object> map, Base64URL base64URL) throws ParseException {
        String string = JSONObjectUtils.getString(map, "alg");
        if (map.containsKey("enc")) {
            return JWEHeader.parse(map, base64URL);
        }
        if (Algorithm.NONE.getName().equals(string)) {
            return PlainHeader.parse(map, base64URL);
        }
        if (map.containsKey("alg")) {
            return JWSHeader.parse(map, base64URL);
        }
        throw new ParseException("Missing \"alg\" in header JSON object", 0);
    }

    public static Header parse(String string) throws ParseException {
        return Header.parse(string, null);
    }

    public static Header parse(String string, Base64URL base64URL) throws ParseException {
        Map<String, Object> map = JSONObjectUtils.parse(string, 20000);
        return Header.parse(map, base64URL);
    }

    public static Header parse(Base64URL base64URL) throws ParseException {
        return Header.parse(base64URL.decodeToString(), base64URL);
    }
}

