/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AbstractManagedIdentitySource;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AppServiceManagedIdentitySource;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AzureArcManagedIdentitySource;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.CloudShellManagedIdentitySource;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IEnvironmentVariables;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IMDSManagedIdentitySource;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ManagedIdentityApplication;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ManagedIdentityIdType;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ManagedIdentityParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ManagedIdentityResponse;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ManagedIdentitySourceType;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ServiceBundle;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ServiceFabricManagedIdentitySource;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.StringHelper;
import macromedia.jdbc.sqlserver.externals.org.slf4j.Logger;
import macromedia.jdbc.sqlserver.externals.org.slf4j.LoggerFactory;

class ManagedIdentityClient {
    private static final Logger LOG = LoggerFactory.getLogger(ManagedIdentityClient.class);
    private static ManagedIdentitySourceType managedIdentitySourceType;
    AbstractManagedIdentitySource managedIdentitySource;

    protected static void resetManagedIdentitySourceType() {
        managedIdentitySourceType = ManagedIdentitySourceType.NONE;
    }

    static ManagedIdentitySourceType getManagedIdentitySource() {
        if (managedIdentitySourceType != null && managedIdentitySourceType != ManagedIdentitySourceType.NONE) {
            return managedIdentitySourceType;
        }
        IEnvironmentVariables iEnvironmentVariables = AbstractManagedIdentitySource.getEnvironmentVariables();
        managedIdentitySourceType = !StringHelper.isNullOrBlank(iEnvironmentVariables.getEnvironmentVariable("IDENTITY_ENDPOINT")) && !StringHelper.isNullOrBlank(iEnvironmentVariables.getEnvironmentVariable("IDENTITY_HEADER")) ? (!StringHelper.isNullOrBlank(iEnvironmentVariables.getEnvironmentVariable("IDENTITY_SERVER_THUMBPRINT")) ? ManagedIdentitySourceType.SERVICE_FABRIC : ManagedIdentitySourceType.APP_SERVICE) : (!StringHelper.isNullOrBlank(iEnvironmentVariables.getEnvironmentVariable("MSI_ENDPOINT")) ? ManagedIdentitySourceType.CLOUD_SHELL : (!StringHelper.isNullOrBlank(iEnvironmentVariables.getEnvironmentVariable("IDENTITY_ENDPOINT")) && !StringHelper.isNullOrBlank(iEnvironmentVariables.getEnvironmentVariable("IMDS_ENDPOINT")) ? ManagedIdentitySourceType.AZURE_ARC : ManagedIdentitySourceType.DEFAULT_TO_IMDS));
        return managedIdentitySourceType;
    }

    ManagedIdentityClient(MsalRequest msalRequest, ServiceBundle serviceBundle) {
        this.managedIdentitySource = ManagedIdentityClient.createManagedIdentitySource(msalRequest, serviceBundle);
        ManagedIdentityApplication managedIdentityApplication = (ManagedIdentityApplication)msalRequest.application();
        ManagedIdentityIdType managedIdentityIdType = managedIdentityApplication.getManagedIdentityId().getIdType();
        if (!managedIdentityIdType.equals((Object)ManagedIdentityIdType.SYSTEM_ASSIGNED)) {
            this.managedIdentitySource.setUserAssignedManagedIdentity(true);
            String string = managedIdentityApplication.getManagedIdentityId().getUserAssignedId();
            if (managedIdentityIdType.equals((Object)ManagedIdentityIdType.CLIENT_ID)) {
                this.managedIdentitySource.setManagedIdentityUserAssignedClientId(string);
            } else if (managedIdentityIdType.equals((Object)ManagedIdentityIdType.RESOURCE_ID)) {
                this.managedIdentitySource.setManagedIdentityUserAssignedResourceId(string);
            }
        }
    }

    ManagedIdentityResponse getManagedIdentityResponse(ManagedIdentityParameters managedIdentityParameters) {
        return this.managedIdentitySource.getManagedIdentityResponse(managedIdentityParameters);
    }

    private static AbstractManagedIdentitySource createManagedIdentitySource(MsalRequest msalRequest, ServiceBundle serviceBundle) {
        if (managedIdentitySourceType == null || managedIdentitySourceType == ManagedIdentitySourceType.NONE) {
            managedIdentitySourceType = ManagedIdentityClient.getManagedIdentitySource();
        }
        switch (managedIdentitySourceType) {
            case SERVICE_FABRIC: {
                return ServiceFabricManagedIdentitySource.create(msalRequest, serviceBundle);
            }
            case APP_SERVICE: {
                return AppServiceManagedIdentitySource.create(msalRequest, serviceBundle);
            }
            case CLOUD_SHELL: {
                return CloudShellManagedIdentitySource.create(msalRequest, serviceBundle);
            }
            case AZURE_ARC: {
                return AzureArcManagedIdentitySource.create(msalRequest, serviceBundle);
            }
        }
        return new IMDSManagedIdentitySource(msalRequest, serviceBundle);
    }
}

