/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.RequestContext;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.StringHelper;

final class HttpHeaders {
    static final String PRODUCT_HEADER_NAME = "x-client-SKU";
    static final String PRODUCT_HEADER_VALUE = "MSAL.Java";
    static final String PRODUCT_VERSION_HEADER_NAME = "x-client-VER";
    static final String PRODUCT_VERSION_HEADER_VALUE = HttpHeaders.getProductVersion();
    static final String OS_HEADER_NAME = "x-client-OS";
    static final String OS_HEADER_VALUE = System.getProperty("os.name");
    static final String APPLICATION_NAME_HEADER_NAME = "x-app-name";
    private final String applicationNameHeaderValue;
    static final String APPLICATION_VERSION_HEADER_NAME = "x-app-ver";
    private final String applicationVersionHeaderValue;
    static final String CORRELATION_ID_HEADER_NAME = "client-request-id";
    private final String correlationIdHeaderValue;
    private static final String REQUEST_CORRELATION_ID_IN_RESPONSE_HEADER_NAME = "return-client-request-id";
    private static final String REQUEST_CORRELATION_ID_IN_RESPONSE_HEADER_VALUE = "true";
    private static final String X_MS_LIB_CAPABILITY_NAME = "x-ms-lib-capability";
    private static final String X_MS_LIB_CAPABILITY_VALUE = "retry-after, h429";
    static final String X_ANCHOR_MAILBOX = "X-AnchorMailbox";
    static final String X_ANCHOR_MAILBOX_OID_FORMAT = "oid:%s";
    static final String X_ANCHOR_MAILBOX_UPN_FORMAT = "upn:%s";
    private String anchorMailboxHeaderValue = null;
    private String headerValues;
    private Map<String, String> headerMap = new HashMap<String, String>();

    HttpHeaders(RequestContext requestContext) {
        String string;
        this.correlationIdHeaderValue = requestContext.correlationId();
        this.applicationNameHeaderValue = requestContext.applicationName();
        this.applicationVersionHeaderValue = requestContext.applicationVersion();
        if (requestContext.userIdentifier() != null) {
            string = requestContext.userIdentifier().upn();
            String string2 = requestContext.userIdentifier().oid();
            if (!StringHelper.isBlank(string)) {
                this.anchorMailboxHeaderValue = String.format(X_ANCHOR_MAILBOX_UPN_FORMAT, string);
            } else if (!StringHelper.isBlank(string2)) {
                this.anchorMailboxHeaderValue = String.format(X_ANCHOR_MAILBOX_OID_FORMAT, string2);
            }
        }
        string = requestContext.apiParameters() == null ? null : requestContext.apiParameters().extraHttpHeaders();
        this.initializeHeaders((Map<String, String>)((Object)string));
    }

    private void initializeHeaders(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        BiConsumer<String, String> biConsumer = (string, string2) -> {
            this.headerMap.put((String)string, (String)string2);
            stringBuilder.append((String)string).append("=").append((String)string2).append(";");
        };
        biConsumer.accept(PRODUCT_HEADER_NAME, PRODUCT_HEADER_VALUE);
        biConsumer.accept(PRODUCT_VERSION_HEADER_NAME, PRODUCT_VERSION_HEADER_VALUE);
        biConsumer.accept(OS_HEADER_NAME, OS_HEADER_VALUE);
        biConsumer.accept(REQUEST_CORRELATION_ID_IN_RESPONSE_HEADER_NAME, REQUEST_CORRELATION_ID_IN_RESPONSE_HEADER_VALUE);
        biConsumer.accept(CORRELATION_ID_HEADER_NAME, this.correlationIdHeaderValue);
        if (!StringHelper.isBlank(this.applicationNameHeaderValue)) {
            biConsumer.accept(APPLICATION_NAME_HEADER_NAME, this.applicationNameHeaderValue);
        }
        if (!StringHelper.isBlank(this.applicationVersionHeaderValue)) {
            biConsumer.accept(APPLICATION_VERSION_HEADER_NAME, this.applicationVersionHeaderValue);
        }
        if (!StringHelper.isBlank(this.anchorMailboxHeaderValue)) {
            biConsumer.accept(X_ANCHOR_MAILBOX, this.anchorMailboxHeaderValue);
        }
        biConsumer.accept(X_MS_LIB_CAPABILITY_NAME, X_MS_LIB_CAPABILITY_VALUE);
        if (map != null) {
            map.forEach(biConsumer);
        }
        this.headerValues = stringBuilder.toString();
    }

    Map<String, String> getReadonlyHeaderMap() {
        return Collections.unmodifiableMap(this.headerMap);
    }

    String getHeaderCorrelationIdValue() {
        return this.correlationIdHeaderValue;
    }

    public String toString() {
        return this.headerValues;
    }

    private static String getProductVersion() {
        if (HttpHeaders.class.getPackage().getImplementationVersion() == null) {
            return "1.0";
        }
        return HttpHeaders.class.getPackage().getImplementationVersion();
    }
}

