/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.net.URI;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AadInstanceDiscoveryProvider;

abstract class Event
extends HashMap<String, String> {
    static final String EVENT_NAME_KEY = "event_name";
    static final String START_TIME_KEY = "start_time";
    static final String ELAPSED_TIME_KEY = "elapsed_time";
    private static final String TENANT_PLACEHOLDER = "<tenant>";
    private static final String USERNAME_PLACEHOLDER = "<user>";
    private long startTimeStamp;

    Event(String string) {
        this(string, new HashMap<String, String>());
    }

    Event(String string, Map<String, String> map) {
        super(map);
        this.put(EVENT_NAME_KEY, string);
        this.startTimeStamp = Instant.now().toEpochMilli();
        this.put(START_TIME_KEY, Long.toString(this.startTimeStamp));
        this.put(ELAPSED_TIME_KEY, "-1");
    }

    void stop() {
        long l2 = Instant.now().toEpochMilli() - this.startTimeStamp;
        this.put(ELAPSED_TIME_KEY, Long.toString(l2));
    }

    static String scrubTenant(URI uRI) {
        if (!uRI.isAbsolute()) {
            throw new IllegalArgumentException("Requires an absolute URI");
        }
        if (!AadInstanceDiscoveryProvider.TRUSTED_HOSTS_SET.contains(uRI.getHost())) {
            return null;
        }
        CharSequence[] charSequenceArray = uRI.getPath().split("/");
        if (charSequenceArray.length >= 2) {
            if (charSequenceArray[1].equals("tfp") && charSequenceArray.length >= 3) {
                charSequenceArray[2] = TENANT_PLACEHOLDER;
            } else {
                charSequenceArray[1] = TENANT_PLACEHOLDER;
            }
            if (charSequenceArray.length >= 4 && ((String)charSequenceArray[2]).equals("userrealm")) {
                charSequenceArray[3] = USERNAME_PLACEHOLDER;
            }
        }
        String string = String.join((CharSequence)"/", charSequenceArray);
        return uRI.getScheme() + "://" + uRI.getAuthority() + string;
    }
}

