/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.Authority;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClaimsRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.JsonHelper;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalClientException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ParameterValidationUtils;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.Prompt;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ResponseMode;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URLUtils;
import macromedia.jdbc.sqlserver.externals.org.slf4j.Logger;
import macromedia.jdbc.sqlserver.externals.org.slf4j.LoggerFactory;

public class AuthorizationRequestUrlParameters {
    @NonNull
    private String redirectUri;
    @NonNull
    private Set<String> scopes;
    private String codeChallenge;
    private String codeChallengeMethod;
    private String state;
    private String nonce;
    private ResponseMode responseMode;
    private String loginHint;
    private String domainHint;
    private Prompt prompt;
    private String correlationId;
    private boolean instanceAware;
    private static final String ADMIN_CONSENT_ENDPOINT = "https://login.microsoftonline.com/{tenant}/adminconsent";
    Map<String, String> extraQueryParameters;
    Map<String, List<String>> requestParameters = new HashMap<String, List<String>>();
    Logger log = LoggerFactory.getLogger(AuthorizationRequestUrlParameters.class);

    public static Builder builder(String string, Set<String> set) {
        ParameterValidationUtils.validateNotBlank("redirect_uri", string);
        ParameterValidationUtils.validateNotNull("scopes", set);
        return AuthorizationRequestUrlParameters.builder().redirectUri(string).scopes(set);
    }

    private static Builder builder() {
        return new Builder();
    }

    private AuthorizationRequestUrlParameters(Builder builder) {
        Object object;
        this.redirectUri = builder.redirectUri;
        this.requestParameters.put("redirect_uri", Collections.singletonList(this.redirectUri));
        this.scopes = builder.scopes;
        String[] stringArray = "openid profile offline_access".split(" ");
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(Arrays.asList(stringArray));
        linkedHashSet.addAll(builder.scopes);
        if (builder.extraScopesToConsent != null) {
            linkedHashSet.addAll(builder.extraScopesToConsent);
        }
        this.scopes = linkedHashSet;
        this.requestParameters.put("scope", Collections.singletonList(String.join((CharSequence)" ", linkedHashSet)));
        this.requestParameters.put("response_type", Collections.singletonList("code"));
        if (builder.claims != null) {
            object = String.join((CharSequence)" ", builder.claims);
            this.requestParameters.put("claims", Collections.singletonList(object));
        }
        if (builder.claimsChallenge != null && builder.claimsChallenge.trim().length() > 0) {
            JsonHelper.validateJsonFormat(builder.claimsChallenge);
            this.requestParameters.put("claims", Collections.singletonList(builder.claimsChallenge));
        }
        if (builder.claimsRequest != null) {
            object = builder.claimsRequest.formatAsJSONString();
            if (this.requestParameters.get("claims") != null) {
                object = JsonHelper.mergeJSONString((String)object, this.requestParameters.get("claims").get(0));
            }
            this.requestParameters.put("claims", Collections.singletonList(object));
        }
        if (builder.codeChallenge != null) {
            this.codeChallenge = builder.codeChallenge;
            this.requestParameters.put("code_challenge", Collections.singletonList(builder.codeChallenge));
        }
        if (builder.codeChallengeMethod != null) {
            this.codeChallengeMethod = builder.codeChallengeMethod;
            this.requestParameters.put("code_challenge_method", Collections.singletonList(builder.codeChallengeMethod));
        }
        if (builder.state != null) {
            this.state = builder.state;
            this.requestParameters.put("state", Collections.singletonList(builder.state));
        }
        if (builder.nonce != null) {
            this.nonce = builder.nonce;
            this.requestParameters.put("nonce", Collections.singletonList(builder.nonce));
        }
        if (builder.responseMode != null) {
            this.responseMode = builder.responseMode;
            this.requestParameters.put("response_mode", Collections.singletonList(builder.responseMode.toString()));
        } else {
            this.responseMode = ResponseMode.FORM_POST;
            this.requestParameters.put("response_mode", Collections.singletonList(ResponseMode.FORM_POST.toString()));
        }
        if (builder.loginHint != null) {
            this.loginHint = this.loginHint();
            this.requestParameters.put("login_hint", Collections.singletonList(builder.loginHint));
            this.requestParameters.put("X-AnchorMailbox", Collections.singletonList(String.format("upn:%s", builder.loginHint)));
        }
        if (builder.domainHint != null) {
            this.domainHint = this.domainHint();
            this.requestParameters.put("domain_hint", Collections.singletonList(builder.domainHint));
        }
        if (builder.prompt != null) {
            this.prompt = builder.prompt;
            this.requestParameters.put("prompt", Collections.singletonList(builder.prompt.toString()));
        }
        if (builder.correlationId != null) {
            this.correlationId = builder.correlationId;
            this.requestParameters.put("correlation_id", Collections.singletonList(builder.correlationId));
        }
        if (builder.instanceAware) {
            this.instanceAware = builder.instanceAware;
            this.requestParameters.put("instance_aware", Collections.singletonList(String.valueOf(this.instanceAware)));
        }
        if (null != builder.extraQueryParameters && !builder.extraQueryParameters.isEmpty()) {
            this.extraQueryParameters = builder.extraQueryParameters;
            for (Map.Entry entry : this.extraQueryParameters.entrySet()) {
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                if (this.requestParameters.containsKey(string)) {
                    this.log.warn("A query parameter {} has been provided with values multiple times.", (Object)string);
                }
                this.requestParameters.put(string, Collections.singletonList(string2));
            }
        }
    }

    URL createAuthorizationURL(Authority authority, Map<String, List<String>> map) {
        URL uRL;
        try {
            String string = this.prompt == Prompt.ADMIN_CONSENT ? ADMIN_CONSENT_ENDPOINT.replace("{tenant}", authority.tenant) : authority.authorizationEndpoint();
            String string2 = string + "?" + URLUtils.serializeParameters(map);
            uRL = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            throw new MsalClientException(malformedURLException);
        }
        return uRL;
    }

    @NonNull
    public String redirectUri() {
        return this.redirectUri;
    }

    @NonNull
    public Set<String> scopes() {
        return this.scopes;
    }

    public String codeChallenge() {
        return this.codeChallenge;
    }

    public String codeChallengeMethod() {
        return this.codeChallengeMethod;
    }

    public String state() {
        return this.state;
    }

    public String nonce() {
        return this.nonce;
    }

    public ResponseMode responseMode() {
        return this.responseMode;
    }

    public String loginHint() {
        return this.loginHint;
    }

    public String domainHint() {
        return this.domainHint;
    }

    public Prompt prompt() {
        return this.prompt;
    }

    public String correlationId() {
        return this.correlationId;
    }

    public boolean instanceAware() {
        return this.instanceAware;
    }

    public Map<String, String> extraQueryParameters() {
        return this.extraQueryParameters;
    }

    public Map<String, List<String>> requestParameters() {
        return this.requestParameters;
    }

    public Logger log() {
        return this.log;
    }

    public static class Builder {
        private String redirectUri;
        private Set<String> scopes;
        private Set<String> extraScopesToConsent;
        private Set<String> claims;
        private String claimsChallenge;
        private ClaimsRequest claimsRequest;
        private String codeChallenge;
        private String codeChallengeMethod;
        private String state;
        private String nonce;
        private ResponseMode responseMode;
        private String loginHint;
        private String domainHint;
        private Prompt prompt;
        private String correlationId;
        private boolean instanceAware;
        private Map<String, String> extraQueryParameters;

        public AuthorizationRequestUrlParameters build() {
            return new AuthorizationRequestUrlParameters(this);
        }

        private Builder self() {
            return this;
        }

        public Builder redirectUri(String string) {
            this.redirectUri = string;
            return this.self();
        }

        public Builder scopes(Set<String> set) {
            this.scopes = set;
            return this.self();
        }

        public Builder extraScopesToConsent(Set<String> set) {
            this.extraScopesToConsent = set;
            return this.self();
        }

        public Builder claimsChallenge(String string) {
            this.claimsChallenge = string;
            return this.self();
        }

        public Builder claims(ClaimsRequest claimsRequest) {
            this.claimsRequest = claimsRequest;
            return this.self();
        }

        public Builder codeChallenge(String string) {
            this.codeChallenge = string;
            return this.self();
        }

        public Builder codeChallengeMethod(String string) {
            this.codeChallengeMethod = string;
            return this.self();
        }

        public Builder state(String string) {
            this.state = string;
            return this.self();
        }

        public Builder nonce(String string) {
            this.nonce = string;
            return this.self();
        }

        public Builder responseMode(ResponseMode responseMode) {
            this.responseMode = responseMode;
            return this.self();
        }

        public Builder loginHint(String string) {
            this.loginHint = string;
            return this.self();
        }

        public Builder domainHint(String string) {
            this.domainHint = string;
            return this.self();
        }

        public Builder prompt(Prompt prompt) {
            this.prompt = prompt;
            return this.self();
        }

        public Builder correlationId(String string) {
            this.correlationId = string;
            return this.self();
        }

        public Builder instanceAware(boolean bl2) {
            this.instanceAware = bl2;
            return this.self();
        }

        public Builder extraQueryParameters(Map<String, String> map) {
            this.extraQueryParameters = map;
            return this.self();
        }
    }
}

