/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.concurrent.CompletionException;
import java.util.function.Supplier;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AadInstanceDiscoveryProvider;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AbstractApplicationBase;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ApiEvent;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthenticationResult;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.Authority;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ConfidentialClientApplication;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpHeaders;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IAuthenticationResult;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.InstanceDiscoveryMetadataEntry;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.LogHelper;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.StringHelper;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.TelemetryHelper;

abstract class AuthenticationResultSupplier
implements Supplier<IAuthenticationResult> {
    AbstractApplicationBase clientApplication;
    MsalRequest msalRequest;

    AuthenticationResultSupplier(AbstractApplicationBase abstractApplicationBase, MsalRequest msalRequest) {
        this.clientApplication = abstractApplicationBase;
        this.msalRequest = msalRequest;
    }

    Authority getAuthorityWithPrefNetworkHost(String string) throws MalformedURLException {
        URL uRL = new URL(string);
        if (this.msalRequest.requestContext().apiParameters().tenant() != null) {
            uRL = new URL(string.replace(Authority.getTenant(uRL, Authority.detectAuthorityType(uRL)), this.msalRequest.requestContext().apiParameters().tenant()));
        }
        InstanceDiscoveryMetadataEntry instanceDiscoveryMetadataEntry = AadInstanceDiscoveryProvider.getMetadataEntry(uRL, this.clientApplication.validateAuthority(), this.msalRequest, this.clientApplication.serviceBundle());
        URL uRL2 = new URL(uRL.getProtocol(), instanceDiscoveryMetadataEntry.preferredNetwork, uRL.getPort(), uRL.getFile());
        return Authority.createAuthority(uRL2);
    }

    abstract AuthenticationResult execute() throws Exception;

    @Override
    public IAuthenticationResult get() {
        AuthenticationResult authenticationResult;
        ApiEvent apiEvent = this.initializeApiEvent(this.msalRequest);
        try (TelemetryHelper telemetryHelper = this.clientApplication.serviceBundle().getTelemetryManager().createTelemetryHelper(this.msalRequest.requestContext().telemetryRequestId(), this.msalRequest.application().clientId(), apiEvent, true);){
            try {
                authenticationResult = this.execute();
                apiEvent.setWasSuccessful(true);
                if (authenticationResult != null) {
                    this.logResult(authenticationResult, this.msalRequest.headers());
                    if (authenticationResult.account() != null) {
                        apiEvent.setTenantId(authenticationResult.accountCacheEntity().realm());
                    }
                }
            }
            catch (Exception exception) {
                String string = StringHelper.EMPTY_STRING;
                if (exception instanceof MsalException) {
                    MsalException msalException = (MsalException)exception;
                    if (msalException.errorCode() != null) {
                        apiEvent.setApiErrorCode(msalException.errorCode());
                    }
                } else if (exception.getCause() != null) {
                    string = exception.getCause().toString();
                }
                this.clientApplication.serviceBundle().getServerSideTelemetry().addFailedRequestTelemetry(String.valueOf(this.msalRequest.requestContext().publicApi().getApiId()), this.msalRequest.requestContext().correlationId(), string);
                this.clientApplication.log.warn(LogHelper.createMessage(String.format("Execution of %s failed: %s", this.getClass(), exception.getMessage()), this.msalRequest.headers().getHeaderCorrelationIdValue()));
                throw new CompletionException(exception);
            }
        }
        return authenticationResult;
    }

    private void logResult(AuthenticationResult authenticationResult, HttpHeaders httpHeaders) {
        if (!StringHelper.isBlank(authenticationResult.accessToken())) {
            String string = this.computeSha256Hash(authenticationResult.accessToken());
            if (!StringHelper.isBlank(authenticationResult.refreshToken())) {
                String string2 = this.computeSha256Hash(authenticationResult.refreshToken());
                if (this.clientApplication.logPii()) {
                    this.clientApplication.log.debug(LogHelper.createMessage(String.format("Access Token with hash '%s' and Refresh Token with hash '%s' returned", string, string2), httpHeaders.getHeaderCorrelationIdValue()));
                } else {
                    this.clientApplication.log.debug(LogHelper.createMessage("Access Token and Refresh Token were returned", httpHeaders.getHeaderCorrelationIdValue()));
                }
            } else if (this.clientApplication.logPii()) {
                this.clientApplication.log.debug(LogHelper.createMessage(String.format("Access Token with hash '%s' returned", string), httpHeaders.getHeaderCorrelationIdValue()));
            } else {
                this.clientApplication.log.debug(LogHelper.createMessage("Access Token was returned", httpHeaders.getHeaderCorrelationIdValue()));
            }
        }
    }

    private ApiEvent initializeApiEvent(MsalRequest msalRequest) {
        ApiEvent apiEvent = new ApiEvent(this.clientApplication.logPii());
        msalRequest.requestContext().telemetryRequestId(this.clientApplication.serviceBundle().getTelemetryManager().generateRequestId());
        apiEvent.setApiId(msalRequest.requestContext().publicApi().getApiId());
        apiEvent.setCorrelationId(msalRequest.requestContext().correlationId());
        apiEvent.setRequestId(msalRequest.requestContext().telemetryRequestId());
        apiEvent.setWasSuccessful(false);
        apiEvent.setIsConfidentialClient(this.clientApplication instanceof ConfidentialClientApplication);
        try {
            Authority authority = this.clientApplication.authenticationAuthority;
            if (authority != null) {
                apiEvent.setAuthority(new URI(authority.authority()));
                apiEvent.setAuthorityType(authority.authorityType().toString());
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            this.clientApplication.log.warn(LogHelper.createMessage("Setting URL telemetry fields failed: " + LogHelper.getPiiScrubbedDetails(uRISyntaxException), msalRequest.headers().getHeaderCorrelationIdValue()));
        }
        return apiEvent;
    }

    private String computeSha256Hash(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(string.getBytes(StandardCharsets.UTF_8));
            byte[] byArray = messageDigest.digest();
            return Base64.getUrlEncoder().encodeToString(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.clientApplication.log.warn(LogHelper.createMessage("Failed to compute SHA-256 hash due to exception - ", LogHelper.getPiiScrubbedDetails(noSuchAlgorithmException)));
            return "Failed to compute SHA-256 hash";
        }
    }
}

