/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AbstractManagedIdentitySource;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpMethod;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IEnvironmentVariables;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ManagedIdentitySourceType;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalServiceException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ServiceBundle;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.StringHelper;
import macromedia.jdbc.sqlserver.externals.org.slf4j.Logger;
import macromedia.jdbc.sqlserver.externals.org.slf4j.LoggerFactory;

class AppServiceManagedIdentitySource
extends AbstractManagedIdentitySource {
    private static final Logger LOG = LoggerFactory.getLogger(AppServiceManagedIdentitySource.class);
    private static final String APP_SERVICE_MSI_API_VERSION = "2019-08-01";
    private static final String SECRET_HEADER_NAME = "X-IDENTITY-HEADER";
    private final URI msiEndpoint;
    private final String identityHeader;

    @Override
    public void createManagedIdentityRequest(String string) {
        this.managedIdentityRequest.baseEndpoint = this.msiEndpoint;
        this.managedIdentityRequest.method = HttpMethod.GET;
        this.managedIdentityRequest.headers = new HashMap<String, String>();
        this.managedIdentityRequest.headers.put(SECRET_HEADER_NAME, this.identityHeader);
        this.managedIdentityRequest.queryParameters = new HashMap<String, List<String>>();
        this.managedIdentityRequest.queryParameters.put("api-version", Collections.singletonList(APP_SERVICE_MSI_API_VERSION));
        this.managedIdentityRequest.queryParameters.put("resource", Collections.singletonList(string));
        if (!StringHelper.isNullOrBlank(this.getManagedIdentityUserAssignedClientId())) {
            LOG.info("[Managed Identity] Adding user assigned client id to the request.");
            this.managedIdentityRequest.queryParameters.put("client_id", Collections.singletonList(this.getManagedIdentityUserAssignedClientId()));
        }
        if (!StringHelper.isNullOrBlank(this.getManagedIdentityUserAssignedResourceId())) {
            LOG.info("[Managed Identity] Adding user assigned resource id to the request.");
            this.managedIdentityRequest.queryParameters.put("mi_res_id", Collections.singletonList(this.getManagedIdentityUserAssignedResourceId()));
        }
    }

    private AppServiceManagedIdentitySource(MsalRequest msalRequest, ServiceBundle serviceBundle, URI uRI, String string) {
        super(msalRequest, serviceBundle, ManagedIdentitySourceType.APP_SERVICE);
        this.msiEndpoint = uRI;
        this.identityHeader = string;
    }

    static AbstractManagedIdentitySource create(MsalRequest msalRequest, ServiceBundle serviceBundle) {
        IEnvironmentVariables iEnvironmentVariables = AppServiceManagedIdentitySource.getEnvironmentVariables();
        String string = iEnvironmentVariables.getEnvironmentVariable("IDENTITY_HEADER");
        String string2 = iEnvironmentVariables.getEnvironmentVariable("IDENTITY_ENDPOINT");
        URI uRI = AppServiceManagedIdentitySource.validateAndGetUri(string2, string);
        return uRI == null ? null : new AppServiceManagedIdentitySource(msalRequest, serviceBundle, uRI, string);
    }

    private static URI validateAndGetUri(String string, String string2) {
        URI uRI;
        if (StringHelper.isNullOrBlank(string) || StringHelper.isNullOrBlank(string2)) {
            LOG.info("[Managed Identity] App service managed identity is unavailable.");
            return null;
        }
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new MsalServiceException(String.format("[Managed Identity] The environment variable %s contains an invalid Uri %s in %s managed identity source.", "IDENTITY_ENDPOINT", string, "App Service"), "invalid_managed_identity_endpoint", ManagedIdentitySourceType.APP_SERVICE);
        }
        LOG.info("[Managed Identity] Environment variables validation passed for app service managed identity. Endpoint URI: {endpointUri}. Creating App Service managed identity.");
        return uRI;
    }
}

